/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.widget.SpriteButton;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogContent;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogItemEntry;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogListPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogRequestListPacket;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogSorting;
import com.github.minecraftschurlimods.bibliocraft.content.stockroomcatalog.StockroomCatalogSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.LecternUtil;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.TakeLecternBookPacket;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.PacketDistributor;

public class StockroomCatalogScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.bcLoc("textures/gui/stockroom_catalog.png");
    private static final ResourceLocation LOCATE_ICON = BCUtil.bcLoc("locate");
    private static final ResourceLocation LOCATE_ICON_HIGHLIGHTED = BCUtil.bcLoc("locate_highlighted");
    private static final ResourceLocation REMOVE_ICON = BCUtil.bcLoc("remove");
    private static final ResourceLocation REMOVE_ICON_HIGHLIGHTED = BCUtil.bcLoc("remove_highlighted");
    private static final int ROWS_PER_PAGE = 11;
    private static final int PARTICLE_COUNT = 16;
    private final ItemStack stack;
    private final Player player;
    private final InteractionHand hand;
    private final BlockPos lectern;
    private final RandomSource random = RandomSource.create();
    private final List<Button> removeButtons = new ArrayList<Button>();
    private final List<Button> locateButtons = new ArrayList<Button>();
    private StockroomCatalogContent data;
    private boolean showContainerList = false;
    private int page = 0;
    private String search = "";
    private PageButton forwardButton;
    private PageButton backButton;
    private List<BlockPos> containers = List.of();
    private List<BlockPos> visibleContainers = List.of();
    private List<StockroomCatalogItemEntry> items = List.of();
    private List<StockroomCatalogItemEntry> visibleItems = List.of();
    private StockroomCatalogSorting.Container containerSorting = StockroomCatalogSorting.Container.ALPHABETICAL_ASC;
    private StockroomCatalogSorting.Item itemSorting = StockroomCatalogSorting.Item.ALPHABETICAL_ASC;

    public StockroomCatalogScreen(ItemStack stack, Player player, InteractionHand hand) {
        this(stack, player, hand, null);
    }

    public StockroomCatalogScreen(ItemStack stack, Player player, BlockPos lectern) {
        this(stack, player, null, lectern);
    }

    private StockroomCatalogScreen(ItemStack stack, Player player, InteractionHand hand, BlockPos lectern) {
        super(stack.getHoverName());
        this.stack = stack;
        this.player = player;
        this.hand = hand;
        this.lectern = lectern;
        this.data = (StockroomCatalogContent)stack.getOrDefault(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)StockroomCatalogContent.DEFAULT);
        this.requestPacket();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int x = (this.width - 256) / 2;
        int y = mouseY - 29;
        int i = 0;
        if (this.showContainerList) {
            for (BlockPos pos : this.visibleContainers) {
                ItemStack blockItem = new ItemStack((ItemLike)ClientUtil.getLevel().getBlockState(pos).getBlock().asItem());
                graphics.renderItem(blockItem, x + 34, i * 19 + 29);
                graphics.renderItemDecorations(this.font, blockItem, x + 34, i * 19 + 29);
                String itemText = blockItem.getHoverName().getString(137);
                graphics.drawString(this.font, itemText, x + 51, i * 19 + 33, 0, false);
                ++i;
            }
            if (mouseX >= x + 34 && mouseX < x + 50 && y > 0 && y % 19 < 16 && y / 19 < this.visibleContainers.size()) {
                BlockPos container = this.visibleContainers.get(y / 19);
                int distance = (int)(this.lectern != null ? Math.sqrt(this.lectern.distSqr((Vec3i)container)) : ClientUtil.getPlayer().position().distanceTo(BCUtil.toVec3((Vec3i)container)));
                graphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.bibliocraft.stockroom_catalog.distance", (Object[])new Object[]{distance}), mouseX, mouseY);
            }
            if (mouseX >= x + 189 && mouseX < x + 205 && y > 0 && y % 19 < 16 && y / 19 < this.visibleContainers.size()) {
                graphics.renderTooltip(this.font, Translations.STOCKROOM_CATALOG_REMOVE, mouseX, mouseY);
            }
            if (mouseX >= x + 206 && mouseX < x + 222 && y > 0 && y % 19 < 16 && y / 19 < this.visibleContainers.size()) {
                graphics.renderTooltip(this.font, Translations.STOCKROOM_CATALOG_LOCATE, mouseX, mouseY);
            }
        } else {
            for (StockroomCatalogItemEntry entry : this.visibleItems) {
                graphics.renderItem(entry.item(), x + 34, i * 19 + 29);
                graphics.renderItemDecorations(this.font, entry.item(), x + 34, i * 19 + 29);
                String countText = Component.translatable((String)"gui.bibliocraft.stockroom_catalog.count", (Object[])new Object[]{entry.count()}).getString();
                int countWidth = this.font.width(countText);
                graphics.drawString(this.font, countText, x + 205 - countWidth, i * 19 + 33, 0, false);
                String itemText = entry.item().getHoverName().getString(153 - countWidth);
                graphics.drawString(this.font, itemText, x + 51, i * 19 + 33, 0, false);
                ++i;
            }
            if (mouseX >= x + 34 && mouseX < x + 50 && y > 0 && y % 19 < 16 && y / 19 < this.visibleItems.size()) {
                ItemStack item = this.visibleItems.get(y / 19).item();
                graphics.renderTooltip(this.font, StockroomCatalogScreen.getTooltipFromItem((Minecraft)this.getMinecraft(), (ItemStack)item), item.getTooltipImage(), item, mouseX, mouseY);
            }
            if (mouseX >= x + 206 && mouseX < x + 222 && y > 0 && y % 19 < 16 && y / 19 < this.visibleItems.size()) {
                graphics.renderTooltip(this.font, Translations.STOCKROOM_CATALOG_LOCATE, mouseX, mouseY);
            }
        }
    }

    public boolean isPauseScreen() {
        return this.lectern == null;
    }

    public void onClose() {
        super.onClose();
        this.setDataOnStack();
    }

    protected void init() {
        Component switchComponent;
        this.locateButtons.clear();
        this.removeButtons.clear();
        int x = (this.width - 256) / 2;
        Component component = switchComponent = this.showContainerList ? Translations.STOCKROOM_CATALOG_SHOW_ITEMS : Translations.STOCKROOM_CATALOG_SHOW_CONTAINERS;
        if (this.lectern != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Translations.VANILLA_TAKE_BOOK, $ -> {
                LecternUtil.takeLecternBook(this.player, this.player.level(), this.lectern);
                PacketDistributor.sendToServer((CustomPacketPayload)new TakeLecternBookPacket(this.lectern), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }).bounds(this.width / 2 - 151, 260, 98, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)switchComponent, $ -> this.toggleMode()).bounds(this.width / 2 - 49, 260, 98, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 + 53, 260, 98, 20).build());
        } else {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)switchComponent, $ -> this.toggleMode()).bounds(this.width / 2 - 100, 260, 98, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 + 2, 260, 98, 20).build());
        }
        EditBox searchBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.getMinecraft().font, x + 33, 15, 140, 8, (Component)Component.empty()));
        searchBox.setTextColor(0);
        searchBox.setBordered(false);
        searchBox.setTextShadow(false);
        searchBox.setHint(Translations.STOCKROOM_CATALOG_SEARCH);
        searchBox.setResponder(e -> {
            this.search = e.toLowerCase(Locale.ROOT);
            this.updateContents();
        });
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 194, 236, true, $ -> {
            ++this.page;
            this.updateContents();
        }, false));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 30, 236, false, $ -> {
            --this.page;
            this.updateContents();
        }, false));
        if (this.showContainerList) {
            this.addRenderableWidget((GuiEventListener)new SortButton<StockroomCatalogSorting.Container>(StockroomCatalogSorting.Container.ALPHABETICAL_ASC, x + 172, 11, 52, 14, b -> {
                SortButton button = (SortButton)b;
                button.setValue(switch ((StockroomCatalogSorting.Container)button.getValue()) {
                    default -> throw new MatchException(null, null);
                    case StockroomCatalogSorting.Container.ALPHABETICAL_ASC -> StockroomCatalogSorting.Container.ALPHABETICAL_DESC;
                    case StockroomCatalogSorting.Container.ALPHABETICAL_DESC -> StockroomCatalogSorting.Container.DISTANCE_ASC;
                    case StockroomCatalogSorting.Container.DISTANCE_ASC -> StockroomCatalogSorting.Container.DISTANCE_DESC;
                    case StockroomCatalogSorting.Container.DISTANCE_DESC -> StockroomCatalogSorting.Container.ALPHABETICAL_ASC;
                });
                this.containerSorting = (StockroomCatalogSorting.Container)button.getValue();
                this.requestPacket();
                this.updateContents();
            }));
            for (int i = 0; i < 11; ++i) {
                int j = i;
                this.removeButtons.add((Button)this.addRenderableWidget((GuiEventListener)new SpriteButton.RegularAndHighlightSprite(REMOVE_ICON, REMOVE_ICON_HIGHLIGHTED, x + 189, i * 19 + 29, 16, 16, p -> {
                    this.updateData(data -> data.remove(new GlobalPos(ClientUtil.getLevel().dimension(), this.visibleContainers.get(j))));
                    this.setDataOnStack();
                    this.requestPacket();
                    this.updateContents();
                })));
                this.locateButtons.add((Button)this.addRenderableWidget((GuiEventListener)new SpriteButton.RegularAndHighlightSprite(LOCATE_ICON, LOCATE_ICON_HIGHLIGHTED, x + 206, i * 19 + 29, 16, 16, p -> this.addParticles(this.visibleContainers.get(j)))));
            }
        } else {
            this.addRenderableWidget((GuiEventListener)new SortButton<StockroomCatalogSorting.Item>(StockroomCatalogSorting.Item.ALPHABETICAL_ASC, x + 172, 11, 52, 14, b -> {
                SortButton button = (SortButton)b;
                button.setValue(switch ((StockroomCatalogSorting.Item)button.getValue()) {
                    default -> throw new MatchException(null, null);
                    case StockroomCatalogSorting.Item.ALPHABETICAL_ASC -> StockroomCatalogSorting.Item.ALPHABETICAL_DESC;
                    case StockroomCatalogSorting.Item.ALPHABETICAL_DESC -> StockroomCatalogSorting.Item.COUNT_ASC;
                    case StockroomCatalogSorting.Item.COUNT_ASC -> StockroomCatalogSorting.Item.COUNT_DESC;
                    case StockroomCatalogSorting.Item.COUNT_DESC -> StockroomCatalogSorting.Item.ALPHABETICAL_ASC;
                });
                this.itemSorting = (StockroomCatalogSorting.Item)button.getValue();
                this.requestPacket();
                this.updateContents();
            }));
            for (int i = 0; i < 11; ++i) {
                int j = i;
                this.locateButtons.add((Button)this.addRenderableWidget((GuiEventListener)new SpriteButton.RegularAndHighlightSprite(LOCATE_ICON, LOCATE_ICON_HIGHLIGHTED, x + 206, i * 19 + 29, 16, 16, p -> this.addParticles(this.visibleItems.get(j)))));
            }
        }
        this.updateContents();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, (this.width - 256) / 2 + 18, 2, 0, 0, 256, 256);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0 && this.forwardButton.visible) {
            this.forwardButton.onPress();
            return true;
        }
        if (scrollY > 0.0 && this.backButton.visible) {
            this.backButton.onPress();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return switch (keyCode) {
            case 266 -> {
                this.backButton.onPress();
                yield true;
            }
            case 267 -> {
                this.forwardButton.onPress();
                yield true;
            }
            default -> false;
        };
    }

    public void setFromPacket(StockroomCatalogListPacket packet) {
        ClientLevel level = ClientUtil.getLevel();
        this.containers = packet.containers().stream().filter(arg_0 -> StockroomCatalogScreen.lambda$setFromPacket$14((Level)level, arg_0)).toList();
        this.items = packet.items();
        this.updateContents();
    }

    private void requestPacket() {
        if (this.hand != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StockroomCatalogRequestListPacket(this.containerSorting, this.itemSorting, (Either<InteractionHand, BlockPos>)Either.left((Object)this.hand)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (this.lectern != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StockroomCatalogRequestListPacket(this.containerSorting, this.itemSorting, (Either<InteractionHand, BlockPos>)Either.right((Object)this.lectern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void setDataOnStack() {
        this.stack.set(BCDataComponents.STOCKROOM_CATALOG_CONTENT, (Object)this.data);
        if (this.hand != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StockroomCatalogSyncPacket(this.data, (Either<InteractionHand, BlockPos>)Either.left((Object)this.hand)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else if (this.lectern != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new StockroomCatalogSyncPacket(this.data, (Either<InteractionHand, BlockPos>)Either.right((Object)this.lectern)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void toggleMode() {
        this.showContainerList = !this.showContainerList;
        this.page = 0;
        this.search = "";
        this.rebuildWidgets();
        this.updateContents();
    }

    private void updateData(UnaryOperator<StockroomCatalogContent> operator) {
        this.data = (StockroomCatalogContent)operator.apply(this.data);
    }

    private void updateContents() {
        this.buildVisibleCache();
        this.forwardButton.visible = this.page < (this.showContainerList ? this.containers.size() - 1 : this.items.size() - 1) / 11;
        this.backButton.visible = this.page > 0;
        this.removeButtons.forEach(e -> {
            e.visible = true;
        });
        this.locateButtons.forEach(e -> {
            e.visible = true;
        });
        if (this.showContainerList && this.visibleContainers.size() < 11) {
            IntStream.range(this.visibleContainers.size(), 11).forEach(i -> {
                this.removeButtons.get((int)i).visible = false;
            });
            IntStream.range(this.visibleContainers.size(), 11).forEach(i -> {
                this.locateButtons.get((int)i).visible = false;
            });
        }
        if (!this.showContainerList && this.visibleItems.size() < 11) {
            IntStream.range(this.visibleItems.size(), 11).forEach(i -> {
                this.locateButtons.get((int)i).visible = false;
            });
        }
    }

    private void buildVisibleCache() {
        if (this.showContainerList) {
            this.buildVisibleContainersCache();
        } else {
            this.buildVisibleItemsCache();
        }
    }

    private void buildVisibleContainersCache() {
        this.visibleContainers = this.containers.stream().filter(e -> BCUtil.getNameAtPos((Level)ClientUtil.getLevel(), e).getString().toLowerCase(Locale.ROOT).contains(this.search)).skip((long)this.page * 11L).limit(11L).toList();
    }

    private void buildVisibleItemsCache() {
        this.visibleItems = this.items.stream().filter(e -> e.item().getHoverName().getString().toLowerCase(Locale.ROOT).contains(this.search)).skip((long)this.page * 11L).limit(11L).toList();
    }

    private void addParticles(StockroomCatalogItemEntry entry) {
        for (BlockPos pos : entry.containers()) {
            this.addParticles(pos);
        }
    }

    private void addParticles(BlockPos pos) {
        ParticleEngine particles = ClientUtil.getMc().particleEngine;
        for (int i = 0; i < 16; ++i) {
            Particle particle = particles.createParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + this.random.nextDouble(), (double)pos.getY() + this.random.nextDouble(), (double)pos.getZ() + this.random.nextDouble(), 0.0, 0.0, 0.0);
            if (particle == null) continue;
            particle.setLifetime((int)(this.random.nextDouble() * 20.0) + 60);
        }
    }

    private static /* synthetic */ boolean lambda$setFromPacket$14(Level level, BlockPos e) {
        return level.getCapability(Capabilities.ItemHandler.BLOCK, e, null) != null;
    }

    private static class SortButton<E extends Enum<E>>
    extends Button {
        private E value;

        public SortButton(E initialValue, int x, int y, int width, int height, Button.OnPress onPress) {
            super(new Button.Builder(SortButton.message(initialValue), onPress).bounds(x, y, width, height));
            this.value = initialValue;
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E value) {
            this.value = value;
            this.setMessage(SortButton.message(value));
        }

        private static <T extends StockroomCatalogSorting> Component message(T t) {
            return Component.translatable((String)"gui.bibliocraft.stockroom_catalog.sort", (Object[])new Object[]{Component.translatable((String)t.getTranslationKey())});
        }
    }
}

