/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.FunctionalStorageClientConfig;
import com.buuz135.functionalstorage.util.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public abstract class BaseDrawerRenderer<T extends ControllableDrawerTile<T>>
implements BlockEntityRenderer<T> {
    public int getViewDistance() {
        return FunctionalStorageClientConfig.DRAWER_RENDER_RANGE;
    }

    public final void render(T tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.pushPose();
        Direction subfacing = ((ControllableDrawerTile)((Object)tile)).getFacingDirection();
        if (tile.getBlockState().hasProperty((Property)Drawer.FACING_ALL)) {
            Direction facing = (Direction)tile.getBlockState().getValue((Property)Drawer.FACING_ALL);
            if (subfacing == Direction.UP) {
                matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(90.0f, 0.0f, 0.0f), 1.0f));
                if (facing == Direction.EAST) {
                    matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -90.0f), 1.0f));
                } else if (facing == Direction.WEST) {
                    matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 90.0f), 1.0f));
                }
            }
            if (subfacing == Direction.DOWN) {
                matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-90.0f, 0.0f, -180.0f), 1.0f));
                if (facing == Direction.WEST) {
                    matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -90.0f), 1.0f));
                } else if (facing == Direction.EAST) {
                    matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 90.0f), 1.0f));
                }
            }
            if (facing == Direction.NORTH) {
                matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 180.0f), 1.0f));
            } else if (facing == Direction.SOUTH) {
                // empty if block
            }
        }
        matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        if (subfacing == Direction.NORTH) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f), 1.0f));
        } else if (subfacing == Direction.EAST) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, -90.0f, 0.0f), 1.0f));
        } else if (subfacing == Direction.SOUTH) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 180.0f, 0.0f), 1.0f));
        } else if (subfacing == Direction.WEST) {
            matrixStack.mulPose(MathUtils.createTransformMatrix(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 90.0f, 0.0f), 1.0f));
        }
        matrixStack.translate(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos().relative(subfacing));
        DrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        this.renderItems(tile, partialTicks, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public abstract void renderItems(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);
}

