/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.config.CommonConfig;
import fuzs.visualworkbench.handler.BlockConversionHandler;
import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.world.level.block.CraftingTableWithInventoryBlock;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualWorkbench
implements ModConstructor {
    public static final String MOD_ID = "visualworkbench";
    public static final String MOD_NAME = "Visual Workbench";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Visual Workbench");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"visualworkbench").client(ClientConfig.class).common(CommonConfig.class);
    public static final Predicate<Block> BLOCK_PREDICATE = block -> block instanceof CraftingTableBlock && !(block instanceof CraftingTableWithInventoryBlock);

    public void onConstructMod() {
        ModRegistry.touch();
        VisualWorkbench.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        RegistryEntryAddedCallback.registryEntryAdded((ResourceKey)Registries.BLOCK).register(BlockConversionHandler.onRegistryEntryAdded(BLOCK_PREDICATE, CraftingTableWithInventoryBlock::new, MOD_ID));
        AddBlockEntityTypeBlocksCallback.EVENT.register((Object)BlockConversionHandler.onAddBlockEntityTypeBlocks(ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY_TYPE));
        PlayerInteractEvents.USE_BLOCK.register((Object)BlockConversionHandler.onUseBlock(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG, () -> ((CommonConfig)VisualWorkbench.CONFIG.get(CommonConfig.class)).disableVanillaWorkbench));
        TagsUpdatedCallback.EVENT.register(EventPhase.FIRST, (Object)BlockConversionHandler.onTagsUpdated(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG, BLOCK_PREDICATE));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

