/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.shooter;

import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class ShooterUpgrade
extends Upgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();

    public ShooterUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.SHOOTER.get(), planeEntity);
    }

    public void use(Player player) {
        ServerLevel serverLevel;
        BlockPos blockpos;
        Vector3f motion1 = this.planeEntity.transformPos(new Vector3f(0.0f, -0.25f, (float)(1.0 + this.planeEntity.getDeltaMovement().length())));
        Vec3 motion = new Vec3(motion1);
        Level level = player.level();
        RandomSource random = level.random;
        Vector3f pos = this.planeEntity.transformPos(new Vector3f(0.0f, 1.8f, 2.0f));
        this.updateClient();
        double x = (double)pos.x() + this.planeEntity.getX();
        double y = (double)pos.y() + this.planeEntity.getY();
        double z = (double)pos.z() + this.planeEntity.getZ();
        ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
        Item item = itemStack.getItem();
        if (item == Items.FIREWORK_ROCKET) {
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, itemStack, x, y, z, true);
            fireworkrocketentity.shoot(-motion.x, -motion.y, -motion.z, -((float)Math.max(0.5, motion.length() * 1.5)), 1.0f);
            level.addFreshEntity((Entity)fireworkrocketentity);
            if (!player.isCreative()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        } else if (item == Items.FIRE_CHARGE) {
            double d3 = random.nextGaussian() * 0.05 + 2.0 * motion.x;
            double d4 = random.nextGaussian() * 0.05;
            double d5 = random.nextGaussian() * 0.05 + 2.0 * motion.z;
            Fireball fireBallEntity = (Fireball)Util.make((Object)new SmallFireball(level, (LivingEntity)player, new Vec3(d3, d4, d5)), p_229425_1_ -> p_229425_1_.setItem(itemStack));
            fireBallEntity.setPos(x, y, z);
            fireBallEntity.setDeltaMovement(motion.scale(2.0));
            level.addFreshEntity((Entity)fireBallEntity);
            if (!player.isCreative()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        } else if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            AbstractArrow arrowEntity = arrowItem.createArrow(level, itemStack, (LivingEntity)player, null);
            arrowEntity.setDeltaMovement(motion.scale(Math.max(motion.length() * 1.5, 3.0) / motion.length()));
            if (player.isCreative()) {
                arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            } else {
                this.itemStackHandler.extractItem(0, 1, false);
            }
            level.addFreshEntity((Entity)arrowEntity);
        } else if (item == Items.ENDER_EYE && level instanceof ServerLevel && (blockpos = (serverLevel = (ServerLevel)level).findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, new BlockPos((int)x, (int)y, (int)z), 100, false)) != null) {
            EyeOfEnder eyeOfEnder = new EyeOfEnder(level, x, y, z);
            eyeOfEnder.setItem(itemStack);
            eyeOfEnder.signalTo(blockpos);
            level.addFreshEntity((Entity)eyeOfEnder);
            level.playSound(null, x, y, z, SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / random.nextFloat() * 0.4f + 0.8f);
            if (!player.isCreative()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        }
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("item", (Tag)this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess()));
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag compoundTag) {
        this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), compoundTag.getCompound("item"));
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.itemStackHandler.setStackInSlot(0, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
    }

    @Override
    public <T> T getCap(BaseCapability<T, ?> cap) {
        if (cap == Capabilities.ItemHandler.ENTITY) {
            return (T)this.itemStackHandler;
        }
        return super.getCap(cap);
    }

    @Override
    public void onRemoved() {
        this.planeEntity.spawnAtLocation(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.SHOOTER.get().getDefaultInstance();
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 0, 134, 62));
    }

    @Override
    public void renderScreenBg(GuiGraphics guiGraphics, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        guiGraphics.blit(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 133, screen.getGuiTop() + 61, 226, 0, 18, 18);
    }
}

