/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.liquid;

import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.datapack.PlaneLiquidFuelReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class LiquidEngineUpgrade
extends EngineUpgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(2);
    public final FluidTank fluidTank = new FluidTank(((Integer)SimplePlanesConfig.LIQUID_ENGINE_CAPACITY.get()).intValue(), fluidStack -> PlaneLiquidFuelReloadListener.fuelMap.containsKey(fluidStack.getFluid()));
    public int burnTime;

    public LiquidEngineUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.LIQUID_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (!this.planeEntity.level().isClientSide) {
            ItemStack itemStack;
            IFluidHandler fluidHandler;
            if (this.burnTime > 0) {
                this.burnTime -= this.planeEntity.getFuelCost();
                this.updateClient();
            } else if (this.planeEntity.getThrottle() > 0 && !this.fluidTank.isEmpty()) {
                this.burnTime = PlaneLiquidFuelReloadListener.fuelMap.getOrDefault(this.fluidTank.getFluid().getFluid(), 0);
                if (this.burnTime > 0) {
                    this.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    this.updateClient();
                }
            }
            if (this.itemStackHandler.getStackInSlot(1).isEmpty() && (fluidHandler = (IFluidHandler)(itemStack = this.itemStackHandler.getStackInSlot(0)).getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                FluidStack itemFluidStack = fluidHandler.getFluidInTank(0);
                if (itemFluidStack.isEmpty()) {
                    this.fluidTank.drain(fluidHandler.fill(this.fluidTank.drain(fluidHandler.getTankCapacity(0), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                } else {
                    fluidHandler.drain(this.fluidTank.fill(fluidHandler.drain(this.fluidTank.getSpace(), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
                this.itemStackHandler.setStackInSlot(0, ItemStack.EMPTY);
                this.itemStackHandler.setStackInSlot(1, itemStack.getCraftingRemainingItem());
                this.updateClient();
            }
        }
    }

    @Override
    public void onRemoved() {
        this.planeEntity.spawnAtLocation(this.itemStackHandler.getStackInSlot(0));
        this.planeEntity.spawnAtLocation(this.itemStackHandler.getStackInSlot(1));
    }

    @Override
    public ItemStack getItemStack() {
        return SimplePlanesItems.LIQUID_ENGINE.get().getDefaultInstance();
    }

    @Override
    public boolean isPowered() {
        return !this.fluidTank.isEmpty();
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("items", (Tag)this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess()));
        compoundTag.put("fluid", (Tag)this.fluidTank.writeToNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), new CompoundTag()));
        compoundTag.putInt("burnTime", this.burnTime);
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), nbt.getCompound("items"));
        this.fluidTank.readFromNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), nbt.getCompound("fluid"));
        this.burnTime = nbt.getInt("burnTime");
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.fluidTank.getFluid());
        buffer.writeVarInt(this.burnTime);
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.fluidTank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        this.burnTime = buffer.readVarInt();
    }

    @Override
    public <T> T getCap(BaseCapability<T, ?> cap) {
        if (cap == Capabilities.FluidHandler.ENTITY) {
            return (T)this.fluidTank;
        }
        return super.getCap(cap);
    }

    @Override
    public void renderPowerHUD(GuiGraphics guiGraphics, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 0, 152, 8));
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 1, 152, 62));
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, PlaneInventoryScreen planeInventoryScreen) {
        if (planeInventoryScreen.isHovering(153, 27, 16, 32, mouseX, mouseY)) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            guiGraphics.renderTooltip(planeInventoryScreen.getMinecraft().font, (Component)Component.translatable((String)"simpleplanes.gui.fluid", (Object[])new Object[]{fluidStack.getHoverName(), fluidStack.getAmount()}), mouseX, mouseY);
        }
    }

    @Override
    public void renderScreenBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, PlaneInventoryScreen screen) {
        guiGraphics.blit(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 151, screen.getGuiTop() + 7, 176, 72, 18, 72);
        FluidStack fluidStack = this.fluidTank.getFluid();
        int height = 36;
        int width = 18;
        int amount = fluidStack.getAmount();
        int fluidHeight = amount * (height - 4) / this.fluidTank.getCapacity();
        if (!fluidStack.isEmpty()) {
            ClientUtil.renderLiquidEngineFluid(guiGraphics, screen, fluidStack, height, width, fluidHeight);
        }
        guiGraphics.blit(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 154, screen.getGuiTop() + 28, 194, 72, 12, 30);
    }
}

