/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.banner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerUpgrade;

public class BannerModel {
    private static final BannerBlockEntity BANNER_BLOCK_ENTITY = new BannerBlockEntity(BlockPos.ZERO, Blocks.BLACK_BANNER.defaultBlockState());

    public static void renderBanner(BannerUpgrade bannerUpgrade, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, ItemStack banner, int packedLight) {
        PlaneEntity planeEntity = bannerUpgrade.getPlaneEntity();
        if (!banner.isEmpty()) {
            poseStack.pushPose();
            EntityType entityType = planeEntity.getType();
            if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(-4.0, -1.25, 0.025);
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(98.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(1.0, 3.62, 0.05);
                if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
                    poseStack.translate(0.395, 1.92, 0.0);
                } else if (entityType == SimplePlanesEntities.CARGO_PLANE.get()) {
                    poseStack.translate(-1.0, 8.0625, 0.0);
                }
            }
            poseStack.scale(0.6f, -0.6f, -0.6f);
            BannerItem item = (BannerItem)banner.getItem();
            BANNER_BLOCK_ENTITY.fromItem(banner, item.getColor());
            float tickCountWithPartial = partialTicks + (float)planeEntity.tickCount;
            float r = 0.05f * Mth.cos((float)(tickCountWithPartial / 5.0f)) * 180.0f;
            r += (float)MathUtil.lerpAngle((double)partialTicks, MathUtil.wrapSubtractDegrees(bannerUpgrade.rotation, bannerUpgrade.prevRotation), 0.0);
            BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)BANNER_BLOCK_ENTITY);
            if (renderer instanceof BannerRenderer) {
                BannerRenderer bannerRenderer = (BannerRenderer)renderer;
                bannerRenderer.flag.xRot = (float)(Math.PI + (double)(r / 100.0f));
                BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)bannerRenderer.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)BANNER_BLOCK_ENTITY.getBaseColor(), (BannerPatternLayers)BANNER_BLOCK_ENTITY.getPatterns());
            }
            poseStack.popPose();
        }
    }
}

