/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.items.DescriptionItem;
import xyz.przemyk.simpleplanes.items.ParachuteItem;
import xyz.przemyk.simpleplanes.items.PlaneArmorItem;
import xyz.przemyk.simpleplanes.items.PlaneItem;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesComponents;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;

public class SimplePlanesItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"simpleplanes");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"simpleplanes");
    public static final Supplier<Item> PROPELLER = ITEMS.register("propeller", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> FLOATY_BEDDING = ITEMS.register("floaty_bedding", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> BOOSTER = ITEMS.register("booster", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> HEALING = ITEMS.register("healing", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> ARMOR = ITEMS.register("armor", () -> new PlaneArmorItem(new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> SOLAR_PANEL = ITEMS.register("solar_panel", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> FOLDING = ITEMS.register("folding", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> SUPPLY_CRATE = ITEMS.register("supply_crate", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> SEATS = ITEMS.register("seats", () -> new Item(new Item.Properties()));
    public static final Supplier<Item> SHOOTER = ITEMS.register("shooter", () -> new DescriptionItem(new Item.Properties(), (Component)Component.translatable((String)"simpleplanes.shooter_desc", (Object[])new Object[]{Component.keybind((String)"key.plane_inventory_open.desc"), Component.keybind((String)"key.attack")})));
    public static final Supplier<Item> ELECTRIC_ENGINE = ITEMS.register("electric_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.translatable((String)"simpleplanes.press_key", (Object[])new Object[]{Component.keybind((String)"key.plane_inventory_open.desc")})));
    public static final Supplier<Item> FURNACE_ENGINE = ITEMS.register("furnace_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.translatable((String)"simpleplanes.press_key", (Object[])new Object[]{Component.keybind((String)"key.plane_inventory_open.desc")})));
    public static final Supplier<Item> LIQUID_ENGINE = ITEMS.register("liquid_engine", () -> new DescriptionItem(new Item.Properties(), (Component)Component.translatable((String)"simpleplanes.press_key", (Object[])new Object[]{Component.keybind((String)"key.plane_inventory_open.desc")})));
    public static final Supplier<Item> WRENCH = ITEMS.register("wrench", () -> new Item(new Item.Properties()));
    public static final Supplier<BlockItem> PLANE_WORKBENCH = ITEMS.register("plane_workbench", () -> new BlockItem((Block)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get(), new Item.Properties()));
    public static final Supplier<BlockItem> CHARGING_STATION = ITEMS.register("charging_station", () -> new BlockItem((Block)SimplePlanesBlocks.CHARGING_STATION_BLOCK.get(), new Item.Properties()));
    public static final Supplier<PlaneItem> PLANE_ITEM = ITEMS.register("plane", () -> new PlaneItem(new Item.Properties(), SimplePlanesEntities.PLANE));
    public static final Supplier<PlaneItem> LARGE_PLANE_ITEM = ITEMS.register("large_plane", () -> new PlaneItem(new Item.Properties(), SimplePlanesEntities.LARGE_PLANE));
    public static final Supplier<PlaneItem> CARGO_PLANE_ITEM = ITEMS.register("cargo_plane", () -> new PlaneItem(new Item.Properties(), SimplePlanesEntities.CARGO_PLANE));
    public static final Supplier<PlaneItem> HELICOPTER_ITEM = ITEMS.register("helicopter", () -> new PlaneItem(new Item.Properties(), SimplePlanesEntities.HELICOPTER));
    public static final Supplier<ParachuteItem> PARACHUTE_ITEM = ITEMS.register("parachute", () -> new ParachuteItem(new Item.Properties()));
    public static final Supplier<CreativeModeTab> PLANES_TAB = CREATIVE_MODE_TABS.register("planes_tab", () -> CreativeModeTab.builder().icon(() -> PLANE_ITEM.get().getDefaultInstance()).title((Component)Component.translatable((String)"simpleplanes.planes_tab")).displayItems((parameters, output) -> {
        output.accept((ItemLike)PROPELLER.get());
        output.accept((ItemLike)FLOATY_BEDDING.get());
        output.accept((ItemLike)BOOSTER.get());
        output.accept((ItemLike)HEALING.get());
        output.accept((ItemLike)ARMOR.get());
        output.accept((ItemLike)SOLAR_PANEL.get());
        output.accept((ItemLike)FOLDING.get());
        output.accept((ItemLike)SUPPLY_CRATE.get());
        output.accept((ItemLike)SEATS.get());
        output.accept((ItemLike)SHOOTER.get());
        output.accept((ItemLike)ELECTRIC_ENGINE.get());
        output.accept((ItemLike)FURNACE_ENGINE.get());
        output.accept((ItemLike)LIQUID_ENGINE.get());
        output.accept((ItemLike)WRENCH.get());
        output.accept((ItemLike)PLANE_WORKBENCH.get());
        output.accept((ItemLike)CHARGING_STATION.get());
        output.accept((ItemLike)PARACHUTE_ITEM.get());
        BuiltInRegistries.BLOCK.getTag(PlaneWorkbenchContainer.PLANE_MATERIALS_TAG).ifPresent(tag -> tag.forEach(block -> {
            ItemStack planeStack = new ItemStack((ItemLike)PLANE_ITEM.get());
            ItemStack largePlaneStack = new ItemStack((ItemLike)LARGE_PLANE_ITEM.get());
            ItemStack cargoPlaneStack = new ItemStack((ItemLike)CARGO_PLANE_ITEM.get());
            ItemStack heliStack = new ItemStack((ItemLike)HELICOPTER_ITEM.get());
            CompoundTag entityTag = new CompoundTag();
            entityTag.putString("material", BuiltInRegistries.BLOCK.getKey((Object)((Block)block.value())).toString());
            planeStack.set(SimplePlanesComponents.ENTITY_TAG, (Object)entityTag);
            largePlaneStack.set(SimplePlanesComponents.ENTITY_TAG, (Object)entityTag);
            cargoPlaneStack.set(SimplePlanesComponents.ENTITY_TAG, (Object)entityTag);
            heliStack.set(SimplePlanesComponents.ENTITY_TAG, (Object)entityTag);
            output.accept(planeStack);
            output.accept(largePlaneStack);
            output.accept(cargoPlaneStack);
            output.accept(heliStack);
        }));
    }).build());

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
        CREATIVE_MODE_TABS.register(bus);
    }

    public static List<PlaneItem> getPlaneItems() {
        ArrayList<PlaneItem> planeItems = new ArrayList<PlaneItem>(3);
        planeItems.add(PLANE_ITEM.get());
        planeItems.add(LARGE_PLANE_ITEM.get());
        planeItems.add(CARGO_PLANE_ITEM.get());
        planeItems.add(HELICOPTER_ITEM.get());
        return planeItems;
    }
}

