/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.worldgen.level.block;

import java.util.List;
import javax.annotation.Nullable;
import net.mcs3.basicnetherores.init.BNOBlocks;
import net.mcs3.basicnetherores.util.helper.GuardOreBlocks;
import net.mcs3.basicnetherores.util.helper.OreTextHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ModOreBlock
extends DropExperienceBlock {
    private final IntProvider xpRange;

    public ModOreBlock(BlockBehaviour.Properties properties, IntProvider experienceDropped) {
        super(experienceDropped, properties.noOcclusion());
        this.xpRange = experienceDropped;
    }

    public ModOreBlock(BlockBehaviour.Properties properties) {
        this(properties, (IntProvider)UniformInt.of((int)0, (int)0));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        if (this == BNOBlocks.NETHER_EMERALD_ORE || this == BNOBlocks.BASALT_EMERALD_ORE || this == BNOBlocks.SOUL_EMERALD_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.emeraldOreTip, (Object[])new Object[]{OreTextHelper.emeraldMinHeight.toString(), OreTextHelper.emeraldMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_DIAMOND_ORE || this == BNOBlocks.BASALT_DIAMOND_ORE || this == BNOBlocks.SOUL_DIAMOND_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.diamondOreTip, (Object[])new Object[]{OreTextHelper.diamondMinHeight.toString(), OreTextHelper.diamondMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_LAPIS_ORE || this == BNOBlocks.BASALT_LAPIS_ORE || this == BNOBlocks.SOUL_LAPIS_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.lapisOreTip, (Object[])new Object[]{OreTextHelper.lapisMinHeight.toString(), OreTextHelper.lapisMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_COAL_ORE || this == BNOBlocks.BASALT_COAL_ORE || this == BNOBlocks.SOUL_COAL_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.coalOreTip, (Object[])new Object[]{OreTextHelper.coalMinHeight.toString(), OreTextHelper.coalMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_SILVER_ORE || this == BNOBlocks.BASALT_SILVER_ORE || this == BNOBlocks.SOUL_SILVER_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.silverOreTip, (Object[])new Object[]{OreTextHelper.silverMinHeight.toString(), OreTextHelper.silverMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_IRON_ORE || this == BNOBlocks.BASALT_IRON_ORE || this == BNOBlocks.SOUL_IRON_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.ironOreTip, (Object[])new Object[]{OreTextHelper.ironMinHeight.toString(), OreTextHelper.ironMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_LEAD_ORE || this == BNOBlocks.BASALT_LEAD_ORE || this == BNOBlocks.SOUL_LEAD_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.leadOreTip, (Object[])new Object[]{OreTextHelper.leadMinHeight.toString(), OreTextHelper.leadMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_NICKEL_ORE || this == BNOBlocks.BASALT_NICKEL_ORE || this == BNOBlocks.SOUL_NICKEL_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.nickelOreTip, (Object[])new Object[]{OreTextHelper.nickelMinHeight.toString(), OreTextHelper.nickelMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_COPPER_ORE || this == BNOBlocks.BASALT_COPPER_ORE || this == BNOBlocks.SOUL_COPPER_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.copperOreTip, (Object[])new Object[]{OreTextHelper.copperMinHeight.toString(), OreTextHelper.copperMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_ALUMINUM_ORE || this == BNOBlocks.BASALT_ALUMINUM_ORE || this == BNOBlocks.SOUL_ALUMINUM_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.aluminumOreTip, (Object[])new Object[]{OreTextHelper.aluminumMinHeight.toString(), OreTextHelper.aluminumMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_TIN_ORE || this == BNOBlocks.BASALT_TIN_ORE || this == BNOBlocks.SOUL_TIN_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.tinOreTip, (Object[])new Object[]{OreTextHelper.tinMinHeight.toString(), OreTextHelper.tinMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_OSMIUM_ORE || this == BNOBlocks.BASALT_OSMIUM_ORE || this == BNOBlocks.SOUL_OSMIUM_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.osmiumOreTip, (Object[])new Object[]{OreTextHelper.osmiumMinHeight.toString(), OreTextHelper.osmiumMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_URANIUM_ORE || this == BNOBlocks.BASALT_URANIUM_ORE || this == BNOBlocks.SOUL_URANIUM_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.uraniumOreTip, (Object[])new Object[]{OreTextHelper.uraniumMinHeight.toString(), OreTextHelper.uraniumMaxHeight.toString()}));
        } else if (this == BNOBlocks.NETHER_ZINC_ORE || this == BNOBlocks.BASALT_ZINC_ORE || this == BNOBlocks.SOUL_ZINC_ORE) {
            tooltip.add((Component)Component.translatable((String)OreTextHelper.zincOreTip, (Object[])new Object[]{OreTextHelper.zincMinHeight.toString(), OreTextHelper.zincMaxHeight.toString()}));
        }
    }

    public void spawnAfterBreak(BlockState state, ServerLevel worldIn, BlockPos blockPos, ItemStack itemStack, boolean dropXP) {
        super.spawnAfterBreak(state, worldIn, blockPos, itemStack, dropXP);
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        level.levelEvent(player, 2001, blockPos, ModOreBlock.getId((BlockState)blockState));
        GuardOreBlocks.guardOres(player, level, blockPos, blockState.getBlock());
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
    }
}

