/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.util.helper;

import java.util.ArrayList;
import java.util.List;
import net.mcs3.basicnetherores.config.BasicNetherOresConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public class GuardOreBlocks {
    public static List<String> PROTECTED_ORES;

    public static void guardOres(Player player, Level level, BlockPos pos, Block block) {
        HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
        int isSilkTouching = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
        GuardOreBlocks.initProtectedBlocks();
        if (BasicNetherOresConfig.common().piglinGuard()) {
            if (BasicNetherOresConfig.common().silkEffect()) {
                if (isSilkTouching < 1) {
                    GuardOreBlocks.attackThief(block, level, pos, player);
                }
            } else {
                GuardOreBlocks.attackThief(block, level, pos, player);
            }
        }
    }

    public static void attackThief(Block block, Level world, BlockPos pos, Player player) {
        if (GuardOreBlocks.protectedOres(block)) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            int rngProt = BasicNetherOresConfig.common().protectionRange();
            List list = world.getEntitiesOfClass(Piglin.class, new AABB((double)(x - rngProt), (double)(y - rngProt), (double)(z - rngProt), (double)(x + rngProt), (double)(y + rngProt), (double)(z + rngProt)));
            for (Piglin guard : list) {
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            }
            List zombifiedPiglinList = world.getEntitiesOfClass(ZombifiedPiglin.class, new AABB((double)(x - rngProt), (double)(y - rngProt), (double)(z - rngProt), (double)(x + rngProt), (double)(y + rngProt), (double)(z + rngProt)));
            for (ZombifiedPiglin guard : zombifiedPiglinList) {
                guard.setTarget((LivingEntity)player);
            }
        }
    }

    public static boolean protectedOres(Block block) {
        String name = block.builtInRegistryHolder().key().location().toString();
        if (PROTECTED_ORES.contains(name)) {
            return true;
        }
        boolean contains = false;
        return contains;
    }

    public static void initProtectedBlocks() {
        List<? extends String> protOres = BasicNetherOresConfig.common().protectedBlocks();
        PROTECTED_ORES = new ArrayList<String>();
        for (int i = 0; i < protOres.size(); ++i) {
            PROTECTED_ORES.add(protOres.get(i));
        }
    }
}

