/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.init;

import java.util.List;
import net.mcs3.basicnetherores.init.BNOConfiguredFeatures;
import net.mcs3.basicnetherores.util.helper.OreTextHelper;
import net.mcs3.basicnetherores.util.helper.ResourceLocationHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class BNOPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ORE_EMERALD_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_emerald_nether");
    public static final ResourceKey<PlacedFeature> ORE_DIAMOND_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_diamond_nether");
    public static final ResourceKey<PlacedFeature> ORE_REDSTONE_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_redstone_nether");
    public static final ResourceKey<PlacedFeature> ORE_LAPIS_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_lapis_nether");
    public static final ResourceKey<PlacedFeature> ORE_COAL_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_coal_nether");
    public static final ResourceKey<PlacedFeature> ORE_SILVER_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_silver_nether");
    public static final ResourceKey<PlacedFeature> ORE_IRON_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_iron_nether");
    public static final ResourceKey<PlacedFeature> ORE_LEAD_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_lead_nether");
    public static final ResourceKey<PlacedFeature> ORE_NICKEL_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_nickel_nether");
    public static final ResourceKey<PlacedFeature> ORE_COPPER_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_copper_nether");
    public static final ResourceKey<PlacedFeature> ORE_ALUMINUM_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_aluminum_nether");
    public static final ResourceKey<PlacedFeature> ORE_TIN_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_tin_nether");
    public static final ResourceKey<PlacedFeature> ORE_OSMIUM_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_osmium_nether");
    public static final ResourceKey<PlacedFeature> ORE_URANIUM_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_uranium_nether");
    public static final ResourceKey<PlacedFeature> ORE_ZINC_PLACED_FEATURE = BNOPlacedFeatures.createKey("ore_zinc_nether");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference holderEmerald = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_EMERALD_CONFIGURED_FEATURE);
        Holder.Reference holderDiamond = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_DIAMOND_CONFIGURED_FEATURE);
        Holder.Reference holderRedstone = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_REDSTONE_CONFIGURED_FEATURE);
        Holder.Reference holderLapis = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_LAPIS_CONFIGURED_FEATURE);
        Holder.Reference holderCoal = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_COAL_CONFIGURED_FEATURE);
        Holder.Reference holderSilver = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_SILVER_CONFIGURED_FEATURE);
        Holder.Reference holderIron = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_IRON_CONFIGURED_FEATURE);
        Holder.Reference holderLead = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_LEAD_CONFIGURED_FEATURE);
        Holder.Reference holderNickel = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_NICKEL_CONFIGURED_FEATURE);
        Holder.Reference holderCopper = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_COPPER_CONFIGURED_FEATURE);
        Holder.Reference holderAluminum = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_ALUMINUM_CONFIGURED_FEATURE);
        Holder.Reference holderTin = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_TIN_CONFIGURED_FEATURE);
        Holder.Reference holderOsmium = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_OSMIUM_CONFIGURED_FEATURE);
        Holder.Reference holderUranium = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_URANIUM_CONFIGURED_FEATURE);
        Holder.Reference holderZinc = holderGetter.getOrThrow(BNOConfiguredFeatures.ORE_ZINC_CONFIGURED_FEATURE);
        BNOPlacedFeatures.register(context, ORE_EMERALD_PLACED_FEATURE, holderEmerald, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.emeraldPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.emeraldMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.emeraldMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_DIAMOND_PLACED_FEATURE, holderDiamond, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.diamondPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.diamondMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.diamondMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_REDSTONE_PLACED_FEATURE, holderRedstone, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.redstonePerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.redstoneMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.redstoneMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_LAPIS_PLACED_FEATURE, holderLapis, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.lapisPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.lapisMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.lapisMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_COAL_PLACED_FEATURE, holderCoal, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.coalPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.coalMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.coalMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_SILVER_PLACED_FEATURE, holderSilver, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.silverPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.silverMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.silverMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_IRON_PLACED_FEATURE, holderIron, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.ironPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.ironMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.ironMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_LEAD_PLACED_FEATURE, holderLead, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.leadPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.leadMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.leadMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_NICKEL_PLACED_FEATURE, holderNickel, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.nickelPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.nickelMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.nickelMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_COPPER_PLACED_FEATURE, holderCopper, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.copperPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.copperMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.copperMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_ALUMINUM_PLACED_FEATURE, holderAluminum, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.aluminumPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.aluminumMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.aluminumMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_TIN_PLACED_FEATURE, holderTin, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.tinPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.tinMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.tinMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_OSMIUM_PLACED_FEATURE, holderOsmium, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.osmiumPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.osmiumMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.osmiumMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_URANIUM_PLACED_FEATURE, holderUranium, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.uraniumPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.uraniumMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.uraniumMaxHeight))));
        BNOPlacedFeatures.register(context, ORE_ZINC_PLACED_FEATURE, holderZinc, BNOPlacedFeatures.commonOrePlacement(OreTextHelper.zincPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.zincMinHeight), (VerticalAnchor)VerticalAnchor.absolute((int)OreTextHelper.zincMaxHeight))));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return BNOPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)p_195344_), p_195345_);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocationHelper.prefix(name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    public static void initialize() {
    }
}

