/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores.data.worldgen;

import net.mcs3.basicnetherores.init.BNOPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NeoBiomeModifierGenerator {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named netherBiomes = biomeGetter.getOrThrow(BiomeTags.IS_NETHER);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_EMERALD_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_DIAMOND_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_REDSTONE_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_LAPIS_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_COAL_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_SILVER_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_IRON_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_LEAD_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_NICKEL_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_COPPER_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_ALUMINUM_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_TIN_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_OSMIUM_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_URANIUM_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
        NeoBiomeModifierGenerator.registerOreModifier(context, (HolderGetter<PlacedFeature>)placedFeatures, BNOPlacedFeatures.ORE_ZINC_PLACED_FEATURE, (HolderSet<Biome>)netherBiomes);
    }

    private static void registerOreModifier(BootstrapContext<BiomeModifier> context, HolderGetter<PlacedFeature> placedFeatures, ResourceKey<PlacedFeature> key, HolderSet<Biome> biomes) {
        BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(key)}), GenerationStep.Decoration.UNDERGROUND_ORES);
        context.register(ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)key.location()), (Object)modifier);
    }
}

