/*
 * Decompiled with CFR 0.152.
 */
package net.mcs3.basicnetherores;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mcs3.basicnetherores.config.NeoBasicNetherOresConfig;
import net.mcs3.basicnetherores.init.BNOBlocks;
import net.mcs3.basicnetherores.init.BNOItems;
import net.mcs3.basicnetherores.worldgen.item.ModCreativeModeTabs;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="bno")
public class NeoBasicNetherOres {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bno");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registries.PLACED_FEATURE, (String)"bno");
    public static final Supplier<CreativeModeTab> BNO_TAB = CREATIVE_MODE_TABS.register("bno_tab", () -> ModCreativeModeTabs.BNO_TAB);

    public NeoBasicNetherOres(IEventBus bus) {
        this.registryInit();
        CREATIVE_MODE_TABS.register(bus);
        NeoBasicNetherOresConfig.setup();
    }

    private void registryInit() {
        NeoBasicNetherOres.bind(Registries.BLOCK, BNOBlocks::registerBlocks);
        NeoBasicNetherOres.bind(Registries.ITEM, BNOBlocks::registerItemBlocks);
        NeoBasicNetherOres.bind(Registries.ITEM, BNOItems::registerItems);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }
}

