/*
 * Decompiled with CFR 0.152.
 */
package net.drenough.create_chocolate.block;

import java.util.function.Supplier;
import net.drenough.create_chocolate.block.CaramelCakeBlock;
import net.drenough.create_chocolate.block.ChocolateCakeBlock;
import net.drenough.create_chocolate.block.DarkChocolateCakeBlock;
import net.drenough.create_chocolate.block.RoyalChocolateCakeBlock;
import net.drenough.create_chocolate.block.VanillaCropBlock;
import net.drenough.create_chocolate.block.VeganChocolateCakeBlock;
import net.drenough.create_chocolate.block.WhiteChocolateCakeBlock;
import net.drenough.create_chocolate.block.almond.AlmondLeavesBlock;
import net.drenough.create_chocolate.block.almond.ModFlammableRotatedPillarBlock;
import net.drenough.create_chocolate.fluid.ModFluids;
import net.drenough.create_chocolate.item.ModItems;
import net.drenough.create_chocolate.worldgen.tree.ModTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"create_chocolate");
    public static final DeferredBlock<Block> CHOCOLATE_BRICKS = ModBlocks.registerBlock("chocolate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_STAIRS = ModBlocks.registerBlock("chocolate_brick_stairs", () -> new StairBlock(((Block)CHOCOLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_SLAB = ModBlocks.registerBlock("chocolate_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_DOOR = ModBlocks.registerBlock("chocolate_brick_door", () -> new DoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_TRAPDOOR = ModBlocks.registerBlock("chocolate_brick_trapdoor", () -> new TrapDoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_WALL = ModBlocks.registerBlock("chocolate_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICK_WALL)));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_FENCE = ModBlocks.registerBlock("chocolate_brick_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> CHOCOLATE_BRICK_FENCE_GATE = ModBlocks.registerBlock("chocolate_brick_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<Block> CHOCOLATE_CAKE = BLOCKS.register("chocolate_cake", () -> new ChocolateCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_BRICKS = ModBlocks.registerBlock("dark_chocolate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_STAIRS = ModBlocks.registerBlock("dark_chocolate_stairs", () -> new StairBlock(((Block)DARK_CHOCOLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_SLAB = ModBlocks.registerBlock("dark_chocolate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_DOOR = ModBlocks.registerBlock("dark_chocolate_door", () -> new DoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_TRAPDOOR = ModBlocks.registerBlock("dark_chocolate_trapdoor", () -> new TrapDoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_WALL = ModBlocks.registerBlock("dark_chocolate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICK_WALL)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_FENCE = ModBlocks.registerBlock("dark_chocolate_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_FENCE_GATE = ModBlocks.registerBlock("dark_chocolate_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<LiquidBlock> DARK_CHOCOLATE_BLOCK = BLOCKS.register("dark_chocolate_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_DARK_CHOCOLATE_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noOcclusion()));
    public static final DeferredBlock<Block> DARK_CHOCOLATE_CAKE = BLOCKS.register("dark_chocolate_cake", () -> new DarkChocolateCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_BRICKS = ModBlocks.registerBlock("white_chocolate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_STAIRS = ModBlocks.registerBlock("white_chocolate_stairs", () -> new StairBlock(((Block)WHITE_CHOCOLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_SLAB = ModBlocks.registerBlock("white_chocolate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_DOOR = ModBlocks.registerBlock("white_chocolate_door", () -> new DoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_TRAPDOOR = ModBlocks.registerBlock("white_chocolate_trapdoor", () -> new TrapDoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_WALL = ModBlocks.registerBlock("white_chocolate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICK_WALL)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_FENCE = ModBlocks.registerBlock("white_chocolate_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_FENCE_GATE = ModBlocks.registerBlock("white_chocolate_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<LiquidBlock> WHITE_CHOCOLATE_BLOCK = BLOCKS.register("white_chocolate_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_WHITE_CHOCOLATE_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noOcclusion()));
    public static final DeferredBlock<Block> WHITE_CHOCOLATE_CAKE = BLOCKS.register("white_chocolate_cake", () -> new WhiteChocolateCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> CARAMEL_BRICKS = ModBlocks.registerBlock("caramel_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> CARAMEL_STAIRS = ModBlocks.registerBlock("caramel_stairs", () -> new StairBlock(((Block)CARAMEL_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> CARAMEL_SLAB = ModBlocks.registerBlock("caramel_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> CARAMEL_DOOR = ModBlocks.registerBlock("caramel_door", () -> new DoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> CARAMEL_TRAPDOOR = ModBlocks.registerBlock("caramel_trapdoor", () -> new TrapDoorBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> CARAMEL_WALL = ModBlocks.registerBlock("caramel_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICK_WALL)));
    public static final DeferredBlock<Block> CARAMEL_FENCE = ModBlocks.registerBlock("caramel_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> CARAMEL_FENCE_GATE = ModBlocks.registerBlock("caramel_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<LiquidBlock> CARAMEL_BLOCK = BLOCKS.register("caramel_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_CARAMEL_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noOcclusion()));
    public static final DeferredBlock<Block> CARAMEL_CAKE = BLOCKS.register("caramel_cake", () -> new CaramelCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_CHOCOLATE = ModBlocks.registerBlock("cardboard_box_of_chocolate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_DARK_CHOCOLATE = ModBlocks.registerBlock("cardboard_box_of_dark_chocolate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_WHITE_CHOCOLATE = ModBlocks.registerBlock("cardboard_box_of_white_chocolate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_CARAMEL = ModBlocks.registerBlock("cardboard_box_of_caramel", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_ROYAL_CHOCOLATE = ModBlocks.registerBlock("cardboard_box_of_royal_chocolate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> CARDBOARD_BOX_OF_VEGAN_CHOCOLATE = ModBlocks.registerBlock("cardboard_box_of_vegan_chocolate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BROWN_WOOL)));
    public static final DeferredBlock<Block> PALLET_OF_CHOCOLATE = ModBlocks.registerBlock("pallet_of_chocolate", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PALLET_OF_DARK_CHOCOLATE = ModBlocks.registerBlock("pallet_of_dark_chocolate", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PALLET_OF_WHITE_CHOCOLATE = ModBlocks.registerBlock("pallet_of_white_chocolate", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PALLET_OF_CARAMEL = ModBlocks.registerBlock("pallet_of_caramel", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PALLET_OF_ROYAL_CHOCOLATE = ModBlocks.registerBlock("pallet_of_royal_chocolate", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PALLET_OF_VEGAN_CHOCOLATE = ModBlocks.registerBlock("pallet_of_vegan_chocolate", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD).requiresCorrectToolForDrops()));
    public static final DeferredBlock<LiquidBlock> ROYAL_CHOCOLATE_BLOCK = BLOCKS.register("royal_chocolate_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_ROYAL_CHOCOLATE_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission()));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_BRICKS = ModBlocks.registerBlock("royal_chocolate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_STAIRS = ModBlocks.registerBlock("royal_chocolate_stairs", () -> new StairBlock(((Block)ROYAL_CHOCOLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_SLAB = ModBlocks.registerBlock("royal_chocolate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_DOOR = ModBlocks.registerBlock("royal_chocolate_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_TRAPDOOR = ModBlocks.registerBlock("royal_chocolate_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_WALL = ModBlocks.registerBlock("royal_chocolate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_WALL)));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_FENCE = ModBlocks.registerBlock("royal_chocolate_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_FENCE_GATE = ModBlocks.registerBlock("royal_chocolate_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<Block> ROYAL_CHOCOLATE_CAKE = BLOCKS.register("royal_chocolate_cake", () -> new RoyalChocolateCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> ALMOND_LOG = BLOCKS.register("almond_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> ALMOND_WOOD = BLOCKS.register("almond_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_ALMOND_LOG = BLOCKS.register("stripped_almond_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_ALMOND_WOOD = BLOCKS.register("stripped_almond_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> ALMOND_PLANKS = BLOCKS.register("almond_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return true;
        }

        public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<Block> ALMOND_LEAVES = BLOCKS.register("almond_leaves", () -> new AlmondLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return true;
        }

        public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> ALMOND_SAPLING = BLOCKS.register("almond_sapling", () -> new SaplingBlock(ModTreeGrowers.ALMOND, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredItem<Item> ALMOND_LOG_ITEM = ModItems.ITEMS.register("almond_log", () -> new BlockItem((Block)ALMOND_LOG.get(), new Item.Properties()));
    public static final DeferredItem<Item> ALMOND_WOOD_ITEM = ModItems.ITEMS.register("almond_wood", () -> new BlockItem((Block)ALMOND_WOOD.get(), new Item.Properties()));
    public static final DeferredItem<Item> STRIPPED_ALMOND_LOG_ITEM = ModItems.ITEMS.register("stripped_almond_log", () -> new BlockItem((Block)STRIPPED_ALMOND_LOG.get(), new Item.Properties()));
    public static final DeferredItem<Item> STRIPPED_ALMOND_WOOD_ITEM = ModItems.ITEMS.register("stripped_almond_wood", () -> new BlockItem((Block)STRIPPED_ALMOND_WOOD.get(), new Item.Properties()));
    public static final DeferredItem<Item> ALMOND_PLANKS_ITEM = ModItems.ITEMS.register("almond_planks", () -> new BlockItem((Block)ALMOND_PLANKS.get(), new Item.Properties()));
    public static final DeferredItem<Item> ALMOND_LEAVES_ITEM = ModItems.ITEMS.register("almond_leaves", () -> new BlockItem((Block)ALMOND_LEAVES.get(), new Item.Properties()));
    public static final DeferredItem<Item> ALMOND_SAPLING_ITEM = ModItems.ITEMS.register("almond_sapling", () -> new BlockItem((Block)ALMOND_SAPLING.get(), new Item.Properties()));
    public static final DeferredBlock<Block> VANILLA_CROP = BLOCKS.register("vanilla_crop", () -> new VanillaCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT)));
    public static final DeferredBlock<LiquidBlock> VEGAN_CHOCOLATE_BLOCK = BLOCKS.register("vegan_chocolate_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_VEGAN_CHOCOLATE_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission()));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_CAKE = BLOCKS.register("vegan_chocolate_cake", () -> new VeganChocolateCakeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_BRICKS = ModBlocks.registerBlock("vegan_chocolate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_STAIRS = ModBlocks.registerBlock("vegan_chocolate_stairs", () -> new StairBlock(((Block)VEGAN_CHOCOLATE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_STAIRS)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_SLAB = ModBlocks.registerBlock("vegan_chocolate_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_SLAB)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_DOOR = ModBlocks.registerBlock("vegan_chocolate_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).noOcclusion()));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_TRAPDOOR = ModBlocks.registerBlock("vegan_chocolate_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).noOcclusion()));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_WALL = ModBlocks.registerBlock("vegan_chocolate_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICK_WALL)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_FENCE = ModBlocks.registerBlock("vegan_chocolate_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<Block> VEGAN_CHOCOLATE_FENCE_GATE = ModBlocks.registerBlock("vegan_chocolate_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
    public static final DeferredBlock<LiquidBlock> APPLE_SAUCE_BLOCK = BLOCKS.register("apple_sauce_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_APPLE_SAUCE_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission()));
    public static final DeferredBlock<LiquidBlock> ALMOND_MILK_BLOCK = BLOCKS.register("almond_milk_block", () -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_ALMOND_MILK_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

