/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.gui;

import lekavar.lma.drinkbeer.blockentities.BeerBarrelBlockEntity;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.registries.MenuTypeRegistry;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class BeerBarrelMenu
extends AbstractContainerMenu {
    private static final int STATUS_CODE = 1;
    private static final int BREWING_REMAINING_TIME = 0;
    private final Container brewingSpace;
    private final ContainerData syncData;

    public BeerBarrelMenu(int id, Container brewingSpace, ContainerData syncData, Inventory playerInventory, BeerBarrelBlockEntity beerBarrelBlockEntity) {
        super(MenuTypeRegistry.beerBarrelContainer.get(), id);
        this.brewingSpace = brewingSpace;
        this.syncData = syncData;
        this.layoutPlayerInventorySlots(8, 84, (IItemHandler)new InvWrapper((Container)playerInventory));
        this.addSlot(new Slot(brewingSpace, 0, 28, 26));
        this.addSlot(new Slot(brewingSpace, 1, 46, 26));
        this.addSlot(new Slot(brewingSpace, 2, 28, 44));
        this.addSlot(new Slot(brewingSpace, 3, 46, 44));
        this.addSlot(new Slot(brewingSpace, 4, 73, 50));
        this.addSlot(new OutputSlot(brewingSpace, 5, 128, 34, syncData, beerBarrelBlockEntity));
        this.addDataSlots(syncData);
    }

    public BeerBarrelMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, data.readBlockPos());
    }

    public BeerBarrelMenu(int id, Inventory playerInventory, BlockPos pos) {
        this(id, (Container)((BeerBarrelBlockEntity)Minecraft.getInstance().level.getBlockEntity(pos)).getBrewingInventory(), ((BeerBarrelBlockEntity)Minecraft.getInstance().level.getBlockEntity((BlockPos)pos)).syncData, playerInventory, (BeerBarrelBlockEntity)Minecraft.getInstance().level.getBlockEntity(pos));
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow, IItemHandler playerInventory) {
        this.addSlotBox(playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 41 ? !this.moveItemStackTo(itemstack1, 0, 36, false) : (pIndex < 36 ? !this.moveItemStackTo(itemstack1, 36, 41, false) : !this.moveItemStackTo(itemstack1, 0, 36, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player pPlayer) {
        return this.brewingSpace.stillValid(pPlayer);
    }

    public boolean getIsBrewing() {
        return this.syncData.get(1) == 1;
    }

    public int getStandardBrewingTime() {
        return this.syncData.get(0);
    }

    public int getRemainingBrewingTime() {
        return this.syncData.get(0);
    }

    public void removed(Player player) {
        if (!player.level().isClientSide()) {
            player.level().playSound(player, player.blockPosition(), SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.removed(player);
    }

    static class OutputSlot
    extends Slot {
        private final ContainerData syncData;
        private final BeerBarrelBlockEntity beerBarrelBlockEntity;

        public OutputSlot(Container container, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_, ContainerData syncData, BeerBarrelBlockEntity beerBarrelBlockEntity) {
            super(container, p_i1824_2_, p_i1824_3_, p_i1824_4_);
            this.syncData = syncData;
            this.beerBarrelBlockEntity = beerBarrelBlockEntity;
        }

        public void onTake(Player player, ItemStack pStack) {
            if (pStack.getItem() == ItemRegistry.BEER_MUG_FROTHY_PINK_EGGNOG.get()) {
                player.level().playSound(null, this.beerBarrelBlockEntity.getBlockPos(), SoundEventRegistry.POURING_CHRISTMAS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                player.level().playSound(null, this.beerBarrelBlockEntity.getBlockPos(), SoundEventRegistry.POURING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }

        public boolean mayPlace(ItemStack pStack) {
            return false;
        }

        public boolean mayPickup(Player pPlayer) {
            return this.syncData.get(1) == 2;
        }
    }
}

