/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RecipeBoardBlock
extends Block {
    private final boolean acquirableViaPackage;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape NORTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.5);
    public static final VoxelShape SOUTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)14.5, (double)15.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Block.box((double)14.5, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    public static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)1.0, (double)1.5, (double)16.0, (double)15.0);

    public RecipeBoardBlock(boolean acquirableViaPackage) {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOD).strength(1.0f).noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.acquirableViaPackage = acquirableViaPackage;
    }

    public boolean isAcquirableViaPackage() {
        return this.acquirableViaPackage;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        switch (dir) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return WEST_SHAPE;
    }
}

