/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import java.util.Random;
import lekavar.lma.drinkbeer.registries.BlockRegistry;
import lekavar.lma.drinkbeer.registries.ParticleTypeRegistry;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CallBellBlock
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)4.0, (double)10.5);

    public CallBellBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!world.isClientSide()) {
            if (state.getBlock() == BlockRegistry.IRON_CALL_BELL.get()) {
                world.playSound(null, pos, SoundEventRegistry.IRON_CALL_BELL_TINKLING.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
            } else if (state.getBlock() == BlockRegistry.GOLDEN_CALL_BELL.get()) {
                world.playSound(null, pos, SoundEventRegistry.GOLDEN_CALL_BELL_TINKLING.get(), SoundSource.BLOCKS, 1.8f, 1.0f);
            } else if (state.getBlock() == BlockRegistry.LEKAS_CALL_BELL.get()) {
                world.playSound(null, pos, SoundEventRegistry.LEKAS_CALL_BELL_TINKLE.get(), SoundSource.BLOCKS, 0.9f, 1.0f);
            }
        } else {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.2 + new Random().nextDouble() / 4.0;
            double z = (double)pos.getZ() + 0.5;
            if (state.getBlock() == BlockRegistry.IRON_CALL_BELL.get()) {
                world.addParticle((ParticleOptions)ParticleTypes.NOTE, x, y, z, 0.0, 0.0, 0.0);
            } else if (state.getBlock() == BlockRegistry.GOLDEN_CALL_BELL.get()) {
                world.addParticle((ParticleOptions)ParticleTypes.NOTE, x, y, z, 0.0, 0.0, 0.0);
            } else if (state.getBlock() == BlockRegistry.LEKAS_CALL_BELL.get()) {
                world.addParticle((ParticleOptions)((SimpleParticleType)ParticleTypeRegistry.CALL_BELL_TINKLE_PAW.get()), x, y, z, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() == Blocks.AIR) {
            return false;
        }
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }
}

