/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BeerMugBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = IntegerProperty.create((String)"amount", (int)1, (int)3);
    protected static final VoxelShape[] SHAPE_BY_AMOUNT = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0)};

    public BeerMugBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.WOOD).strength(1.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AMOUNT[(Integer)state.getValue((Property)AMOUNT)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AMOUNT, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!world.isClientSide()) {
            ItemStack takeBackBeer = state.getBlock().asItem().getDefaultInstance();
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)takeBackBeer);
            int amount = (Integer)state.getValue((Property)AMOUNT);
            switch (amount) {
                case 2: 
                case 3: {
                    world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.getBlock().defaultBlockState().setValue((Property)AMOUNT, (Comparable)Integer.valueOf(amount - 1))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
                    world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.AMBIENT, 0.5f, 0.5f);
                    break;
                }
                default: {
                    world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.AMBIENT, 0.5f, 0.5f);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() == state.getBlock().asItem()) {
            if (!world.isClientSide()) {
                int amount = (Integer)state.getValue((Property)AMOUNT);
                int mugInHandCount = player.getItemInHand(hand).getCount();
                boolean isCreative = player.isCreative();
                switch (amount) {
                    case 1: {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.getBlock().defaultBlockState().setValue((Property)AMOUNT, (Comparable)Integer.valueOf(2))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
                        if (!isCreative) {
                            player.getItemInHand(hand).setCount(mugInHandCount - 1);
                        }
                        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.getBlock().defaultBlockState().setValue((Property)AMOUNT, (Comparable)Integer.valueOf(3))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
                        if (!isCreative) {
                            player.getItemInHand(hand).setCount(mugInHandCount - 1);
                        }
                        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        break;
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getBlockState(pos.below()).getBlock() instanceof BeerMugBlock) {
            return false;
        }
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }
}

