/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.List;
import javax.annotation.Nonnull;
import lekavar.lma.drinkbeer.items.BeerMugItem;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.items.SpiceBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BartendingTableBlockEntity
extends BlockEntity {
    private final SimpleContainer inv = new OneItemContainer(2);
    public final IItemHandler itemHandler = new BartendingTableInvWrapper(this);

    public BartendingTableBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.BARTENDING_TABLE_TILEENTITY.get(), pos, state);
    }

    public boolean placeBeer(ItemStack itemStack) {
        if (!this.inv.isEmpty()) {
            return false;
        }
        Item beerItem = itemStack.getItem();
        if (!(beerItem instanceof MixedBeerBlockItem) && !(beerItem instanceof BeerMugItem)) {
            return false;
        }
        List<Integer> spiceList = MixedBeerManager.getSpiceList(itemStack);
        if (spiceList.size() >= 3) {
            return false;
        }
        this.inv.setItem(0, itemStack);
        this.markDirty();
        return true;
    }

    public boolean putSpice(ItemStack itemStack) {
        List<Integer> spiceList;
        if (!(itemStack.getItem() instanceof SpiceBlockItem)) {
            return false;
        }
        if (this.inv.isEmpty()) {
            return false;
        }
        if (!this.inv.getItem(1).isEmpty() && (spiceList = MixedBeerManager.getSpiceList(this.inv.getItem(1))).size() >= 3) {
            return false;
        }
        ItemStack beerItem = this.inv.getItem(0);
        if (beerItem.isEmpty()) {
            beerItem = this.inv.getItem(1);
        }
        int beerId = beerItem.getItem() instanceof MixedBeerBlockItem ? MixedBeerBlockItem.getBeerId(beerItem) : Beers.byItem(beerItem.getItem()).getId();
        List<Integer> spiceList2 = MixedBeerManager.getSpiceList(beerItem);
        spiceList2.add(Spices.byItem(itemStack.getItem()).getId());
        ItemStack flavoredBeer = MixedBeerManager.genMixedBeerItemStack(beerId, spiceList2);
        this.inv.setItem(0, ItemStack.EMPTY);
        this.inv.setItem(1, flavoredBeer);
        this.markDirty();
        return true;
    }

    public ItemStack takeBeer(boolean simulate) {
        ItemStack ret = this.inv.getItem(0).copy();
        if (ret.isEmpty()) {
            ret = this.inv.getItem(1).copy();
        }
        if (!simulate && !ret.isEmpty()) {
            this.inv.clearContent();
            this.markDirty();
        }
        return ret;
    }

    public void markDirty() {
        BlockPos pos = this.getBlockPos();
        BlockState bs = this.level.getBlockState(pos);
        this.level.sendBlockUpdated(pos, bs, bs, 2);
        this.setChanged();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.handleUpdateTag(pkt.getTag(), registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.inv.getItems(), (boolean)true, (HolderLookup.Provider)registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.inv.getItems(), (HolderLookup.Provider)registries);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.inv.getItems(), (boolean)true, (HolderLookup.Provider)registries);
    }

    public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.inv.getItems(), (HolderLookup.Provider)registries);
    }

    static class OneItemContainer
    extends SimpleContainer {
        public OneItemContainer(int pSize) {
            super(pSize);
        }

        public int getMaxStackSize() {
            return 1;
        }
    }

    static class BartendingTableInvWrapper
    extends InvWrapper {
        Container inv;
        BartendingTableBlockEntity be;

        public BartendingTableInvWrapper(BartendingTableBlockEntity be) {
            super((Container)be.inv);
            this.inv = be.inv;
            this.be = be;
        }

        public int getSlots() {
            return 3;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 2) {
                return ItemStack.EMPTY;
            }
            return super.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 0 && stack.getItem() instanceof MixedBeerBlockItem || stack.getItem() instanceof BeerMugItem) {
                if (!this.inv.isEmpty()) {
                    return stack;
                }
                List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
                if (spiceList.size() >= 3) {
                    return stack;
                }
                ItemStack ret = stack.copy();
                if (!simulate) {
                    this.be.placeBeer(stack);
                }
                ret.shrink(1);
                return ret;
            }
            if (slot == 2 && stack.getItem() instanceof SpiceBlockItem) {
                List<Integer> spiceList;
                if (this.inv.isEmpty()) {
                    return stack;
                }
                if (!this.inv.getItem(1).isEmpty() && (spiceList = MixedBeerManager.getSpiceList(this.inv.getItem(1))).size() >= 3) {
                    return stack;
                }
                ItemStack ret = stack.copy();
                if (!simulate) {
                    this.be.putSpice(stack);
                }
                ret.shrink(1);
                return ret;
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 || slot == 2) {
                return ItemStack.EMPTY;
            }
            if (!this.inv.getItem(1).isEmpty()) {
                return this.be.takeBeer(simulate);
            }
            return ItemStack.EMPTY;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 2) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0 && stack.getItem() instanceof MixedBeerBlockItem || stack.getItem() instanceof BeerMugItem) {
                if (!this.inv.isEmpty()) {
                    return false;
                }
                List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
                return spiceList.size() < 3;
            }
            if (slot == 2 && stack.getItem() instanceof SpiceBlockItem) {
                List<Integer> spiceList;
                if (this.inv.isEmpty()) {
                    return false;
                }
                return this.inv.getItem(1).isEmpty() || (spiceList = MixedBeerManager.getSpiceList(this.inv.getItem(1))).size() < 3;
            }
            return false;
        }
    }
}

