/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opoliscompat.event;

import com.benbenlaw.opoliscompat.config.CompatStartupConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;

@EventBusSubscriber(modid="bblcompat")
public class BlockReplacingEvent {
    public static TagKey<Block> blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)((String)CompatStartupConfig.blockTag.get())));

    @Deprecated(since="5.2.0")
    @SubscribeEvent
    public static void onChunkGenerationRemovals(ChunkEvent.Load event) {
        if (!((Boolean)CompatStartupConfig.oreRemoval.get()).booleanValue()) {
            return;
        }
        boolean isNewChunk = event.isNewChunk();
        if (!isNewChunk) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        int startX = chunk.getPos().x << 4;
        int startZ = chunk.getPos().z << 4;
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                for (int y = -64; y < 256; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState originalState = chunk.getBlockState(pos);
                    Block block = originalState.getBlock();
                    if (!block.builtInRegistryHolder().is(blockTag)) continue;
                    BlockState newBlockState = BlockReplacingEvent.getReplacementBlockState(chunk, pos);
                    chunk.setBlockState(pos, newBlockState, false);
                }
            }
        }
    }

    private static BlockState getReplacementBlockState(ChunkAccess chunkAccess, BlockPos pos) {
        Direction[] directions;
        for (Direction direction : directions = Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = chunkAccess.getBlockState(neighborPos);
            if (neighborState.isAir() || !neighborState.getFluidState().isEmpty() || !neighborState.isSolid() || neighborState.is(blockTag) || neighborState.getCollisionShape((BlockGetter)chunkAccess, neighborPos).isEmpty()) continue;
            return neighborState;
        }
        return Blocks.STONE.defaultBlockState();
    }
}

