/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import twilightforest.util.WorldUtil;
import twilightforest.util.jigsaw.JigsawPlaceContext;
import twilightforest.world.components.structures.util.TemplateMarkerHandlerList;

public record TemplatePoolInstance(Weight weight, Optional<Holder<StructureProcessorList>> processors, StructureTemplatePool.Projection projection, TerrainAdjustment terrainAdjustment, Optional<HeightAdjustment> beardifierGroundDelta, boolean ignoreWorldWaterlog, Optional<Holder<TemplateMarkerHandlerList>> markerHandlers, Optional<ChooseRandomProcessors> randomizedProcessors, Map<String, String> poolAliases) implements WeightedEntry
{
    private static final Codec<TemplatePoolInstance> CODEC_DIRECT = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Weight.CODEC.fieldOf("weight").forGetter(TemplatePoolInstance::weight), (App)StructureProcessorType.LIST_CODEC.optionalFieldOf("processors").forGetter(TemplatePoolInstance::processors), (App)StructureTemplatePool.Projection.CODEC.optionalFieldOf("projection", (Object)StructureTemplatePool.Projection.RIGID).forGetter(TemplatePoolInstance::projection), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(TemplatePoolInstance::terrainAdjustment), (App)HeightAdjustment.CODEC.optionalFieldOf("height_adjustment").forGetter(TemplatePoolInstance::beardifierGroundDelta), (App)Codec.BOOL.optionalFieldOf("ignore_world_waterlog", (Object)false).forGetter(TemplatePoolInstance::ignoreWorldWaterlog), (App)TemplateMarkerHandlerList.HOLDER_CODEC.optionalFieldOf("marker_handlers").forGetter(TemplatePoolInstance::markerHandlers), (App)ChooseRandomProcessors.CODEC.optionalFieldOf("randomized_processors").forGetter(TemplatePoolInstance::randomizedProcessors), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("pool_aliases", Map.of()).forGetter(TemplatePoolInstance::poolAliases)).apply((Applicative)instance, TemplatePoolInstance::new)), (Codec)Codec.INT, TemplatePoolInstance::defaultsWithWeight);
    public static final Codec<TemplatePoolInstance> CODEC = new TemplatePoolInstanceCodec();

    public static TemplatePoolInstance defaultsWithWeight(int weight) {
        return new TemplatePoolInstance(Weight.of((int)weight), Optional.empty(), StructureTemplatePool.Projection.RIGID, TerrainAdjustment.NONE, Optional.empty(), false, Optional.empty(), Optional.empty(), Map.of());
    }

    public Weight getWeight() {
        return this.weight;
    }

    public JigsawPlaceContext adjustContextForTerrain(JigsawPlaceContext placeContext, Structure.GenerationContext generationContext, boolean parentProjectsTerrain) {
        if (this.beardifierGroundDelta.isEmpty()) {
            return placeContext;
        }
        return this.beardifierGroundDelta.get().adjustForTerrain(placeContext, generationContext, parentProjectsTerrain);
    }

    public StructureProcessorList chooseRandomProcessors(RandomSource randomSource) {
        if (this.randomizedProcessors.isEmpty()) {
            return new StructureProcessorList(List.of());
        }
        return this.randomizedProcessors.get().chooseRandomProcessors(randomSource);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatePoolInstance that = (TemplatePoolInstance)o;
        return Objects.equals(this.weight(), that.weight()) && this.terrainAdjustment() == that.terrainAdjustment() && (this.processors.isEmpty() && that.processors.isEmpty() || this.processors.isPresent() && that.processors.isPresent() && Objects.equals(((StructureProcessorList)this.processors().get().value()).list(), ((StructureProcessorList)that.processors().get().value()).list())) && this.projection() == that.projection();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.weight(), this.processors().map(Holder::value).map(StructureProcessorList::list), this.projection(), this.terrainAdjustment());
    }

    public record HeightAdjustment(Heightmap.Types heightType, int beardifierGroundDelta, Optional<Integer> groundJunctionDiffLimit) {
        public static final Codec<HeightAdjustment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(HeightAdjustment::heightType), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(HeightAdjustment::beardifierGroundDelta), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("ground_junction_diff_clamp").forGetter(HeightAdjustment::groundJunctionDiffLimit)).apply((Applicative)instance, HeightAdjustment::new));

        public JigsawPlaceContext adjustForTerrain(JigsawPlaceContext placeContext, Structure.GenerationContext generationContext, boolean parentProjectsTerrain) {
            BoundingBox box = placeContext.makeBoundingBox(generationContext.structureTemplateManager());
            int yAdjusted = parentProjectsTerrain ? this.clampYLevelPos(generationContext, placeContext, placeContext.templatePos().offset((Vec3i)placeContext.seedJigsaw().pos())) : this.clampYLevelBox(generationContext, placeContext, box);
            return new JigsawPlaceContext(placeContext.templatePos().atY(yAdjusted), placeContext.placementSettings().copy(), placeContext.seedJigsaw(), List.copyOf(placeContext.spareJigsaws()), placeContext.templateLocation());
        }

        private int clampYLevelBox(Structure.GenerationContext generationContext, JigsawPlaceContext placeContext, BoundingBox box) {
            if (this.groundJunctionDiffLimit.isEmpty()) {
                return this.beardifierGroundDelta + WorldUtil.adjustForTerrain(generationContext, box.minX(), box.minZ(), box.maxX(), box.maxZ(), 2, this.heightType);
            }
            int templateY = placeContext.templatePos().getY();
            int variantLimit = this.groundJunctionDiffLimit.get();
            if (variantLimit == 0) {
                return templateY;
            }
            int yTerrain = WorldUtil.adjustForTerrain(generationContext, box.minX(), box.minZ(), box.maxX(), box.maxZ(), 2, this.heightType);
            return Mth.clamp((int)(this.beardifierGroundDelta + yTerrain), (int)(templateY - variantLimit), (int)(templateY + variantLimit));
        }

        private int clampYLevelPos(Structure.GenerationContext generationContext, JigsawPlaceContext placeContext, BlockPos pos) {
            if (this.groundJunctionDiffLimit.isEmpty()) {
                return this.beardifierGroundDelta + generationContext.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), this.heightType, generationContext.heightAccessor(), generationContext.randomState());
            }
            int templateY = placeContext.templatePos().getY();
            int variantLimit = this.groundJunctionDiffLimit.get();
            if (variantLimit == 0) {
                return templateY;
            }
            int yTerrain = generationContext.chunkGenerator().getFirstOccupiedHeight(pos.getX(), pos.getZ(), this.heightType, generationContext.heightAccessor(), generationContext.randomState());
            return Mth.clamp((int)(this.beardifierGroundDelta + yTerrain), (int)(templateY - variantLimit), (int)(templateY + variantLimit));
        }
    }

    public record ChooseRandomProcessors(List<SimpleWeightedRandomList<StructureProcessor>> processors) {
        public static final Codec<ChooseRandomProcessors> CODEC = SimpleWeightedRandomList.wrappedCodec((Codec)StructureProcessorType.SINGLE_CODEC).listOf().xmap(ChooseRandomProcessors::new, ChooseRandomProcessors::processors);

        public StructureProcessorList chooseRandomProcessors(RandomSource random) {
            ArrayList chosenProcessors = new ArrayList();
            for (SimpleWeightedRandomList<StructureProcessor> list : this.processors) {
                list.getRandomValue(random).ifPresent(chosenProcessors::add);
            }
            return new StructureProcessorList(Collections.unmodifiableList(chosenProcessors));
        }
    }

    private static class TemplatePoolInstanceCodec
    implements Codec<TemplatePoolInstance> {
        private TemplatePoolInstanceCodec() {
        }

        public <T> DataResult<T> encode(TemplatePoolInstance input, DynamicOps<T> ops, T prefix) {
            int weight = input.weight.asInt();
            if (input.equals(TemplatePoolInstance.defaultsWithWeight(weight))) {
                return DataResult.success((Object)ops.createInt(weight));
            }
            return CODEC_DIRECT.encodeStart(ops, (Object)input);
        }

        public <T> DataResult<Pair<TemplatePoolInstance, T>> decode(DynamicOps<T> ops, T input) {
            DataResult parse = CODEC_DIRECT.parse(ops, input);
            Optional templatePoolInstance = parse.resultOrPartial();
            if (templatePoolInstance.isEmpty()) {
                return DataResult.error(() -> "TemplatePoolInstance.CODEC deserialization problem:\n" + String.valueOf(parse) + "\n\n from data:\n" + String.valueOf(input));
            }
            return DataResult.success((Object)Pair.of((Object)((TemplatePoolInstance)templatePoolInstance.get()), input));
        }
    }
}

