/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.SpeleothemVarietyConfig;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;
import twilightforest.util.iterators.RectangleLatticeIterator;
import twilightforest.world.components.feature.BlockSpikeFeature;

public record StructureSpeleothemConfig(RectangleLatticeIterator.TriangularLatticeConfig latticeConfig, String speleothemVarietyType, java.util.function.Supplier<SpeleothemVarietyConfig> speleothemVarietyConfig, java.util.function.Supplier<Function<RandomSource, Stalactite>> stalactiteVariety, java.util.function.Supplier<Function<RandomSource, Stalactite>> stalagmiteVariety) {
    public static final Codec<StructureSpeleothemConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RectangleLatticeIterator.TriangularLatticeConfig.CODEC.fieldOf("lattice").forGetter(StructureSpeleothemConfig::latticeConfig), (App)Codec.STRING.xmap(String::toLowerCase, String::toLowerCase).fieldOf("type").forGetter(StructureSpeleothemConfig::speleothemVarietyType)).apply((Applicative)inst, StructureSpeleothemConfig::fromLocation));

    @NotNull
    public static StructureSpeleothemConfig fromLocation(RectangleLatticeIterator.TriangularLatticeConfig latticeConfig, String type) {
        Supplier lazyConfigSupplier = Suppliers.memoize(() -> StalactiteReloadListener.HILL_CONFIGS.get(type));
        Supplier lazyStalactiteGetter = Suppliers.memoize(() -> StructureSpeleothemConfig.lambda$fromLocation$2((java.util.function.Supplier)lazyConfigSupplier));
        Supplier lazyStalagmiteGetter = Suppliers.memoize(() -> StructureSpeleothemConfig.lambda$fromLocation$3((java.util.function.Supplier)lazyConfigSupplier));
        return new StructureSpeleothemConfig(latticeConfig, type, (java.util.function.Supplier<SpeleothemVarietyConfig>)lazyConfigSupplier, (java.util.function.Supplier<Function<RandomSource, Stalactite>>)lazyStalactiteGetter, (java.util.function.Supplier<Function<RandomSource, Stalactite>>)lazyStalagmiteGetter);
    }

    @NotNull
    private static Function<RandomSource, Stalactite> compileStalagmites(java.util.function.Supplier<SpeleothemVarietyConfig> varietyConfigSupplier) {
        SpeleothemVarietyConfig varietyConfig = varietyConfigSupplier.get();
        TwilightForestMod.LOGGER.debug("Compiling Stalagmite configs for " + varietyConfig.type() + " type");
        List<Stalactite> stalactites = StalactiteReloadListener.STALAGMITES_PER_HILL.get(varietyConfig.type());
        return StructureSpeleothemConfig.compileSpeleothemsSimple(stalactites);
    }

    @NotNull
    private static Function<RandomSource, Stalactite> compileStalactites(java.util.function.Supplier<SpeleothemVarietyConfig> varietyConfigSupplier) {
        SpeleothemVarietyConfig varietyConfig = varietyConfigSupplier.get();
        TwilightForestMod.LOGGER.debug("Compiling Stalactite configs for " + varietyConfig.type() + " type");
        float weightedListInterpolation = Mth.clamp((float)varietyConfig.oreChance(), (float)0.0f, (float)1.0f);
        List<Stalactite> stalactites = StalactiteReloadListener.STALACTITES_PER_HILL.get(varietyConfig.type());
        List<Stalactite> oreStalactites = StalactiteReloadListener.ORE_STALACTITES_PER_HILL.get(varietyConfig.type());
        int stoneWeightSum = stalactites.stream().mapToInt(Stalactite::weight).sum();
        int oreWeightSum = oreStalactites.stream().mapToInt(Stalactite::weight).sum();
        float totalWeight = stoneWeightSum + oreWeightSum;
        if (totalWeight <= 0.0f) {
            return BlockSpikeFeature::defaultRandom;
        }
        if (stalactites.isEmpty() || stoneWeightSum <= 0) {
            return StructureSpeleothemConfig.compileSpeleothemsSimple(oreStalactites);
        }
        if (oreStalactites.isEmpty() || oreWeightSum <= 0) {
            return StructureSpeleothemConfig.compileSpeleothemsSimple(stalactites);
        }
        double quantizationFactor = Math.ceil(Math.pow(10.0, Mth.clamp((int)(("" + weightedListInterpolation + totalWeight).length() - 4), (int)2, (int)6)));
        double stoneCounterweight = quantizationFactor * (double)(1.0f - weightedListInterpolation) / (double)stoneWeightSum;
        double oreCounterweight = quantizationFactor * (double)weightedListInterpolation / (double)oreWeightSum;
        if (stoneCounterweight <= 0.0) {
            return StructureSpeleothemConfig.compileSpeleothemsSimple(oreStalactites);
        }
        if (oreCounterweight <= 0.0) {
            return StructureSpeleothemConfig.compileSpeleothemsSimple(stalactites);
        }
        ArrayList unbakedRandomList = stalactites.stream().map(s -> WeightedEntry.wrap((Object)s, (int)Mth.ceil((double)((double)s.weight() * stoneCounterweight)))).collect(Collectors.toCollection(ArrayList::new));
        oreStalactites.stream().map(s -> WeightedEntry.wrap((Object)s, (int)Mth.ceil((double)((double)s.weight() * oreCounterweight)))).forEachOrdered(unbakedRandomList::add);
        StringJoiner joiner = new StringJoiner("\n");
        joiner.add("").add("Ore interpolation factor: " + weightedListInterpolation).add("Stone Counterweight: " + stoneCounterweight).add("Ore Counterweight: " + oreCounterweight);
        for (WeightedEntry.Wrapper e2 : unbakedRandomList) {
            joiner.add(String.valueOf(e2.data()) + " - After counterweight: " + e2.getWeight().asInt());
        }
        joiner.add("Total weight after counterweights: " + unbakedRandomList.stream().mapToInt(e -> e.getWeight().asInt()).sum());
        TwilightForestMod.LOGGER.debug((Object)joiner);
        return StructureSpeleothemConfig.compileSpeleothems(unbakedRandomList);
    }

    @NotNull
    private static Function<RandomSource, Stalactite> compileSpeleothemsSimple(List<Stalactite> stalactites) {
        return StructureSpeleothemConfig.compileSpeleothems(stalactites.stream().map(stalactite -> WeightedEntry.wrap((Object)stalactite, (int)stalactite.weight())).toList());
    }

    @NotNull
    private static Function<RandomSource, Stalactite> compileSpeleothems(List<WeightedEntry.Wrapper<Stalactite>> unbakedRandomList) {
        WeightedRandomList randomList = WeightedRandomList.create(unbakedRandomList);
        if (randomList.isEmpty() || randomList.unwrap().stream().mapToInt(w -> w.getWeight().asInt()).sum() <= 0) {
            return BlockSpikeFeature::defaultRandom;
        }
        return random -> randomList.getRandom(random).map(WeightedEntry.Wrapper::data).orElse(BlockSpikeFeature.STONE_STALACTITE);
    }

    public SpeleothemVarietyConfig getVarietyConfig() {
        return this.speleothemVarietyConfig.get();
    }

    public boolean shouldDoAStalactite(RandomSource rand) {
        return this.getVarietyConfig().shouldDoAStalactite(rand);
    }

    public boolean shouldDoAStalagmite(RandomSource rand) {
        return this.getVarietyConfig().shouldDoAStalagmite(rand);
    }

    @NotNull
    public Stalactite getStalactite(RandomSource rand) {
        return this.stalactiteVariety.get().apply(rand);
    }

    @NotNull
    public Stalactite getStalagmite(RandomSource rand) {
        return this.stalagmiteVariety.get().apply(rand);
    }

    @NotNull
    public Stalactite getSpeleothem(boolean hanging, RandomSource rand) {
        return hanging ? this.getStalactite(rand) : this.getStalagmite(rand);
    }

    @NotNull
    public Iterable<BlockPos.MutableBlockPos> latticeIterator(@Nullable BoundingBox bounds, int yLevel) {
        if (bounds == null) {
            return List.of();
        }
        return this.latticeConfig.boundedGrid(bounds, yLevel);
    }

    private static /* synthetic */ Function lambda$fromLocation$3(java.util.function.Supplier lazyConfigSupplier) {
        return StructureSpeleothemConfig.compileStalagmites(lazyConfigSupplier);
    }

    private static /* synthetic */ Function lambda$fromLocation$2(java.util.function.Supplier lazyConfigSupplier) {
        return StructureSpeleothemConfig.compileStalactites(lazyConfigSupplier);
    }
}

