/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.features.FeaturePlacers;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.StructureSpeleothemConfig;

public class HydraLairComponent
extends HollowHillComponent {
    public HydraLairComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(ctx, (StructurePieceType)TFStructurePieceTypes.TFHydra.get(), nbt);
    }

    public HydraLairComponent(int i, int x, int y, int z, Holder.Reference<StructureSpeleothemConfig> speleothemConfig) {
        super((StructurePieceType)TFStructurePieceTypes.TFHydra.get(), i, 2, x, y + 2, z, speleothemConfig);
    }

    public void addChildren(StructurePiece structurecomponent, StructurePieceAccessor accessor, RandomSource random) {
    }

    @Override
    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox writeableBounds, ChunkPos chunkPosIn, BlockPos blockPos) {
        FeaturePlacers.replaceBlocksDome(world, this.boundingBox.getCenter().atY(this.getWorldY(-4)), 36.5f, 0.0125f, writeableBounds, this.boundingBox.inflatedBy(4), (HolderSet<Block>)HolderSet.direct((Holder[])new Holder[]{Blocks.GRASS_BLOCK.builtInRegistryHolder(), Blocks.DIRT.builtInRegistryHolder()}), Blocks.STONE.defaultBlockState());
        FeaturePlacers.replaceBlocksDome(world, this.boundingBox.getCenter().offset(-16, 0, -16).atY(this.getWorldY(-1)), 18.5f, 0.0125f, writeableBounds, this.boundingBox.inflatedBy(1), (HolderSet<Block>)HolderSet.direct((Holder[])new Holder[]{Blocks.STONE.builtInRegistryHolder()}), Blocks.GRASS_BLOCK.defaultBlockState());
        this.generateSpeleothems(world, rand, writeableBounds);
        this.placeBlock(world, ((Block)TFBlocks.HYDRA_BOSS_SPAWNER.get()).defaultBlockState(), 27, 3, 27, writeableBounds);
    }

    private void generateSpeleothems(WorldGenLevel world, RandomSource rand, BoundingBox writeableBounds) {
        float radiusSq = 0.9f * (float)this.radius * (float)this.radius;
        BlockPos locator = this.getLocatorPosition();
        BlockPos exclusionCenter = locator.offset(-16, 0, -16);
        float exclusionRadiusSq = 529.0f;
        for (BlockPos.MutableBlockPos dest : this.speleothemConfig.latticeIterator(writeableBounds, 0)) {
            float distSq;
            int dZ;
            int dX = dest.getX() - exclusionCenter.getX();
            if ((float)(dX * dX + (dZ = dest.getZ() - exclusionCenter.getZ()) * dZ) < exclusionRadiusSq || (distSq = HydraLairComponent.getDistSqFromCenter(locator, (BlockPos)dest)) > rand.nextFloat() * 0.9f * radiusSq) continue;
            dest.setY(Mth.floor((float)(Mth.cos((float)(Mth.sqrt((float)distSq) / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f))));
            if (this.speleothemConfig.shouldDoAStalactite(rand)) {
                this.generateSpeleothem(world, (BlockPos)dest, writeableBounds, true);
            }
            if (!this.speleothemConfig.shouldDoAStalagmite(rand) || (rand.nextFloat() * 0.667f + 0.333f) * distSq / radiusSq < 0.333f) continue;
            dest.setY(1);
            this.generateSpeleothem(world, (BlockPos)dest, writeableBounds, false);
        }
    }
}

