/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.custom.BiomeLayerStack;
import twilightforest.init.custom.BiomeLayerTypes;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.layer.vanillalegacy.Area;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerFactory;
import twilightforest.world.components.layer.vanillalegacy.BiomeLayerType;
import twilightforest.world.components.layer.vanillalegacy.area.LazyArea;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;
import twilightforest.world.components.layer.vanillalegacy.context.RandomContext;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer1;

public record KeyBiomesLayer(List<ResourceKey<Biome>> keyBiomes) implements AreaTransformer1
{
    @Override
    public int getParentX(int x) {
        return x | 3;
    }

    @Override
    public int getParentY(int z) {
        return z | 3;
    }

    @Override
    public ResourceKey<Biome> applyPixel(RandomContext randomContext, Area layer, int x, int z) {
        Random rand = new Random(WorldUtil.getOverworldSeed() + (long)(x & 0xFFFFFFFC) * 25117L + (long)(z & 0xFFFFFFFC) * 151121L);
        int ox = rand.nextInt(2) + 1;
        int oz = rand.nextInt(2) + 1;
        rand.setSeed(WorldUtil.getOverworldSeed() + (long)(x / 8) * 25117L + (long)(z / 8) * 151121L);
        int offset = rand.nextInt(3);
        if ((x & 3) == ox && (z & 3) == oz) {
            if ((x & 4) == 0) {
                if ((z & 4) == 0) {
                    return this.getKeyBiomeFor(offset);
                }
                return this.getKeyBiomeFor(offset + 1);
            }
            if ((z & 4) == 0) {
                return this.getKeyBiomeFor(offset + 2);
            }
            return this.getKeyBiomeFor(offset + 3);
        }
        return layer.getBiome(x, z);
    }

    private ResourceKey<Biome> getKeyBiomeFor(int index) {
        return this.keyBiomes.get(index & 3);
    }

    public static final class Factory
    implements BiomeLayerFactory {
        public static final MapCodec<Factory> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.LONG.fieldOf("salt").forGetter(Factory::salt), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)4), Function.identity()).fieldOf("key_biomes").forGetter(Factory::keyBiomes), (App)BiomeLayerStack.HOLDER_CODEC.fieldOf("parent").forGetter(Factory::parent)).apply((Applicative)inst, Factory::new));
        private final long salt;
        private final List<ResourceKey<Biome>> keyBiomes;
        private final Holder<BiomeLayerFactory> parent;
        private final KeyBiomesLayer instance;

        public Factory(long salt, List<ResourceKey<Biome>> keyBiomes, Holder<BiomeLayerFactory> parent) {
            this.salt = salt;
            this.keyBiomes = keyBiomes;
            this.parent = parent;
            this.instance = new KeyBiomesLayer(keyBiomes);
        }

        @Override
        public LazyArea build(LongFunction<LazyAreaContext> contextFactory) {
            return this.instance.run(contextFactory.apply(this.salt), ((BiomeLayerFactory)this.parent.value()).build(contextFactory));
        }

        @Override
        public BiomeLayerType getType() {
            return (BiomeLayerType)BiomeLayerTypes.KEY_BIOMES.get();
        }

        public long salt() {
            return this.salt;
        }

        public List<ResourceKey<Biome>> keyBiomes() {
            return this.keyBiomes;
        }

        public Holder<BiomeLayerFactory> parent() {
            return this.parent;
        }
    }
}

