/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import twilightforest.init.TFBlocks;

public class UndergroundPlantFeature
extends Feature<BlockStateConfiguration> {
    int maxCount;

    public UndergroundPlantFeature(Codec<BlockStateConfiguration> config, int maxCount) {
        super(config);
        this.maxCount = maxCount;
    }

    public UndergroundPlantFeature(Codec<BlockStateConfiguration> config) {
        super(config);
        this.maxCount = Integer.MAX_VALUE;
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> ctx) {
        WorldGenLevel world = ctx.level();
        BlockPos origin = ctx.origin();
        RandomSource random = ctx.random();
        int x = origin.getX();
        int z = origin.getZ();
        int placed = 0;
        for (int y = origin.getY(); y > world.getMinBuildHeight() && placed < this.maxCount; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!world.isEmptyBlock(pos) || random.nextInt(6) == 0) {
                x = origin.getX() + random.nextInt(4) - random.nextInt(4);
                z = origin.getZ() + random.nextInt(4) - random.nextInt(4);
                continue;
            }
            BlockState state = ((BlockStateConfiguration)ctx.config()).state;
            if (state.is(TFBlocks.TROLLVIDR) && random.nextInt(10) == 0) {
                state = ((Block)TFBlocks.UNRIPE_TROLLBER.get()).defaultBlockState();
            }
            if (!state.canSurvive((LevelReader)world, pos)) continue;
            world.setBlock(pos, state, 18);
            ++placed;
        }
        return placed > 0;
    }
}

