/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TravellersModifiersManager;

public record GogglesZoomPacket(boolean isUsingZoom, UUID playerUUID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GogglesZoomPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("goggles_zoom_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GogglesZoomPacket> STREAM_CODEC = CustomPacketPayload.codec(GogglesZoomPacket::write, GogglesZoomPacket::new);

    public GogglesZoomPacket(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        this(registryFriendlyByteBuf.readBoolean(), registryFriendlyByteBuf.readUUID());
    }

    private void write(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        registryFriendlyByteBuf.writeBoolean(this.isUsingZoom);
        registryFriendlyByteBuf.writeUUID(this.playerUUID);
    }

    public static void handle(GogglesZoomPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player().level().getPlayerByUUID(packet.playerUUID);
            if (player == null) {
                return;
            }
            if (player.level().isClientSide()) {
                player.setData(TFDataAttachments.IS_USING_GOGGLES_ZOOM_MODIFIER, (Object)packet.isUsingZoom);
                return;
            }
            boolean canChangeZoomState = TravellersModifiersManager.isModifierActive((LivingEntity)player, TravellersModifiersManager.ZOOM_ABILITY);
            if (canChangeZoomState) {
                player.setData(TFDataAttachments.IS_USING_GOGGLES_ZOOM_MODIFIER, (Object)packet.isUsingZoom);
                player.playSound(packet.isUsingZoom ? (SoundEvent)TFSounds.GOGGLES_ZOOM_IN.get() : (SoundEvent)TFSounds.GOGGLES_ZOOM_OUT.get());
                PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new GogglesZoomPacket(packet.isUsingZoom, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

