/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import twilightforest.components.entity.GiantPickaxeMiningAttachment;
import twilightforest.init.TFDataAttachments;

public class GiantToolGroupingModifier
extends LootModifier {
    public static Map<Block, Item> CONVERSIONS = new HashMap<Block, Item>();
    public static final MapCodec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));

    public GiantToolGroupingModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.getParam(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            BlockItem block;
            Item item;
            Player player = (Player)object;
            if (!generatedLoot.isEmpty() && (item = ((ItemStack)generatedLoot.getFirst()).getItem()) instanceof BlockItem && CONVERSIONS.containsKey((block = (BlockItem)item).getBlock())) {
                GiantPickaxeMiningAttachment attachment = (GiantPickaxeMiningAttachment)player.getData(TFDataAttachments.GIANT_PICKAXE_MINING);
                int blockConversion = attachment.getGiantBlockConversion();
                attachment.setGiantBlockConversion(blockConversion - 1);
                if (blockConversion == 64) {
                    return ObjectArrayList.of((Object[])new ItemStack[]{new ItemStack((ItemLike)CONVERSIONS.get(block.getBlock()))});
                }
                return new ObjectArrayList();
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

