/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import twilightforest.TwilightForestMod;

public class TFLootTables {
    private static final Set<ResourceKey<LootTable>> TF_LOOT_TABLES = Sets.newHashSet();
    private static final Set<ResourceKey<LootTable>> TF_IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(TF_LOOT_TABLES);
    public static final int DEFAULT_PLACE_FLAG = 2;
    public static final ResourceKey<LootTable> SUSPICIOUS_STEW = TFLootTables.register("chests/suspicious_stew");
    public static final ResourceKey<LootTable> SMALL_HOLLOW_HILL = TFLootTables.register("hill_1");
    public static final ResourceKey<LootTable> MEDIUM_HOLLOW_HILL = TFLootTables.register("hill_2");
    public static final ResourceKey<LootTable> LARGE_HOLLOW_HILL = TFLootTables.register("hill_3");
    public static final ResourceKey<LootTable> HEDGE_MAZE = TFLootTables.register("hedge_maze");
    public static final ResourceKey<LootTable> HEDGE_CLOTH = TFLootTables.register("hedge_cloth");
    public static final ResourceKey<LootTable> FANCY_WELL = TFLootTables.register("fancy_well");
    public static final ResourceKey<LootTable> WELL = TFLootTables.register("well");
    public static final ResourceKey<LootTable> LABYRINTH_ROOM = TFLootTables.register("labyrinth_room");
    public static final ResourceKey<LootTable> LABYRINTH_DEAD_END = TFLootTables.register("labyrinth_dead_end");
    public static final ResourceKey<LootTable> TOWER_ROOM = TFLootTables.register("chests/tower_room");
    public static final ResourceKey<LootTable> TOWER_LIBRARY = TFLootTables.register("chests/tower_library");
    public static final ResourceKey<LootTable> TOWER_POTION = TFLootTables.register("chests/tower_potion");
    public static final ResourceKey<LootTable> JUST_BONES = TFLootTables.register("chests/just_bones");
    public static final ResourceKey<LootTable> TOWER_GRAVE_LOWER = TFLootTables.register("chests/tower_grave_lower");
    public static final ResourceKey<LootTable> TOWER_GRAVE_UPPER = TFLootTables.register("chests/tower_grave_upper");
    public static final ResourceKey<LootTable> TOWER_ENCHANTING = TFLootTables.register("chests/tower_enchanting");
    public static final ResourceKey<LootTable> TOWER_JARS = TFLootTables.register("chests/tower_jars");
    public static final ResourceKey<LootTable> TOWER_FOYER = TFLootTables.register("chests/tower_foyer");
    public static final ResourceKey<LootTable> CASKET_LOOT = TFLootTables.register("chests/casket_loot");
    public static final ResourceKey<LootTable> BASEMENT = TFLootTables.register("chests/basement");
    public static final ResourceKey<LootTable> HUT_JUNK = TFLootTables.register("chests/hut_junk");
    public static final ResourceKey<LootTable> FOUNDATION_BASEMENT = TFLootTables.register("foundation_basement");
    public static final ResourceKey<LootTable> LABYRINTH_VAULT = TFLootTables.register("labyrinth_vault");
    public static final ResourceKey<LootTable> LABYRINTH_VAULT_JACKPOT = TFLootTables.register("labyrinth_vault_jackpot");
    public static final ResourceKey<LootTable> DARKTOWER_CACHE = TFLootTables.register("darktower_cache");
    public static final ResourceKey<LootTable> DARKTOWER_KEY = TFLootTables.register("darktower_key");
    public static final ResourceKey<LootTable> DARKTOWER_BOSS = TFLootTables.register("darktower_boss");
    public static final ResourceKey<LootTable> TREE_CACHE = TFLootTables.register("tree_cache");
    public static final ResourceKey<LootTable> FALLEN_TRUNK_LOOT = TFLootTables.register("fallen_trunk_loot");
    public static final ResourceKey<LootTable> STRONGHOLD_CACHE = TFLootTables.register("stronghold_cache");
    public static final ResourceKey<LootTable> STRONGHOLD_ROOM = TFLootTables.register("stronghold_room");
    public static final ResourceKey<LootTable> AURORA_CACHE = TFLootTables.register("aurora_cache");
    public static final ResourceKey<LootTable> AURORA_ROOM = TFLootTables.register("aurora_room");
    public static final ResourceKey<LootTable> TROLL_GARDEN = TFLootTables.register("troll_garden");
    public static final ResourceKey<LootTable> TROLL_VAULT = TFLootTables.register("troll_vault");
    public static final ResourceKey<LootTable> TROLL_VAULT_WITH_LAMP = TFLootTables.register("troll_vault_with_lamp");
    public static final ResourceKey<LootTable> GRAVEYARD = TFLootTables.register("graveyard");
    public static final ResourceKey<LootTable> QUEST_GROVE = TFLootTables.register("quest_grove_dropper");
    public static final ResourceKey<LootTable> USELESS_LOOT = TFLootTables.register("useless");
    public static final ResourceKey<LootTable> CAMP_TENT = TFLootTables.register("camp_tent");
    public static final ResourceKey<LootTable> CAMP_ARMOR_RACK = TFLootTables.register("camp_armor_rack");
    public static final ResourceKey<LootTable> CAMP_DRYING_RACK = TFLootTables.register("camp_drying_rack");
    public static final ResourceKey<LootTable> CAMP_POT = TFLootTables.register("camp_pot");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_WHITE = TFLootTables.register("entities/bighorn_sheep/white");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_ORANGE = TFLootTables.register("entities/bighorn_sheep/orange");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_MAGENTA = TFLootTables.register("entities/bighorn_sheep/magenta");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_LIGHT_BLUE = TFLootTables.register("entities/bighorn_sheep/light_blue");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_YELLOW = TFLootTables.register("entities/bighorn_sheep/yellow");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_LIME = TFLootTables.register("entities/bighorn_sheep/lime");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_PINK = TFLootTables.register("entities/bighorn_sheep/pink");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_GRAY = TFLootTables.register("entities/bighorn_sheep/gray");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_LIGHT_GRAY = TFLootTables.register("entities/bighorn_sheep/light_gray");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_CYAN = TFLootTables.register("entities/bighorn_sheep/cyan");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_PURPLE = TFLootTables.register("entities/bighorn_sheep/purple");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_BLUE = TFLootTables.register("entities/bighorn_sheep/blue");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_BROWN = TFLootTables.register("entities/bighorn_sheep/brown");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_GREEN = TFLootTables.register("entities/bighorn_sheep/green");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_RED = TFLootTables.register("entities/bighorn_sheep/red");
    public static final ResourceKey<LootTable> BIGHORN_SHEEP_BLACK = TFLootTables.register("entities/bighorn_sheep/black");
    public static final ResourceKey<LootTable> QUESTING_RAM_REWARDS = TFLootTables.register("entities/questing_ram_rewards");
    public static final ResourceKey<LootTable> QUESTING_RAM_REWARD_BLOCKS = TFLootTables.register("entities/questing_ram_reward_blocks");
    public static final ResourceKey<LootTable> DEATH_TOME_HURT = TFLootTables.register("entities/death_tome_hurt");
    public static final ResourceKey<LootTable> DEATH_TOME_BOOKS = TFLootTables.register("entities/death_tome_books");
    public static final ResourceKey<LootTable> LIFEDRAIN_SCEPTER_KILL_BONUS = TFLootTables.register("items/lifedrain_scepter_kill_bonus");
    public static final ResourceKey<LootTable> KNIGHT_PHANTOM_DEFEATED = TFLootTables.register("entities/knight_phantom_defeated");
    public static final ResourceKey<LootTable> OMINOUS_SPAWNER_DROPS = TFLootTables.register("blocks/ominous_spawner_drops");
    public static final ResourceKey<LootTable> CICADA_SQUISH_DROPS = TFLootTables.register("blocks/cicada_squish");
    public static final ResourceKey<LootTable> FIREFLY_SQUISH_DROPS = TFLootTables.register("blocks/firefly_squish");
    public static final ResourceKey<LootTable> MOONWORM_FAILED_TO_PLACE_DROPS = TFLootTables.register("blocks/moonworm_failed_to_place");
    public static final ResourceKey<LootTable> MOONWORM_SQUISH_DROPS = TFLootTables.register("blocks/moonworm_squish");
    public static final ResourceKey<LootTable> RASPBERRY_BUSH_DROPS = TFLootTables.register("blocks/raspberry_bush_berries");
    public static final ResourceKey<LootTable> BLUEBERRY_BUSH_DROPS = TFLootTables.register("blocks/blueberry_bush_berries");
    public static final ResourceKey<LootTable> BLACKBERRY_BUSH_DROPS = TFLootTables.register("blocks/blackberry_bush_berries");
    public static final ResourceKey<LootTable> MALOBERRY_BUSH_DROPS = TFLootTables.register("blocks/maloberry_bush_berries");
    public static final ResourceKey<LootTable> BLIGHTBERRY_BUSH_DROPS = TFLootTables.register("blocks/blightberry_bush_berries");
    public static final ResourceKey<LootTable> DUSKBERRY_BUSH_DROPS = TFLootTables.register("blocks/duskberry_bush_berries");
    public static final ResourceKey<LootTable> SKYBERRY_BUSH_DROPS = TFLootTables.register("blocks/skyberry_bush_berries");
    public static final ResourceKey<LootTable> STINGBERRY_BUSH_DROPS = TFLootTables.register("blocks/stingberry_bush_berries");
    public static final ResourceKey<LootTable> COPPER_OREBERRY_BUSH_DROPS = TFLootTables.register("blocks/copper_oreberry_bush_berries");
    public static final ResourceKey<LootTable> IRON_OREBERRY_BUSH_DROPS = TFLootTables.register("blocks/iron_oreberry_bush_berries");
    public static final ResourceKey<LootTable> GOLD_OREBERRY_BUSH_DROPS = TFLootTables.register("blocks/gold_oreberry_bush_berries");
    public static final ResourceKey<LootTable> ESSENCE_BERRY_BUSH_DROPS = TFLootTables.register("blocks/essence_berry_bush_berries");

    public static void generateChest(WorldGenLevel world, BlockPos pos, Direction dir, boolean trapped, ResourceKey<LootTable> lootTable) {
        TFLootTables.generateLootContainer(world, pos, (BlockState)(trapped ? Blocks.TRAPPED_CHEST : Blocks.CHEST).defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)dir), 2, lootTable);
    }

    public static void generateLootContainer(WorldGenLevel world, BlockPos pos, BlockState state, int flags, ResourceKey<LootTable> lootTable) {
        world.setBlock(pos, state, flags);
        TFLootTables.generateChestContents(world, pos, lootTable);
    }

    public static void generateLootContainer(LevelAccessor world, BlockPos pos, BlockState state, int flags, long seed, ResourceKey<LootTable> lootTable) {
        world.setBlock(pos, state, flags);
        TFLootTables.generateChestContents(world, pos, seed, lootTable);
    }

    public static void generateChestContents(WorldGenLevel level, BlockPos pos, ResourceKey<LootTable> lootTable) {
        TFLootTables.generateChestContents((LevelAccessor)level, pos, level.getSeed() * (long)pos.getX() + (long)pos.getY() ^ (long)pos.getZ(), lootTable);
    }

    public static void generateChestContents(LevelAccessor level, BlockPos pos, long seed, ResourceKey<LootTable> lootTable) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity lootContainer = (RandomizableContainerBlockEntity)blockEntity;
            lootContainer.setLootTable(lootTable, seed);
        }
    }

    private static ResourceKey<LootTable> register(String id) {
        return TFLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)TwilightForestMod.prefix(id)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> id) {
        if (TF_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered built-in loot table");
    }

    public static LootParams.Builder createLootParams(LivingEntity entity, boolean checkPlayerKill, DamageSource source) {
        LivingEntity livingEntity;
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)source.getDirectEntity());
        if (checkPlayerKill && (livingEntity = entity.getKillCredit()) instanceof Player) {
            Player player = (Player)livingEntity;
            lootcontext$builder = lootcontext$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(player.getLuck());
        }
        return lootcontext$builder;
    }

    public static Set<ResourceKey<LootTable>> allBuiltin() {
        return TF_IMMUTABLE_LOCATIONS;
    }
}

