/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item.travellers_gear;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.armor.TFArmorModel;
import twilightforest.client.model.armor.TravellersWingsModel;
import twilightforest.client.renderer.armor.TFArmorRenderer;
import twilightforest.init.TFArmorMaterials;
import twilightforest.init.TFAttributeModifiers;
import twilightforest.init.TFDataAttachments;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFItems;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.modifiers.TooltipStringInterpolator;
import twilightforest.item.travellers_gear.modifiers.TravellersModifiable;
import twilightforest.item.travellers_gear.modifiers.TravellersModifier;

public class TravellersArmorItem
extends ArmorItem
implements TravellersModifiable {
    private static final MutableComponent GLOVES_TOOLTIP = Component.translatable((String)"item.twilightforest.travellers_gloves.desc").withStyle(ChatFormatting.GRAY);
    private final int insertableModifierSlots;
    @Nullable
    private ItemAttributeModifiers attributeModifiers;

    public TravellersArmorItem(ArmorItem.Type equipmentType, Item.Properties properties, int insertableModifierSlots) {
        super(TFArmorMaterials.TRAVELLERS, equipmentType, properties.component(TFDataComponents.IS_TRAVELLERS_GEAR, (Object)Unit.INSTANCE));
        this.insertableModifierSlots = insertableModifierSlots;
        this.attributeModifiers = (ItemAttributeModifiers)this.components().get(DataComponents.ATTRIBUTE_MODIFIERS);
        if (this.attributeModifiers == null) {
            return;
        }
        for (ItemAttributeModifiers.Entry modifier : this.getDefaultAttributeModifiers().modifiers()) {
            this.attributeModifiers = this.attributeModifiers.withModifierAdded(modifier.attribute(), modifier.modifier(), modifier.slot());
        }
    }

    public TravellersArmorItem(ArmorItem.Type equipmentType, Item.Properties properties, int insertableModifierSlots, int durability) {
        this(equipmentType, properties.durability(equipmentType.getDurability(durability)), insertableModifierSlots);
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        if (TravellersArmorItem.isTravellersArmorAndBroken(stack)) {
            return Component.translatable((String)this.getDescriptionId(stack)).append((Component)Component.translatable((String)"travellers_gear.broken").withStyle(ChatFormatting.GRAY));
        }
        return super.getName(stack);
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers == null ? super.getDefaultAttributeModifiers() : this.attributeModifiers;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return !innerModel && (Boolean)entity.getData(TFDataAttachments.IS_USING_GOGGLES_ZOOM_MODIFIER) != false ? TwilightForestMod.prefix("textures/models/armor/travellers_layer_1_down.png") : super.getArmorTexture(stack, entity, slot, layer, innerModel);
    }

    public static Item.Properties gogglesProperties(Item.Properties properties) {
        return properties.attributes(TravellersArmorItem.defaultArmorProperties(ArmorItem.Type.HELMET).build()).component(TFDataComponents.ZOOM_ABILITY_MODIFIER, (Object)Float.valueOf(0.3f));
    }

    public static Item.Properties chestProperties(Item.Properties properties) {
        return properties.component(TFDataComponents.TRAVELLERS_HAS_CHESTPLATE, (Object)Unit.INSTANCE).component(TFDataComponents.SWIFT_SWIM, (Object)Unit.INSTANCE).attributes(TravellersArmorItem.defaultArmorProperties(ArmorItem.Type.CHESTPLATE).add(Attributes.WATER_MOVEMENT_EFFICIENCY, TFAttributeModifiers.TRAVELLERS_SWIFT_SWIM, EquipmentSlotGroup.CHEST).build());
    }

    public static Item.Properties glovesProperties(Item.Properties properties) {
        return properties.component(TFDataComponents.TRAVELLERS_HAS_GLOVES, (Object)Unit.INSTANCE);
    }

    public static Item.Properties wingsProperties(Item.Properties properties) {
        return properties.attributes(TravellersArmorItem.defaultArmorProperties(ArmorItem.Type.LEGGINGS).build()).component(TFDataComponents.TRAVELLERS_HAS_WINGS, (Object)Unit.INSTANCE).component(TFDataComponents.HIGH_JUMP_AMPLIFIER, (Object)1);
    }

    public static Item.Properties bootsProperties(Item.Properties properties) {
        return properties.component(TFDataComponents.TRAVELLERS_HAS_BOOTS, (Object)Unit.INSTANCE).component(TFDataComponents.HIGH_STEP, (Object)Unit.INSTANCE).attributes(TravellersArmorItem.defaultArmorProperties(ArmorItem.Type.BOOTS).add(Attributes.STEP_HEIGHT, TFAttributeModifiers.TRAVELLERS_HIGH_STEP, EquipmentSlotGroup.FEET).build());
    }

    /*
     * WARNING - void declaration
     */
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        if (context.registries() != null) {
            ConcatenatedListView concatenatedListView;
            boolean bl;
            void var7_10;
            List<Holder.Reference<TravellersModifier>> abilityModifiers = TravellersModifiersManager.findAllAbilityModifiers(context.registries(), stack);
            for (Holder.Reference<TravellersModifier> reference : abilityModifiers) {
                tooltip.add((Component)Component.translatable((String)"travellers_gear.ability", (Object[])new Object[]{this.getModifierTooltipComponent(reference)}).withStyle(ChatFormatting.GOLD));
            }
            List<Holder.Reference<TravellersModifier>> insertableModifiers = TravellersModifiersManager.findAllInsertableModifiers(context.registries(), stack);
            for (Holder.Reference<TravellersModifier> reference : insertableModifiers) {
                tooltip.add((Component)Component.literal((String)"- ").append(this.getModifierTooltipComponent(reference)));
                if (!flags.hasShiftDown()) continue;
                for (Component description : ((TravellersModifier)reference.value()).getDescription()) {
                    tooltip.add((Component)Component.literal((String)"").append((Component)Component.translatable((String)"travellers_gear.info_indent").withStyle(ChatFormatting.BOLD)).append(description));
                }
            }
            int n = insertableModifiers.size();
            while (var7_10 < this.getModifierSlots()) {
                tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)"travellers_gear.modifier.empty").withStyle(ChatFormatting.DARK_GRAY)));
                ++var7_10;
            }
            if (TFItems.TRAVELLERS_GLOVES.get() == this) {
                tooltip.add((Component)GLOVES_TOOLTIP);
            }
            if (!flags.hasShiftDown() && (bl = (concatenatedListView = ConcatenatedListView.of((List[])new List[]{abilityModifiers, insertableModifiers})).stream().map(Holder::value).map(TravellersModifier::getDescription).anyMatch(Predicate.not(List::isEmpty)))) {
                tooltip.add((Component)Component.translatable((String)"travellers_gear.shift_info", (Object[])new Object[]{Component.literal((String)"Shift").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.WHITE));
            }
        }
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, @NotNull LivingEntity wearer) {
        return stack.is(TFItems.TRAVELLERS_BOOTS);
    }

    private Component getModifierTooltipComponent(Holder.Reference<TravellersModifier> modifier) {
        return TooltipStringInterpolator.render(modifier.getKey().location().toLanguageKey(((TravellersModifier)modifier.value()).getPrefix())).withStyle(ChatFormatting.GRAY);
    }

    public static boolean isTravellersArmorAndBroken(ItemStack stack) {
        return stack.has(TFDataComponents.IS_TRAVELLERS_GEAR) && stack.isDamageableItem() && stack.getMaxDamage() - 1 <= stack.getDamageValue();
    }

    public static ItemAttributeModifiers.Builder defaultArmorProperties(ArmorItem.Type type) {
        int defense = ((ArmorMaterial)TFArmorMaterials.TRAVELLERS.value()).getDefense(type);
        float toughness = ((ArmorMaterial)TFArmorMaterials.TRAVELLERS.value()).toughness();
        ItemAttributeModifiers.Builder defaultArmorModifiers = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        defaultArmorModifiers.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)defense, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        defaultArmorModifiers.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)toughness, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        float knockbackResistance = ((ArmorMaterial)TFArmorMaterials.TRAVELLERS.value()).knockbackResistance();
        if (knockbackResistance > 0.0f) {
            defaultArmorModifiers.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        return defaultArmorModifiers;
    }

    @Override
    public int getModifierSlots() {
        return this.insertableModifierSlots;
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return this == TFItems.TRAVELLERS_GOGGLES.get() || stack.has(TFDataComponents.TRAVELLERS_HAS_WINGS);
    }

    public static final class ArmorRender
    extends TFArmorRenderer {
        public ArmorRender() {
            super(TFModelLayers.TRAVELLERS_ARMOR_HELMET, TFModelLayers.TRAVELLERS_ARMOR_CHEST_GLOVES, TFModelLayers.TRAVELLERS_ARMOR_LEGGINGS, TFModelLayers.TRAVELLERS_ARMOR_BOOTS);
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(@NotNull LivingEntity living, @NotNull ItemStack stack, EquipmentSlot slot, @NotNull HumanoidModel<?> model) {
            ModelPart root = switch (slot) {
                case EquipmentSlot.HEAD -> this.getModelPart(TFModelLayers.TRAVELLERS_ARMOR_HELMET);
                case EquipmentSlot.CHEST -> {
                    ModelPart chestLayer = this.getModelPart(TFModelLayers.TRAVELLERS_ARMOR_CHEST_GLOVES);
                    chestLayer.getAllParts().forEach(part -> {
                        part.skipDraw = true;
                    });
                    boolean hasChestplate = stack.has(TFDataComponents.TRAVELLERS_HAS_CHESTPLATE);
                    boolean hasGloves = stack.has(TFDataComponents.TRAVELLERS_HAS_GLOVES);
                    chestLayer.getChild((String)"body").skipDraw = !hasChestplate;
                    chestLayer.getChild((String)"left_arm").skipDraw = !hasGloves;
                    chestLayer.getChild((String)"right_arm").skipDraw = !hasGloves;
                    yield chestLayer;
                }
                case EquipmentSlot.LEGS -> {
                    ModelPart leggingsLayer = this.getModelPart(TFModelLayers.TRAVELLERS_ARMOR_LEGGINGS);
                    leggingsLayer.getAllParts().forEach(part -> {
                        part.skipDraw = true;
                    });
                    boolean hasWings = stack.has(TFDataComponents.TRAVELLERS_HAS_WINGS);
                    boolean hasBelt = stack.has(TFDataComponents.TRAVELLERS_HAS_BELT) || TravellersModifiersManager.hasTravellersModifier((HolderLookup.Provider)living.registryAccess(), stack, TravellersModifiersManager.SWAP_HOTBAR_MODIFIER);
                    TravellersWingsModel.skipBelt(leggingsLayer, !hasBelt);
                    TravellersWingsModel.skipWings(leggingsLayer, !hasWings);
                    yield leggingsLayer;
                }
                case EquipmentSlot.FEET -> this.getModelPart(TFModelLayers.TRAVELLERS_ARMOR_BOOTS);
                default -> throw new IllegalArgumentException("Unexpected slot: " + String.valueOf(slot) + ": " + String.valueOf(stack) + ". Please report to https://github.com/TeamTwilight/twilightforest/issues");
            };
            if (slot == EquipmentSlot.LEGS) {
                return new TravellersWingsModel(root);
            }
            return new TFArmorModel(root);
        }

        public void setupModelAnimations(@NotNull LivingEntity livingEntity, @NotNull ItemStack itemStack, @NotNull EquipmentSlot equipmentSlot, @NotNull Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (model instanceof TravellersWingsModel) {
                TravellersWingsModel wingsModel = (TravellersWingsModel)model;
                wingsModel.setupModelAnimations(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }
}

