/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum NagastoneVariant implements StringRepresentable
{
    NORTH_DOWN,
    SOUTH_DOWN,
    WEST_DOWN,
    EAST_DOWN,
    NORTH_UP,
    SOUTH_UP,
    EAST_UP,
    WEST_UP,
    AXIS_X,
    AXIS_Y,
    AXIS_Z,
    SOLID;


    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static NagastoneVariant getVariantFromAxis(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> AXIS_X;
            case Direction.Axis.Y -> AXIS_Y;
            case Direction.Axis.Z -> AXIS_Z;
        };
    }

    public static NagastoneVariant getVariantFromDoubleFacing(Direction facing1, Direction facing2) {
        Direction otherFace;
        if (facing1.getAxis() == facing2.getAxis()) {
            return NagastoneVariant.getVariantFromAxis(facing1.getAxis());
        }
        if (facing1.getAxis() != Direction.Axis.Y && facing2.getAxis() != Direction.Axis.Y) {
            return SOLID;
        }
        Direction facingYAxis = facing1.getAxis() == Direction.Axis.Y ? facing1 : facing2;
        Direction direction = otherFace = facing1.getAxis() != Direction.Axis.Y ? facing1 : facing2;
        if (facingYAxis == Direction.UP) {
            return switch (otherFace) {
                case Direction.NORTH -> NORTH_UP;
                case Direction.SOUTH -> SOUTH_UP;
                case Direction.WEST -> WEST_UP;
                case Direction.EAST -> EAST_UP;
                default -> SOLID;
            };
        }
        return switch (otherFace) {
            case Direction.NORTH -> NORTH_DOWN;
            case Direction.SOUTH -> SOUTH_DOWN;
            case Direction.WEST -> WEST_DOWN;
            case Direction.EAST -> EAST_DOWN;
            default -> SOLID;
        };
    }
}

