/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.projectile.ThrownBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class Troll
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ROCK_FLAG = SynchedEntityData.defineId(Troll.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final AttributeModifier ROCK_MODIFIER = new AttributeModifier(TwilightForestMod.prefix("rock_follow_boost"), 8.0, AttributeModifier.Operation.ADD_VALUE);
    private RangedAttackGoal aiArrowAttack;
    private MeleeAttackGoal aiAttackOnCollide;
    private int rockCooldown = 300 + this.getRandom().nextInt(100);
    @Nullable
    private BlockState rock;

    public Troll(EntityType<? extends Troll> type, Level level) {
        super(type, level);
    }

    public void registerGoals() {
        this.aiArrowAttack = new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 60, 15.0f);
        this.aiAttackOnCollide = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Troll.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (!this.level().isClientSide()) {
            this.setCombatTask();
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 7.0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && !this.hasRock() && this.getTarget() != null) {
            if (this.rockCooldown > 0) {
                --this.rockCooldown;
            } else {
                RandomSource random = this.getRandom();
                Level level = this.level();
                int i = Mth.floor((double)(this.getX() - 2.0 + random.nextDouble() * 4.0));
                int j = Mth.floor((double)(this.getY() + random.nextDouble() * 3.0));
                int k = Mth.floor((double)(this.getZ() - 2.0 + random.nextDouble() * 4.0));
                BlockPos blockpos = new BlockPos(i, j, k);
                BlockState blockstate = level.getBlockState(blockpos);
                Vec3 vec3 = new Vec3((double)this.getBlockX() + 0.5, (double)j + 0.5, (double)this.getBlockZ() + 0.5);
                Vec3 vec31 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                BlockHitResult blockhitresult = level.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
                boolean flag = blockhitresult.getBlockPos().equals((Object)blockpos);
                if (blockstate.is(BlockTags.BASE_STONE_OVERWORLD) && flag) {
                    this.rock = level.getBlockState(blockpos);
                    level.removeBlock(blockpos, false);
                    level.gameEvent((Entity)this, (Holder)GameEvent.BLOCK_DESTROY, blockpos);
                }
                if (this.rock != null) {
                    this.setHasRock(true);
                    this.playSound((SoundEvent)TFSounds.TROLL_GRABS_ROCK.get());
                    ThrownBlock block = new ThrownBlock(level, (LivingEntity)this, this.rock);
                    block.startRiding((Entity)this);
                    level.addFreshEntity((Entity)block);
                }
            }
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float yRot) {
        return new Vec3(0.0, (double)(dimensions.height() * 1.25f), 0.0);
    }

    public void positionRider(Entity entity, Entity.MoveFunction callback) {
        super.positionRider(entity, callback);
        entity.setYRot(this.yBodyRot);
        entity.yRotO = this.yBodyRotO;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROCK_FLAG, (Object)false);
    }

    public boolean hasRock() {
        return (Boolean)this.getEntityData().get(ROCK_FLAG);
    }

    public void setHasRock(boolean rock) {
        this.getEntityData().set(ROCK_FLAG, (Object)rock);
        if (!this.level().isClientSide()) {
            if (rock) {
                if (!Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE)).hasModifier(ROCK_MODIFIER.id())) {
                    Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE)).addTransientModifier(ROCK_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.getAttribute(Attributes.FOLLOW_RANGE)).removeModifier(ROCK_MODIFIER.id());
            }
            this.setCombatTask();
        }
    }

    public boolean doHurtTarget(Entity entity) {
        return super.doHurtTarget(entity);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasRock", this.hasRock());
        compound.putInt("RockCooldown", this.rockCooldown);
        if (this.rock != null) {
            compound.put("RockState", (Tag)NbtUtils.writeBlockState((BlockState)this.rock));
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHasRock(compound.getBoolean("HasRock"));
        this.rockCooldown = compound.getInt("RockCooldown");
        this.rock = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("RockState"));
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.aiAttackOnCollide);
        this.goalSelector.removeGoal((Goal)this.aiArrowAttack);
        if (this.hasRock()) {
            this.goalSelector.addGoal(4, (Goal)this.aiArrowAttack);
        } else {
            this.goalSelector.addGoal(4, (Goal)this.aiAttackOnCollide);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.TROLL_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.TROLL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.TROLL_DEATH.get();
    }

    protected void tickDeath() {
        super.tickDeath();
        if (this.deathTime % 5 == 0) {
            this.ripenTrollBerNearby(this.deathTime / 5);
        }
    }

    private void ripenTrollBerNearby(int offset) {
        int range = 12;
        for (BlockPos pos : WorldUtil.getAllAround(new BlockPos((Vec3i)this.blockPosition()), range)) {
            this.ripenBer(offset, pos);
        }
    }

    private void ripenBer(int offset, BlockPos pos) {
        if (this.level().getBlockState(pos).getBlock() == TFBlocks.UNRIPE_TROLLBER.get() && this.getRandom().nextBoolean() && Math.abs(pos.getX() + pos.getY() + pos.getZ()) % 5 == offset) {
            this.level().setBlockAndUpdate(pos, ((Block)TFBlocks.TROLLBER.get()).defaultBlockState());
            this.level().levelEvent(2004, pos, 0);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.hasRock()) {
            ThrownBlock blocc = new ThrownBlock(this.level(), (LivingEntity)this, this.rock);
            double d0 = target.getX() - this.getX();
            double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() / 3.0f) - blocc.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            blocc.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 4 - this.level().getDifficulty().getId());
            this.playSound((SoundEvent)TFSounds.TROLL_THROWS_ROCK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
            this.level().addFreshEntity((Entity)blocc);
            this.setHasRock(false);
            if (!this.getPassengers().isEmpty() && Objects.requireNonNull(this.getFirstPassenger()).getType() == TFEntities.THROWN_BLOCK.get()) {
                this.getFirstPassenger().discard();
            }
            this.rockCooldown = 300 + this.getRandom().nextInt(100);
            this.rock = null;
        }
    }
}

