/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import twilightforest.entity.ITFCharger;
import twilightforest.entity.projectile.NatureBolt;

public class Adherent
extends Monster
implements RangedAttackMob,
ITFCharger {
    private static final EntityDataAccessor<Boolean> CHARGE_FLAG = SynchedEntityData.defineId(Adherent.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Adherent(EntityType<? extends Adherent> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARGE_FLAG, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void performRangedAttack(LivingEntity attackTarget, float extraDamage) {
        NatureBolt natureBolt = new NatureBolt(this.level(), (LivingEntity)this);
        this.playSound(SoundEvents.GHAST_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        double d0 = attackTarget.getY() + (double)attackTarget.getEyeHeight() - (double)1.1f;
        double d1 = attackTarget.getX() - this.getX();
        double d2 = d0 - natureBolt.getY();
        double d3 = attackTarget.getZ() - this.getZ();
        float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
        natureBolt.shoot(d1, d2 + (double)f, d3, 0.6f, 10 - this.level().getDifficulty().getId() * 4);
        this.level().addFreshEntity((Entity)natureBolt);
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    @Override
    public boolean isCharging() {
        return (Boolean)this.getEntityData().get(CHARGE_FLAG);
    }

    @Override
    public void setCharging(boolean flag) {
        this.getEntityData().set(CHARGE_FLAG, (Object)flag);
    }
}

