/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.Hydra;

public abstract class HydraPart
extends TFPart<Hydra> {
    private static final EntityDataAccessor<Boolean> DATA_SIZEACTIVE = SynchedEntityData.defineId(HydraPart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    boolean markedDead;
    private EntityDimensions cacheSize;

    public HydraPart(Hydra parent, float width, float height) {
        super(parent);
        this.setSize(EntityDimensions.scalable((float)width, (float)height));
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SIZEACTIVE, (Object)true);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (accessor == DATA_SIZEACTIVE) {
            this.setSize(this.getDimensions(Pose.STANDING));
            if (this.isActive()) {
                this.markedDead = false;
                this.deathTime = 0;
            }
        }
    }

    public boolean canEntityBeSeen(Entity entity) {
        Vec3 vector3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vector3d1 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        return this.level().clip(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    @Override
    protected void setSize(EntityDimensions size) {
        super.setSize(size);
        this.cacheSize = size;
    }

    @Override
    public void tick() {
        this.clearFire();
        super.tick();
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.markedDead) {
            ++this.deathTime;
        }
        if (this.markedDead && this.isActive() && this.level().isClientSide()) {
            float width = this.getBbWidth();
            float height = this.getBbHeight();
            for (int k = 0; k < 10; ++k) {
                this.level().addParticle((ParticleOptions)(this.random.nextInt(5) == 0 ? ParticleTypes.EXPLOSION : ParticleTypes.POOF), this.getX() + (double)(this.random.nextFloat() * width), this.getY() + (double)(this.random.nextFloat() * height), this.getZ() + (double)(this.random.nextFloat() * width), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
            }
        }
        if (this.deathTime == 20) {
            this.deactivate();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean flag;
        boolean bl = flag = this.getParent() != null && ((Hydra)this.getParent()).attackEntityFromPart(this, source, amount);
        if (flag) {
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE);
        }
        return flag;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean is(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    protected void setRot(float yaw, float pitch) {
        this.setYRot(yaw % 360.0f);
        this.setXRot(pitch % 360.0f);
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean canUsePortal(boolean force) {
        return false;
    }

    public boolean isActive() {
        return (Boolean)this.getEntityData().get(DATA_SIZEACTIVE);
    }

    public void activate() {
        this.dimensions = this.cacheSize;
        this.getEntityData().set(DATA_SIZEACTIVE, (Object)true);
    }

    public void deactivate() {
        this.dimensions = EntityDimensions.scalable((float)0.0f, (float)0.0f);
        this.getEntityData().set(DATA_SIZEACTIVE, (Object)false);
    }
}

