/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CharmEffect
extends Entity
implements ItemSupplier {
    private static final double DISTANCE = 0.75;
    private double interpTargetX;
    private double interpTargetY;
    private double interpTargetZ;
    private double interpTargetYaw;
    private double interpTargetPitch;
    private int newPosRotationIncrements;
    public float offset;
    @Nullable
    private LivingEntity orbiter;
    private ItemStack displayItem = new ItemStack((ItemLike)Items.BARRIER);

    public CharmEffect(EntityType<? extends CharmEffect> type, Level level) {
        super(type, level);
    }

    public CharmEffect(EntityType<? extends CharmEffect> type, Level level, LivingEntity owner, ItemStack item) {
        this(type, level);
        this.orbiter = owner;
        this.displayItem = item;
        this.moveTo(owner.getX(), owner.getY() + (double)owner.getEyeHeight(), owner.getZ(), owner.getYRot(), owner.getXRot());
        Vec3 look = new Vec3(0.75, 0.0, 0.0);
        double x = this.getX() + look.x() * 0.75;
        double z = this.getZ() + look.z() * 0.75;
        this.setPos(x, this.getY(), z);
    }

    public void tick() {
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        super.tick();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.getX() + (this.interpTargetX - this.getX()) / (double)this.newPosRotationIncrements;
            double d1 = this.getY() + (this.interpTargetY - this.getY()) / (double)this.newPosRotationIncrements;
            double d2 = this.getZ() + (this.interpTargetZ - this.getZ()) / (double)this.newPosRotationIncrements;
            double d3 = Mth.wrapDegrees((double)(this.interpTargetYaw - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d3 / (double)this.newPosRotationIncrements));
            this.setXRot((float)((double)this.getXRot() + (this.interpTargetPitch - (double)this.getXRot()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.setPos(d0, d1, d2);
            this.setRot(this.getYRot(), this.getXRot());
        }
        if (this.orbiter != null) {
            float rotation = (float)this.tickCount / 10.0f + this.offset;
            Vec3 look = new Vec3(0.75, 0.0, 0.0).yRot(rotation);
            this.moveTo(this.orbiter.getX() + look.x(), this.orbiter.getY() + (double)this.orbiter.getEyeHeight(), this.orbiter.getZ() + look.z(), this.orbiter.getYRot(), this.orbiter.getXRot());
        }
        if (!this.displayItem.isEmpty()) {
            double dx = this.getX() + 0.25 * (this.random.nextDouble() - this.random.nextDouble());
            double dy = this.getY() + 0.25 * (this.random.nextDouble() - this.random.nextDouble());
            double dz = this.getZ() + 0.25 * (this.random.nextDouble() - this.random.nextDouble());
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.displayItem), dx, dy, dz, 0.0, 0.2, 0.0);
        }
        if (this.tickCount > 200 || this.orbiter != null && (!this.orbiter.isAlive() || this.orbiter.isInvisible())) {
            this.discard();
        }
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag cmp) {
    }

    protected void addAdditionalSaveData(CompoundTag cmp) {
    }

    @Nonnull
    public ItemStack getItem() {
        return this.displayItem;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0 * CharmEffect.getViewScale();
        return distance < d0 * d0;
    }
}

