/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.structuredefinitions;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import twilightforest.beanification.Autowired;
import twilightforest.data.custom.structuredefinitions.StructureTemplateDefinitionProvider;
import twilightforest.init.TFBlocks;
import twilightforest.init.custom.TemplateMarkerHandlers;
import twilightforest.world.components.processors.StateTransfiguringProcessor;
import twilightforest.world.components.structures.camp.CampPieces;
import twilightforest.world.components.structures.util.TemplateMarkerHandlerList;
import twilightforest.world.components.structures.util.TemplatePoolInstance;

public class CampStructureDefinitionGenerator
extends StructureTemplateDefinitionProvider {
    @Autowired
    private static CampPieces campPieces;

    public CampStructureDefinitionGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "twilightforest", existingFileHelper, "Camp");
    }

    @Override
    protected void generatePools() {
        this.lookupProvider.thenAccept(this::generatePoolsWithProvider);
    }

    private void generatePoolsWithProvider(HolderLookup.Provider provider) {
        Holder.Reference<TemplateMarkerHandlerList> campMarkers = this.getMarkers(provider, TemplateMarkerHandlers.CAMP_MARKER_HANDLERS);
        this.add("camp/campfire_east", CampStructureDefinitionGenerator.campPieces.start, this.weightedRigidTemplate(100, 1, null, (Holder<TemplateMarkerHandlerList>)campMarkers, null, null));
        this.add("camp/campfire_south", CampStructureDefinitionGenerator.campPieces.start, this.weightedRigidTemplate(100, 1, null, (Holder<TemplateMarkerHandlerList>)campMarkers, null, null));
        this.add("camp/campfire_west", CampStructureDefinitionGenerator.campPieces.start, this.weightedRigidTemplate(100, 1, null, (Holder<TemplateMarkerHandlerList>)campMarkers, null, null));
        this.configureTents(provider);
        this.configureRackPaths();
        this.configureBigPaths();
        this.configureSmallPaths();
        this.configureDeco(campMarkers);
    }

    private void configureTents(HolderLookup.Provider provider) {
        Holder.Reference<TemplateMarkerHandlerList> campMarkers = this.getMarkers(provider, TemplateMarkerHandlers.CAMP_MARKER_HANDLERS);
        int defaultWeight = 10;
        TemplatePoolInstance.ChooseRandomProcessors randomizedProcessors = new TemplatePoolInstance.ChooseRandomProcessors(List.of(SimpleWeightedRandomList.builder().add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.WHITE_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.LIGHT_GRAY_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.GRAY_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.BROWN_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.GREEN_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.BLUE_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.RED_WOOL.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.LIGHT_GRAY_WOOL), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.LIME_WOOL.defaultBlockState()))), 1).build(), SimpleWeightedRandomList.builder().add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.RED_BED), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.RED_BED.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.RED_BED), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.LIGHT_BLUE_BED.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.RED_BED), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.LIME_BED.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.RED_BED), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.ORANGE_BED.defaultBlockState()))), defaultWeight).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(Blocks.RED_BED), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.LIGHT_GRAY_BED.defaultBlockState()))), defaultWeight).build()));
        this.add("camp/tent/solo_tent", CampStructureDefinitionGenerator.campPieces.tent, this.weightedRigidTemplate(100, 1, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, randomizedProcessors, null));
        this.add("camp/tent/duo_tent", CampStructureDefinitionGenerator.campPieces.tent, this.weightedRigidTemplate(75, 1, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, randomizedProcessors, null));
        this.add("camp/tent/open_tent", CampStructureDefinitionGenerator.campPieces.tent, this.weightedRigidTemplate(75, 1, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, randomizedProcessors, null));
        this.add("camp/tent/luxury_tent", CampStructureDefinitionGenerator.campPieces.tent, this.weightedRigidTemplate(50, 1, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, randomizedProcessors, null));
    }

    private void configureRackPaths() {
        TemplatePoolInstance pathTemplateData = this.weightedPathTemplate(100, null, Map.of(CampStructureDefinitionGenerator.campPieces.deco.toString(), CampStructureDefinitionGenerator.campPieces.rack.toString()));
        this.add("camp/path/path_2x4", CampStructureDefinitionGenerator.campPieces.rackPath, pathTemplateData);
        this.add("camp/path/path_3x4", CampStructureDefinitionGenerator.campPieces.rackPath, pathTemplateData);
    }

    private void configureBigPaths() {
        TemplatePoolInstance pathTemplateData = this.weightedPathTemplate(25, null, null);
        this.addEmpty(CampStructureDefinitionGenerator.campPieces.mainPath, 300);
        this.add("camp/path/intersection_left", CampStructureDefinitionGenerator.campPieces.mainPath, pathTemplateData);
        this.add("camp/path/intersection_right", CampStructureDefinitionGenerator.campPieces.mainPath, pathTemplateData);
        this.add("camp/path/intersection_short", CampStructureDefinitionGenerator.campPieces.mainPath, pathTemplateData);
        this.add("camp/path/j_path", CampStructureDefinitionGenerator.campPieces.mainPath, pathTemplateData);
        this.add("camp/path/l_path", CampStructureDefinitionGenerator.campPieces.mainPath, pathTemplateData);
    }

    private void configureSmallPaths() {
        TemplatePoolInstance pathTemplateData = this.weightedPathTemplate(50, null, null);
        this.addEmpty(CampStructureDefinitionGenerator.campPieces.path, 300);
        this.addToAllPools("camp/path/path_2x4", pathTemplateData, CampStructureDefinitionGenerator.campPieces.mainPath, CampStructureDefinitionGenerator.campPieces.path);
        this.addToAllPools("camp/path/path_2x6", pathTemplateData, CampStructureDefinitionGenerator.campPieces.mainPath, CampStructureDefinitionGenerator.campPieces.path);
        this.addToAllPools("camp/path/path_2x7", pathTemplateData, CampStructureDefinitionGenerator.campPieces.mainPath, CampStructureDefinitionGenerator.campPieces.path);
        this.addToAllPools("camp/path/path_3x4", pathTemplateData, CampStructureDefinitionGenerator.campPieces.mainPath, CampStructureDefinitionGenerator.campPieces.path);
    }

    private void configureDeco(Holder.Reference<TemplateMarkerHandlerList> campMarkers) {
        TemplatePoolInstance twoLayerTemplateData = this.weightedRigidTemplate(100, 2, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, null, null);
        TemplatePoolInstance berryTemplateData = this.weightedRigidTemplate(75, 2, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, null, null);
        this.addToAllPools("camp/deco/double_drying_rack", twoLayerTemplateData, CampStructureDefinitionGenerator.campPieces.deco, CampStructureDefinitionGenerator.campPieces.rack);
        this.addToAllPools("camp/deco/long_drying_rack", twoLayerTemplateData, CampStructureDefinitionGenerator.campPieces.deco, CampStructureDefinitionGenerator.campPieces.rack);
        this.add("camp/deco/garden_1x3", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/garden_2x4", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/garden_straight", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/garden_u", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/berries_staked", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/berries_trellis", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/blackberry_wall", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/blueberry_wall", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/raspberry_wall", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/berries_support", CampStructureDefinitionGenerator.campPieces.deco, berryTemplateData);
        this.add("camp/deco/compost_large", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/compost_small", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/repair_station", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        this.add("camp/deco/pen", CampStructureDefinitionGenerator.campPieces.deco, twoLayerTemplateData);
        TemplatePoolInstance.ChooseRandomProcessors randomizedWoods = new TemplatePoolInstance.ChooseRandomProcessors(List.of(SimpleWeightedRandomList.builder().add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)TFBlocks.TWILIGHT_OAK_LOG.value()), (RuleTest)AlwaysTrueTest.INSTANCE, ((RotatedPillarBlock)TFBlocks.TWILIGHT_OAK_LOG.value()).defaultBlockState()))), 100).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)TFBlocks.TWILIGHT_OAK_LOG.value()), (RuleTest)AlwaysTrueTest.INSTANCE, ((RotatedPillarBlock)TFBlocks.CANOPY_LOG.value()).defaultBlockState()))), 90).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)TFBlocks.TWILIGHT_OAK_LOG.value()), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.OAK_LOG.defaultBlockState()))), 80).add((Object)new StateTransfiguringProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest((Block)TFBlocks.TWILIGHT_OAK_LOG.value()), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.BIRCH_LOG.defaultBlockState()))), 70).build()));
        TemplatePoolInstance lumberTemplateData = this.weightedRigidTemplate(100, 1, 0, (Holder<TemplateMarkerHandlerList>)campMarkers, randomizedWoods, null);
        this.add("camp/deco/lumber1", CampStructureDefinitionGenerator.campPieces.deco, lumberTemplateData);
        this.add("camp/deco/lumber2", CampStructureDefinitionGenerator.campPieces.deco, lumberTemplateData);
        this.add("camp/deco/lumber3", CampStructureDefinitionGenerator.campPieces.deco, lumberTemplateData);
        this.addEmpty(CampStructureDefinitionGenerator.campPieces.deco, 1000);
    }
}

