/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import twilightforest.TwilightForestMod;
import twilightforest.data.StonecuttingGenerator;
import twilightforest.data.custom.CartesianShapedRecipeBuilder;
import twilightforest.data.custom.CartesianShapelessRecipeBuilder;
import twilightforest.data.custom.DryingRecipeBuilder;
import twilightforest.data.custom.NoSmithingTemplateRecipeBuilder;
import twilightforest.data.custom.ScepterRecipeBuilder;
import twilightforest.data.custom.TravellersGearComponentModifierBuilder;
import twilightforest.data.custom.UncraftingGenerator;
import twilightforest.data.helpers.CraftingDataHelper;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFItems;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.recipe.CasketRepairRecipe;
import twilightforest.item.recipe.EmperorsClothRecipe;
import twilightforest.item.recipe.EssenceRepairRecipe;
import twilightforest.item.recipe.MagicMapCloningRecipe;
import twilightforest.item.recipe.MazeMapCloningRecipe;
import twilightforest.item.recipe.MoonwormQueenRepairRecipe;
import twilightforest.item.recipe.UncraftingTableCondition;
import twilightforest.item.recipe.travellers.TravellersVestGlovesMergeRecipe;

public class CraftingGenerator
extends CraftingDataHelper {
    private static final String[] CORAL_SPECIES = new String[]{"tube", "brain", "bubble", "fire", "horn"};
    private static final String[] CORAL_TYPES = new String[]{"", "_block", "_fan"};
    private final HolderLookup.Provider provider;

    public CraftingGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
        this.provider = provider.join();
    }

    protected void buildRecipes(RecipeOutput output) {
        StonecuttingGenerator.buildRecipes(output);
        UncraftingGenerator.buildRecipes(output);
        this.blockCompressionRecipes(output);
        this.equipmentRecipes(this.provider, output);
        this.emptyMapRecipes(output);
        this.woodRecipes(output);
        this.fieryConversions(output);
        this.nagastoneRecipes(output);
        this.darkTowerRecipes(output);
        this.castleRecipes(output);
        this.bannerPattern(output, "naga_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.NAGA_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.NAGA_BANNER_PATTERN);
        this.bannerPattern(output, "lich_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.LICH_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.LICH_BANNER_PATTERN);
        this.bannerPattern(output, "minoshroom_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.MINOSHROOM_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.MINOSHROOM_BANNER_PATTERN);
        this.bannerPattern(output, "hydra_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.HYDRA_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.HYDRA_BANNER_PATTERN);
        this.bannerPattern(output, "knight_phantom_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.KNIGHT_PHANTOM_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHT_PHANTOM_BANNER_PATTERN);
        this.bannerPattern(output, "ur_ghast_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.UR_GHAST_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.UR_GHAST_BANNER_PATTERN);
        this.bannerPattern(output, "alpha_yeti_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.ALPHA_YETI_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.ALPHA_YETI_BANNER_PATTERN);
        this.bannerPattern(output, "snow_queen_banner_pattern", (DeferredBlock<? extends Block>)TFBlocks.SNOW_QUEEN_TROPHY, (DeferredHolder<Item, ? extends Item>)TFItems.SNOW_QUEEN_BANNER_PATTERN);
        this.slabBlock(output, "aurora_slab", TFBlocks.AURORA_SLAB, TFBlocks.AURORA_BLOCK);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.AURORA_PILLAR.get()), (int)2).pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.AURORA_BLOCK.get()})).unlockedBy("has_slab", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.AURORA_SLAB.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.IRON_LADDER.get()), (int)3).pattern("-#-").pattern("-#-").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.IRON_BARS})).define(Character.valueOf('-'), Tags.Items.NUGGETS_IRON).unlockedBy("has_iron_bars", CraftingGenerator.has((ItemLike)Blocks.IRON_BARS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.WROUGHT_IRON_FENCE.get()), (int)3).pattern("###").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.WROUGHT_IRON_INGOTS).unlockedBy("has_wrought_iron", CraftingGenerator.has(ItemTagGenerator.WROUGHT_IRON_INGOTS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANDELABRA.get()), (int)2).pattern("###").pattern(" # ").define(Character.valueOf('#'), ItemTagGenerator.WROUGHT_IRON_INGOTS).unlockedBy("has_wrought_iron", CraftingGenerator.has(ItemTagGenerator.WROUGHT_IRON_INGOTS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.ROPE.get()), (int)8).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ROOT_STRAND.get()})).unlockedBy("has_root_strand", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ROOT_STRAND.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW.get()), (int)4).pattern("GPG").pattern("PPP").pattern("GPG").define(Character.valueOf('G'), Ingredient.of((TagKey)Tags.Items.GLASS_BLOCKS)).define(Character.valueOf('P'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CANOPY_PLANKS.value()})).unlockedBy("has_planks", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_PLANKS.value()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW_PANE.get()), (int)16).pattern("GGG").pattern("GGG").define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CANOPY_WINDOW.value()})).unlockedBy("has_windows", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_WINDOW.value()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFItems.MASON_JAR.get()), (int)4).pattern("GLG").pattern("G G").pattern("GGG").define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{Items.GLASS})).define(Character.valueOf('L'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TWILIGHT_OAK_LOG.get()})).unlockedBy("has_tf_oak", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TWILIGHT_OAK_LOG.value()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.FIREFLY_JAR.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MASON_JAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIREFLY.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.FIREFLY_SPAWNER.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY_JAR.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIREFLY.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.POPPY})).unlockedBy("has_jar", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIREFLY_JAR.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.CICADA_JAR.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CICADA.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MASON_JAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CICADA.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.MAGENTA_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.HUGE_WATER_LILY.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.HUGE_WATER_LILY.get()))).save(output, TwilightForestMod.prefix("waterlily_to_magenta"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.RED_DYE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.THORN_ROSE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.THORN_ROSE.get()))).save(output, TwilightForestMod.prefix("thorn_rose_to_red"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ROOT_STRAND.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ROOT_STRAND.get()))).group("sticks").save(output, TwilightForestMod.prefix("root_stick"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.TORCH, (int)5).pattern("\u2234").pattern("|").define(Character.valueOf('\u2234'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.TORCHBERRIES.get()})).define(Character.valueOf('|'), Tags.Items.RODS_WOODEN).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.TORCHBERRIES.get()))).save(output, TwilightForestMod.prefix("berry_torch"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TFBlocks.UNCRAFTING_TABLE.get())).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)Blocks.CRAFTING_TABLE).define(Character.valueOf('X'), (ItemLike)TFItems.MAZE_MAP_FOCUS.get()).unlockedBy("has_uncrafting_table", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNCRAFTING_TABLE.get()))).save(output.withConditions(new ICondition[]{UncraftingTableCondition.INSTANCE}), TwilightForestMod.prefix("uncrafting_table"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, TFItems.MOSS_SOUP).requires(TFBlocks.MOSS_PATCH).requires((ItemLike)Items.BOWL).requires(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER)})).unlockedBy("has_moss", CraftingGenerator.has(TFBlocks.MOSS_PATCH)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, TFItems.BERRY_MEDLEY).requires((ItemLike)Items.BOWL).requires(TFItems.RASPBERRY).requires(TFItems.BLUEBERRY).requires(TFItems.BLACKBERRY).requires(TFItems.MALOBERRY).unlockedBy("has_raspberry", CraftingGenerator.has(TFItems.RASPBERRY)).unlockedBy("has_blueberry", CraftingGenerator.has(TFItems.BLUEBERRY)).unlockedBy("has_blackberry", CraftingGenerator.has(TFItems.BLACKBERRY)).unlockedBy("has_maloberry", CraftingGenerator.has(TFItems.MALOBERRY)).save(output);
        this.cookingRecipes(output, "smelted", RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, 200);
        this.cookingRecipes(output, "smoked", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
        this.cookingRecipes(output, "campfired", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
        this.ingotRecipes(output, "smelted", RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, 200);
        this.ingotRecipes(output, "blasted", RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, 100);
        this.oreberryRecipes(output, "smelted", RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, 200);
        this.oreberryRecipes(output, "blasted", RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, 100);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COPPER_INGOT).requires(Ingredient.of(ItemTagGenerator.COPPER_NUGGETS), 9).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.COPPER_NUGGETS)).save(output, TwilightForestMod.prefix("copper_nuggets_to_ingot"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, TFItems.COPPER_NUGGET, (int)9).requires(Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER)).unlockedBy("has_item", CraftingGenerator.has((TagKey<Item>)Tags.Items.INGOTS_COPPER)).save(output, TwilightForestMod.prefix("copper_ingot_to_nuggets"));
        this.crackedWoodRecipes(output);
        this.crackedStoneRecipes(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CANOPY_BOOKSHELF.get())).pattern("---").pattern("B B").pattern("---").define(Character.valueOf('-'), (ItemLike)TFBlocks.CANOPY_PLANKS.get()).define(Character.valueOf('B'), (ItemLike)Items.BOOK).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CANOPY_PLANKS.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.ARMOR_SHARD.get()}), 9).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.ARMOR_SHARD.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.ARMOR_SHARD_CLUSTER.getId().getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_UNDERBRICK.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.UNDERBRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNDERBRICK.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_MAZESTONE.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.MAZESTONE_BRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.MAZESTONE_BRICK.get()))).save(output, TwilightForestMod.prefix("maze_stone/mossy_mazestone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.CARMINITE.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).requires(Tags.Items.DUSTS_REDSTONE).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.BORER_ESSENCE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.BORER_ESSENCE.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.CARMINITE.getId().getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.RAW_IRONWOOD.get()), (int)2).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.LIVEROOT.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_IRON})).requires(Tags.Items.NUGGETS_GOLD).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.LIVEROOT.get()))).save(output, TwilightForestMod.prefix("material/" + TFItems.RAW_IRONWOOD.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.RAINY_CLOUD.get()), (int)8).pattern("ccc").pattern("cbc").pattern("ccc").define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FLUFFY_CLOUD.get()})).define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FLUFFY_CLOUD.get()))).save(output, TwilightForestMod.prefix("rainy_cloud"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.SNOWY_CLOUD.get()), (int)8).pattern("ccc").pattern("cbc").pattern("ccc").define(Character.valueOf('c'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FLUFFY_CLOUD.get()})).define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.POWDER_SNOW_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FLUFFY_CLOUD.get()))).save(output, TwilightForestMod.prefix("snowy_cloud"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.MYSTIC_CROWN, (int)1).pattern("ttt").pattern("t t").pattern("ttt").define(Character.valueOf('t'), Ingredient.of((ItemLike[])new ItemLike[]{TFItems.CROWN_SPLINTER})).unlockedBy("has_item", CraftingGenerator.has(TFItems.CROWN_SPLINTER)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.LEAD, (int)2).define(Character.valueOf('~'), (ItemLike)Items.STRING).define(Character.valueOf('O'), TFItems.MAZE_SLIME_BALL).pattern("~~ ").pattern("~O ").pattern("  ~").unlockedBy("has_slime_ball", CraftingGenerator.has(TFItems.MAZE_SLIME_BALL)).save(output, TwilightForestMod.prefix("lead_maze_ver"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BREWING, (ItemLike)Items.MAGMA_CREAM).requires((ItemLike)Items.BLAZE_POWDER).requires(TFItems.MAZE_SLIME_BALL).unlockedBy("has_blaze_powder", CraftingGenerator.has((ItemLike)Items.BLAZE_POWDER)).save(output, TwilightForestMod.prefix("magma_cream_maze_ver"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.STICKY_PISTON).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).define(Character.valueOf('S'), TFItems.MAZE_SLIME_BALL).pattern("S").pattern("P").unlockedBy("has_slime_ball", CraftingGenerator.has(TFItems.MAZE_SLIME_BALL)).save(output, TwilightForestMod.prefix("sticky_piston_maze_ver"));
    }

    private void darkTowerRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.ENCASED_FIRE_JET.get())).pattern("#\u2234#").pattern("\u2234^\u2234").pattern("uuu").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('^'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.FIRE_JET.get()})).define(Character.valueOf('u'), Ingredient.of((ItemLike[])new ItemLike[]{Items.LAVA_BUCKET})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.FIRE_JET.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.ENCASED_SMOKER.get())).pattern("#\u2234#").pattern("\u2234^\u2234").pattern("#\u2234#").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('^'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.SMOKER.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.SMOKER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.CARMINITE_BUILDER.get())).pattern("#6#").pattern("6o6").pattern("#6#").define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('o'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DISPENSER})).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.CARMINITE_GEMS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.CARMINITE_REACTOR.get())).pattern("#6#").pattern("6%6").pattern("#6#").define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('%'), Tags.Items.ORES_REDSTONE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.CARMINITE_GEMS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()), (int)2).pattern("#\u2234#").pattern("\u22346\u2234").pattern("#\u2234#").define(Character.valueOf('\u2234'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)TFBlocks.VANISHING_BLOCK.get()), (int)8).pattern("#w#").pattern("w6w").pattern("#w#").define(Character.valueOf('w'), ItemTagGenerator.TOWERWOOD).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_TOWERWOOD.get()})).define(Character.valueOf('6'), ItemTagGenerator.CARMINITE_GEMS).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.REAPPEARING_BLOCK.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_TOWERWOOD.get())).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TOWERWOOD.get()})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TOWERWOOD.get()))).save(output, TwilightForestMod.prefix("wood/" + TFBlocks.MOSSY_TOWERWOOD.getId().getPath()));
    }

    private void equipmentRecipes(HolderLookup.Provider provider, RecipeOutput output) {
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_BOOTS, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)1)));
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_LEGGINGS, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)1)));
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_CHESTPLATE, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)1)));
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_HELMET, ItemTagGenerator.IRONWOOD_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.AQUA_AFFINITY, (Object)1)));
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_SWORD, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.KNOCKBACK, (Object)1)));
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_PICKAXE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)1)));
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_AXE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)1)));
        this.shovelItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_SHOVEL, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.UNBREAKING, (Object)1)));
        this.hoeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_HOE, ItemTagGenerator.IRONWOOD_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)1)));
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_BOOTS, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)2)));
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_LEGGINGS, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.FIRE_PROTECTION, (Object)2)));
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_CHESTPLATE, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.BLAST_PROTECTION, (Object)2)));
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_HELMET, ItemTagGenerator.STEELEAF_INGOTS, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROJECTILE_PROTECTION, (Object)2)));
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_SWORD, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.LOOTING, (Object)2)));
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_PICKAXE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)2)));
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_AXE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)2)));
        this.shovelItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_SHOVEL, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.EFFICIENCY, (Object)2)));
        this.hoeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_HOE, ItemTagGenerator.STEELEAF_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN, this.buildEnchants(provider, Pair.of((Object)Enchantments.FORTUNE, (Object)2)));
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_BOOTS, ItemTagGenerator.ARCTIC_FUR);
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_CHESTPLATE, ItemTagGenerator.ARCTIC_FUR);
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_HELMET, ItemTagGenerator.ARCTIC_FUR);
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_LEGGINGS, ItemTagGenerator.ARCTIC_FUR);
        this.bootsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_BOOTS, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.chestplateItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_CHESTPLATE, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.helmetItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_HELMET, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.leggingsItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_LEGGINGS, ItemTagGenerator.KNIGHTMETAL_INGOTS);
        this.pickaxeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_PICKAXE, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.swordItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_SWORD, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        this.axeItem(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_AXE, ItemTagGenerator.KNIGHTMETAL_INGOTS, (TagKey<Item>)Tags.Items.RODS_WOODEN);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_BOOTS).pattern("# #").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_boots").save(output, this.locEquip(TFItems.FIERY_BOOTS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_LEGGINGS).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_leggings").save(output, this.locEquip(TFItems.FIERY_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_CHESTPLATE).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_chestplate").save(output, this.locEquip(TFItems.FIERY_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_HELMET).pattern("###").pattern("# #").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_helmet").save(output, this.locEquip(TFItems.FIERY_HELMET.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, TFItems.FIERY_PICKAXE).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_pickaxe").save(output, this.locEquip(TFItems.FIERY_PICKAXE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, TFItems.FIERY_SWORD).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), ItemTagGenerator.FIERY_INGOTS).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_INGOTS)).group("fiery_sword").save(output, this.locEquip(TFItems.FIERY_SWORD.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.NAGA_CHESTPLATE, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.FIRE_PROTECTION, (Object)3)).build())).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), TFItems.NAGA_SCALE).unlockedBy("has_item", CraftingGenerator.has(TFItems.NAGA_SCALE)).save(output, this.locEquip(TFItems.NAGA_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.NAGA_LEGGINGS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)3)).build())).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.NAGA_SCALE).unlockedBy("has_item", CraftingGenerator.has(TFItems.NAGA_SCALE)).save(output, this.locEquip(TFItems.NAGA_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_HELMET, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("###").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_HELMET.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_CHESTPLATE, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_CHESTPLATE.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_LEGGINGS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2)).build())).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_LEGGINGS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemStack)new ItemStack(TFItems.YETI_BOOTS, 1, this.buildEnchants(provider, Pair.of((Object)Enchantments.PROTECTION, (Object)2), Pair.of((Object)Enchantments.FEATHER_FALLING, (Object)4)).build())).pattern("# #").pattern("# #").define(Character.valueOf('#'), TFItems.ALPHA_YETI_FUR).unlockedBy("has_item", CraftingGenerator.has(TFItems.ALPHA_YETI_FUR)).save(output, this.locEquip(TFItems.YETI_BOOTS.getKey().location().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.GIANT_PICKAXE.get())).pattern("###").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), (ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).define(Character.valueOf('X'), (ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, this.locEquip(TFItems.GIANT_PICKAXE.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.GIANT_SWORD.get())).pattern("#").pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).define(Character.valueOf('X'), (ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, this.locEquip(TFItems.GIANT_SWORD.getId().getPath()));
        this.travellersGearRecipes(output);
        this.charmRecipe(output, "charm_of_keeping_2", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_2, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_1);
        this.charmRecipe(output, "charm_of_keeping_3", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_3, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_KEEPING_2);
        this.charmRecipe(output, "charm_of_life_2", (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_LIFE_2, (DeferredHolder<Item, ? extends Item>)TFItems.CHARM_OF_LIFE_1);
        SpecialRecipeBuilder.special(MoonwormQueenRepairRecipe::new).save(output, TwilightForestMod.prefix("moonworm_queen_repair_recipe").toString());
        SpecialRecipeBuilder.special(MagicMapCloningRecipe::new).save(output, TwilightForestMod.prefix("magic_map_cloning_recipe").toString());
        SpecialRecipeBuilder.special(MazeMapCloningRecipe::new).save(output, TwilightForestMod.prefix("maze_map_cloning_recipe").toString());
        SpecialRecipeBuilder.special(EmperorsClothRecipe::new).save(output, TwilightForestMod.prefix("emperors_cloth_recipe").toString());
        SpecialRecipeBuilder.special(CasketRepairRecipe::new).save(output, TwilightForestMod.prefix("casket_repair_recipe").toString());
        SpecialRecipeBuilder.special(EssenceRepairRecipe::new).save(output, TwilightForestMod.prefix("essence_repair_recipe").toString());
        SpecialRecipeBuilder.special(TravellersVestGlovesMergeRecipe::new).save(output, TwilightForestMod.prefix("travellers_vest_gloves_merge_recipe").toString());
        NoSmithingTemplateRecipeBuilder.noTemplate(Ingredient.of((TagKey)Tags.Items.ARMORS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.EMPERORS_CLOTH.get()}), RecipeCategory.MISC).attachData(() -> TFDataComponents.EMPERORS_CLOTH.value(), Unit.INSTANCE).unlocks("has_cloth", CraftingGenerator.has(TFItems.EMPERORS_CLOTH)).save(output, TwilightForestMod.prefix("emperors_cloth_smithing"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.COBBLESTONE, (int)64).requires((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_COBBLESTONE.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.COBBLESTONE).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OAK_LOG, (int)64).requires((ItemLike)TFBlocks.GIANT_LOG.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_LOG.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_LOG.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OAK_LOG).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OAK_LEAVES, (int)64).requires((ItemLike)TFBlocks.GIANT_LEAVES.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_LEAVES.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_LEAVES.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OAK_LEAVES).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.OBSIDIAN, (int)64).requires((ItemLike)TFBlocks.GIANT_OBSIDIAN.get()).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.GIANT_OBSIDIAN.get()))).save(output, TwilightForestMod.prefix(TFBlocks.GIANT_OBSIDIAN.getId().getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)Items.OBSIDIAN).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.BLOCK_AND_CHAIN.get())).requires(Ingredient.of(ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL)).requires(Ingredient.of(ItemTagGenerator.KNIGHTMETAL_INGOTS), 3).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_RING.get()})).unlockedBy("has_block", CraftingGenerator.has(ItemTagGenerator.STORAGE_BLOCKS_KNIGHTMETAL)).unlockedBy("has_ingot", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).unlockedBy("has_ring", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get()))).save(output, this.locEquip(TFItems.BLOCK_AND_CHAIN.getId().getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, TFItems.TANNIN).requires(CraftingGenerator.potionIngredient((Holder<Potion>)Potions.WATER)).requires(TFBlocks.TWILIGHT_OAK_SAPLING).requires(TFBlocks.ROOT_STRAND).requires(TFBlocks.TWILIGHT_OAK_LEAVES).unlockedBy("has_block", CraftingGenerator.has(TFBlocks.TWILIGHT_OAK_SAPLING)).unlockedBy("has_block", CraftingGenerator.has(TFBlocks.ROOT_STRAND)).unlockedBy("has_block", CraftingGenerator.has(TFBlocks.TWILIGHT_OAK_LEAVES)).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, TFItems.TREATED_LEATHER).requires(TFItems.TANNIN).requires(Tags.Items.LEATHERS).unlockedBy("has_tannin", CraftingGenerator.has(TFItems.TANNIN)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get())).pattern(" - ").pattern("- -").pattern(" - ").define(Character.valueOf('-'), ItemTagGenerator.KNIGHTMETAL_INGOTS).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).save(output, this.locEquip(TFItems.KNIGHTMETAL_RING.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_SHIELD.get())).pattern("-#").pattern("-o").pattern("-#").define(Character.valueOf('-'), ItemTagGenerator.KNIGHTMETAL_INGOTS).define(Character.valueOf('#'), ItemTagGenerator.TOWERWOOD).define(Character.valueOf('o'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.KNIGHTMETAL_RING.get()})).unlockedBy("has_ingot", CraftingGenerator.has(ItemTagGenerator.KNIGHTMETAL_INGOTS)).unlockedBy("has_ring", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.KNIGHTMETAL_RING.get()))).save(output, this.locEquip(TFItems.KNIGHTMETAL_SHIELD.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.LIFEDRAIN_SCEPTER.get(), 9).addRepairIngredient((ItemLike)Items.FERMENTED_SPIDER_EYE).save(output, this.locEquip(TFItems.LIFEDRAIN_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.FORTIFICATION_SCEPTER.get(), 9).addRepairIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE})).save(output, this.locEquip(TFItems.FORTIFICATION_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.TWILIGHT_SCEPTER.get(), 9).addRepairIngredient((TagKey<Item>)Tags.Items.ENDER_PEARLS).save(output, this.locEquip(TFItems.TWILIGHT_SCEPTER.getId().getPath()));
        ScepterRecipeBuilder.repairFor((Item)TFItems.ZOMBIE_SCEPTER.get(), 9).addRepairIngredient(CraftingGenerator.potionsIngredient(Potions.STRENGTH, Potions.LONG_STRENGTH, Potions.STRONG_STRENGTH)).addRepairIngredient((ItemLike)Items.ROTTEN_FLESH).save(output, this.locEquip(TFItems.ZOMBIE_SCEPTER.getId().getPath()));
        Predicate<Ingredient> splitTravellersModifiersRecipes = ingredient -> Arrays.stream(ingredient.getItems()).allMatch(stack -> stack.has(TFDataComponents.IS_TRAVELLERS_GEAR) && !stack.is(TFItems.TRAVELLERS_BELT));
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" R ").pattern("RGR").define(Character.valueOf('R'), (ItemLike)TFBlocks.RED_THREAD).define(Character.valueOf('G'), (ItemLike)TFItems.TRAVELLERS_GOGGLES).build(), TravellersModifiersManager.RED_THREAD_VISION_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" E ").pattern("PVP").pattern(" S ").define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('V'), (ItemLike)TFItems.TRAVELLERS_VEST).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).build(), TravellersModifiersManager.PERFECT_DODGE_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShapeless(CartesianShapelessRecipeBuilder.create(splitTravellersModifiersRecipes).ingredient(CraftingGenerator.potionsIngredient(Potions.INVISIBILITY, Potions.LONG_INVISIBILITY)).ingredient((ItemLike)Items.ENDER_EYE).ingredient((ItemLike)Items.SPIDER_EYE).ingredient((ItemLike)Items.GOLDEN_CARROT).ingredient((ItemLike)TFItems.TRAVELLERS_VEST).build(), TravellersModifiersManager.STEALTH_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("RRR").pattern("RVR").pattern("OOO").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('V'), (ItemLike)TFItems.TRAVELLERS_VEST).define(Character.valueOf('O'), (ItemLike)Items.OBSIDIAN).build(), TravellersModifiersManager.HASTE_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShapeless(CartesianShapelessRecipeBuilder.create(splitTravellersModifiersRecipes).ingredient((ItemLike)TFItems.EXANIMATE_ESSENCE).ingredient((ItemLike)TFItems.ORE_MAGNET).ingredient((ItemLike)TFItems.LIVEROOT).ingredient((ItemLike)Items.CHICKEN).ingredient((ItemLike)TFItems.TRAVELLERS_VEST).build(), TravellersModifiersManager.ARROW_MAGNETISM_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShapeless(CartesianShapelessRecipeBuilder.create(splitTravellersModifiersRecipes).ingredient((ItemLike)TFItems.HYDRA_CHOP).ingredient((ItemLike)TFItems.HYDRA_CHOP).ingredient((ItemLike)TFItems.HYDRA_CHOP).ingredient((ItemLike)Items.BUNDLE).ingredient((ItemLike)TFItems.TRAVELLERS_VEST).build(), TravellersModifiersManager.EFFICIENT_EATER_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShapeless(CartesianShapelessRecipeBuilder.create(splitTravellersModifiersRecipes).ingredient((ItemLike)TFItems.TRAVELLERS_WINGS).ingredient((ItemLike)TFItems.TRAVELLERS_BELT).build(), TravellersModifiersManager.SWAP_HOTBAR_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("FCF").pattern("FWF").pattern("FEF").define(Character.valueOf('F'), (ItemLike)Items.FEATHER).define(Character.valueOf('C'), (ItemLike)Items.COBWEB).define(Character.valueOf('W'), (ItemLike)TFItems.TRAVELLERS_WINGS).define(Character.valueOf('E'), (ItemLike)TFItems.BORER_ESSENCE).build(), TravellersModifiersManager.GRADUAL_GLIDE_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" L ").pattern("SWS").pattern("P P").define(Character.valueOf('L'), CraftingGenerator.potionsIngredient(Potions.LEAPING, Potions.LONG_LEAPING, Potions.STRONG_LEAPING)).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('W'), (ItemLike)TFItems.TRAVELLERS_WINGS).define(Character.valueOf('P'), (ItemLike)Items.PISTON).build(), TravellersModifiersManager.DOUBLE_JUMP_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("FPF").pattern("HWH").define(Character.valueOf('P'), CraftingGenerator.potionsIngredient(Potions.SWIFTNESS, Potions.LONG_SWIFTNESS, Potions.STRONG_SWIFTNESS)).define(Character.valueOf('H'), (ItemLike)Items.RABBIT_HIDE).define(Character.valueOf('W'), (ItemLike)TFItems.TRAVELLERS_WINGS).define(Character.valueOf('F'), (ItemLike)TFItems.RAVEN_FEATHER).build(), TravellersModifiersManager.AGILE_RANGER_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("SBS").pattern("PWP").pattern("SBS").define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.BONES).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('W'), (ItemLike)TFItems.TRAVELLERS_WINGS).build(), TravellersModifiersManager.SIDESTEP_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("SBS").pattern("L L").define(Character.valueOf('B'), (ItemLike)TFItems.TRAVELLERS_BOOTS).define(Character.valueOf('S'), (ItemLike)TFItems.MAZE_SLIME_BALL).define(Character.valueOf('L'), (ItemLike)Items.LILY_PAD).build(), TravellersModifiersManager.WATER_WALK_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("n n").pattern("kbk").pattern("i i").define(Character.valueOf('b'), (ItemLike)TFItems.TRAVELLERS_BOOTS).define(Character.valueOf('k'), ItemTagGenerator.KNIGHTMETAL_INGOTS).define(Character.valueOf('n'), (TagKey<Item>)Tags.Items.NUGGETS_IRON).define(Character.valueOf('i'), (TagKey<Item>)Tags.Items.INGOTS_IRON).build(), TravellersModifiersManager.UNRESTRAINED_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("WBW").pattern("S S").define(Character.valueOf('W'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('B'), (ItemLike)TFItems.TRAVELLERS_BOOTS).define(Character.valueOf('S'), (ItemLike)Items.SLIME_BLOCK).build(), TravellersModifiersManager.SLIMY_SOLES_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("MPM").pattern("HBH").define(Character.valueOf('M'), (ItemLike)TFItems.RAW_MEEF).define(Character.valueOf('P'), CraftingGenerator.potionsIngredient(Potions.SWIFTNESS, Potions.LONG_SWIFTNESS, Potions.STRONG_SWIFTNESS)).define(Character.valueOf('B'), (ItemLike)TFItems.TRAVELLERS_BOOTS).define(Character.valueOf('H'), (ItemLike)Items.RABBIT_HIDE).build(), TravellersModifiersManager.STRAIGHT_AHEAD_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" E ").pattern("MTM").pattern(" E ").define(Character.valueOf('E'), (ItemLike)Items.EXPERIENCE_BOTTLE).define(Character.valueOf('M'), (ItemLike)TFBlocks.MOSS_PATCH).define(Character.valueOf('T'), Ingredient.of((ItemLike[])new ItemLike[]{TFItems.TRAVELLERS_GOGGLES, TFItems.TRAVELLERS_VEST, TFItems.TRAVELLERS_WINGS, TFItems.TRAVELLERS_BOOTS})).build(), TravellersModifiersManager.AUTO_REPAIR_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" M ").pattern("ETE").pattern(" M ").define(Character.valueOf('M'), (ItemLike)TFBlocks.MOSS_PATCH).define(Character.valueOf('E'), (ItemLike)Items.EXPERIENCE_BOTTLE).define(Character.valueOf('T'), Ingredient.of((ItemLike[])new ItemLike[]{TFItems.TRAVELLERS_GOGGLES, TFItems.TRAVELLERS_VEST, TFItems.TRAVELLERS_WINGS, TFItems.TRAVELLERS_BOOTS})).build(), TravellersModifiersManager.AUTO_REPAIR_MODIFIER, true).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("M M").pattern("YGY").pattern("M M").define(Character.valueOf('M'), (ItemLike)Items.PHANTOM_MEMBRANE).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_STAINED_GLASS_PANE).define(Character.valueOf('G'), (ItemLike)TFItems.TRAVELLERS_GOGGLES).build(), TravellersModifiersManager.ALL_NIGHT_GOGGLES_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern("sss").pattern("igi").pattern("sss").define(Character.valueOf('i'), (ItemLike)Items.ITEM_FRAME).define(Character.valueOf('s'), (TagKey<Item>)Tags.Items.RODS_WOODEN).define(Character.valueOf('g'), (ItemLike)TFItems.TRAVELLERS_GOGGLES).build(), TravellersModifiersManager.ITEM_DISPLAY_MODIFIER).save(output);
        TravellersGearComponentModifierBuilder.buildShaped(CartesianShapedRecipeBuilder.create(splitTravellersModifiersRecipes).pattern(" b").pattern("gb").pattern("sw").define(Character.valueOf('b'), (ItemLike)Items.BAMBOO).define(Character.valueOf('w'), CraftingGenerator.potionsIngredient(Potions.WATER_BREATHING, Potions.LONG_WATER_BREATHING)).define(Character.valueOf('s'), (TagKey<Item>)Tags.Items.SLIME_BALLS).define(Character.valueOf('g'), (ItemLike)TFItems.TRAVELLERS_GOGGLES).build(), TravellersModifiersManager.AQUATIC_AGILITY_MODIFIER).save(output);
        DryingRecipeBuilder.drying(Ingredient.of((TagKey)Tags.Items.FOODS_COOKED_MEAT), new ItemStack((ItemLike)Items.LEATHER), 8.5f).unlockedBy("has_meat", (Criterion)CraftingGenerator.has((TagKey<Item>)Tags.Items.FOODS_COOKED_MEAT)).save(output, TwilightForestMod.prefix("drying/cooked_meat_to_leather"));
        DryingRecipeBuilder.drying(Ingredient.of((TagKey)ItemTags.SAPLINGS), new ItemStack((ItemLike)Items.DEAD_BUSH), 6.0f).unlockedBy("has_sapling", (Criterion)CraftingGenerator.has((TagKey<Item>)ItemTags.SAPLINGS)).save(output, TwilightForestMod.prefix("drying/sapling_to_dead_bush"));
        DryingRecipeBuilder.drying((ItemLike)Items.MUD, (ItemLike)Items.CLAY, 6.0f).unlockedBy("has_mud", CraftingGenerator.has((ItemLike)Items.MUD)).save(output, TwilightForestMod.prefix("drying/mud_to_clay"));
        DryingRecipeBuilder.drying((ItemLike)Items.WET_SPONGE, (ItemLike)Items.SPONGE, 2.0f).unlockedBy("has_wet_sponge", CraftingGenerator.has((ItemLike)Items.WET_SPONGE)).save(output, TwilightForestMod.prefix("drying/sponge"));
        DryingRecipeBuilder.drying((ItemLike)Items.KELP, (ItemLike)Items.DRIED_KELP, 3.0f).unlockedBy("has_kelp", CraftingGenerator.has((ItemLike)Items.KELP)).save(output, TwilightForestMod.prefix("drying/kelp"));
        DryingRecipeBuilder.drying((ItemLike)Items.ROTTEN_FLESH, TFItems.MONSTER_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.ROTTEN_FLESH)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.BEEF, TFItems.BEEF_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.BEEF)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.CHICKEN, TFItems.CHICKEN_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.CHICKEN)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.PORKCHOP, TFItems.PORK_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.PORKCHOP)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.MUTTON, TFItems.MUTTON_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.MUTTON)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.RABBIT, TFItems.RABBIT_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.RABBIT)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.COD, TFItems.COD_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.COD)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.SALMON, TFItems.SALMON_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.SALMON)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.TROPICAL_FISH, TFItems.TROPICAL_FISH_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.TROPICAL_FISH)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.PUFFERFISH, TFItems.FUGU_JERKY).unlockedBy("has_meat", CraftingGenerator.has((ItemLike)Items.PUFFERFISH)).save(output);
        DryingRecipeBuilder.drying(TFItems.RAW_VENISON, TFItems.VENISON_JERKY).unlockedBy("has_meat", CraftingGenerator.has(TFItems.RAW_VENISON)).save(output);
        DryingRecipeBuilder.drying(TFItems.RAW_MEEF, TFItems.MEEF_JERKY).unlockedBy("has_meat", CraftingGenerator.has(TFItems.RAW_MEEF)).save(output);
        DryingRecipeBuilder.drying((ItemLike)Items.SLIME_BALL, TFItems.GELATINOUS_SLIME_DROP).unlockedBy("has_slime_ball", CraftingGenerator.has((ItemLike)Items.SLIME_BALL)).save(output);
        DryingRecipeBuilder.drying(TFItems.MAZE_SLIME_BALL, TFItems.GELATINOUS_MAZE_SLIME_DROP).unlockedBy("has_maze_slime_ball", CraftingGenerator.has(TFItems.MAZE_SLIME_BALL)).save(output);
        DryingRecipeBuilder.drying(TFItems.TREATED_LEATHER, TFItems.TANNED_LEATHER).unlockedBy("has_treated", CraftingGenerator.has(TFItems.TREATED_LEATHER)).save(output);
        this.DryingRackCoralRecipes(output);
        DryingRecipeBuilder.drying((ItemLike)Items.BREAD, TFItems.STALE_BREAD).save(output);
    }

    private void blockCompressionRecipes(RecipeOutput output) {
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.ARCTIC_FUR, (DeferredBlock<? extends Block>)TFBlocks.ARCTIC_FUR_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.CARMINITE, (DeferredBlock<? extends Block>)TFBlocks.CARMINITE_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.IRONWOOD_INGOT, (DeferredBlock<? extends Block>)TFBlocks.IRONWOOD_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.KNIGHTMETAL_INGOT, (DeferredBlock<? extends Block>)TFBlocks.KNIGHTMETAL_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.STEELEAF_INGOT, (DeferredBlock<? extends Block>)TFBlocks.STEELEAF_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_INGOT, (DeferredBlock<? extends Block>)TFBlocks.FIERY_BLOCK);
        this.reverseCompressBlock(output, (DeferredHolder<Item, ? extends Item>)TFItems.MAZE_SLIME_BALL, (DeferredBlock<? extends Block>)TFBlocks.MAZE_SLIME_BLOCK);
        this.compressedBlock(output, TFBlocks.ARCTIC_FUR_BLOCK, ItemTagGenerator.ARCTIC_FUR, TFItems.ARCTIC_FUR);
        this.compressedBlock(output, TFBlocks.CARMINITE_BLOCK, ItemTagGenerator.CARMINITE_GEMS, TFItems.CARMINITE);
        this.compressedBlock(output, TFBlocks.FIERY_BLOCK, ItemTagGenerator.FIERY_INGOTS, TFItems.FIERY_INGOT);
        this.compressedBlock(output, TFBlocks.IRONWOOD_BLOCK, ItemTagGenerator.IRONWOOD_INGOTS, TFItems.IRONWOOD_INGOT);
        this.compressedBlock(output, TFBlocks.KNIGHTMETAL_BLOCK, ItemTagGenerator.KNIGHTMETAL_INGOTS, TFItems.KNIGHTMETAL_INGOT);
        this.compressedBlock(output, TFBlocks.STEELEAF_BLOCK, ItemTagGenerator.STEELEAF_INGOTS, TFItems.STEELEAF_INGOT);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, TFBlocks.MAZE_SLIME_BLOCK).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), TFItems.MAZE_SLIME_BALL).unlockedBy("has_item", CraftingGenerator.has(TFItems.MAZE_SLIME_BALL)).save(output, TwilightForestMod.prefix("compressed_blocks/maze_slime"));
    }

    private void emptyMapRecipes(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAGIC_MAP_FOCUS.get())).requires((ItemLike)TFItems.RAVEN_FEATHER.get()).requires((ItemLike)TFItems.TORCHBERRIES.get()).requires(Tags.Items.DUSTS_GLOWSTONE).unlockedBy("has_berries", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.TORCHBERRIES.get()))).unlockedBy("has_feather", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAVEN_FEATHER.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAGIC_MAP.get())).pattern("###").pattern("#\u2022#").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.PAPER).define(Character.valueOf('\u2022'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MAGIC_MAP_FOCUS.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAGIC_MAP_FOCUS.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.MAZE_MAP.get())).pattern("###").pattern("#\u2022#").pattern("###").define(Character.valueOf('#'), ItemTagGenerator.PAPER).define(Character.valueOf('\u2022'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.MAZE_MAP_FOCUS.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAZE_MAP_FOCUS.get()))).save(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.ORE_MAP.get())).requires((ItemLike)TFItems.MAZE_MAP.get()).requires(Tags.Items.STORAGE_BLOCKS_DIAMOND).requires(Tags.Items.STORAGE_BLOCKS_GOLD).requires(Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.MAZE_MAP.get()))).save(output);
    }

    private void woodRecipes(RecipeOutput output) {
        this.buttonBlock(output, "canopy", TFBlocks.CANOPY_BUTTON, TFBlocks.CANOPY_PLANKS);
        this.buttonBlock(output, "dark", TFBlocks.DARK_BUTTON, TFBlocks.DARK_PLANKS);
        this.buttonBlock(output, "mangrove", TFBlocks.MANGROVE_BUTTON, TFBlocks.MANGROVE_PLANKS);
        this.buttonBlock(output, "mining", TFBlocks.MINING_BUTTON, TFBlocks.MINING_PLANKS);
        this.buttonBlock(output, "sorting", TFBlocks.SORTING_BUTTON, TFBlocks.SORTING_PLANKS);
        this.buttonBlock(output, "time", TFBlocks.TIME_BUTTON, TFBlocks.TIME_PLANKS);
        this.buttonBlock(output, "transformation", TFBlocks.TRANSFORMATION_BUTTON, TFBlocks.TRANSFORMATION_PLANKS);
        this.buttonBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_BUTTON, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.doorBlock(output, "canopy", TFBlocks.CANOPY_DOOR, TFBlocks.CANOPY_PLANKS);
        this.doorBlock(output, "dark", TFBlocks.DARK_DOOR, TFBlocks.DARK_PLANKS);
        this.doorBlock(output, "mangrove", TFBlocks.MANGROVE_DOOR, TFBlocks.MANGROVE_PLANKS);
        this.doorBlock(output, "mining", TFBlocks.MINING_DOOR, TFBlocks.MINING_PLANKS);
        this.doorBlock(output, "sorting", TFBlocks.SORTING_DOOR, TFBlocks.SORTING_PLANKS);
        this.doorBlock(output, "time", TFBlocks.TIME_DOOR, TFBlocks.TIME_PLANKS);
        this.doorBlock(output, "transformation", TFBlocks.TRANSFORMATION_DOOR, TFBlocks.TRANSFORMATION_PLANKS);
        this.doorBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_DOOR, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.fenceBlock(output, "canopy", TFBlocks.CANOPY_FENCE, TFBlocks.CANOPY_PLANKS);
        this.fenceBlock(output, "dark", TFBlocks.DARK_FENCE, TFBlocks.DARK_PLANKS);
        this.fenceBlock(output, "mangrove", TFBlocks.MANGROVE_FENCE, TFBlocks.MANGROVE_PLANKS);
        this.fenceBlock(output, "mining", TFBlocks.MINING_FENCE, TFBlocks.MINING_PLANKS);
        this.fenceBlock(output, "sorting", TFBlocks.SORTING_FENCE, TFBlocks.SORTING_PLANKS);
        this.fenceBlock(output, "time", TFBlocks.TIME_FENCE, TFBlocks.TIME_PLANKS);
        this.fenceBlock(output, "transformation", TFBlocks.TRANSFORMATION_FENCE, TFBlocks.TRANSFORMATION_PLANKS);
        this.fenceBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_FENCE, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.gateBlock(output, "canopy", TFBlocks.CANOPY_GATE, TFBlocks.CANOPY_PLANKS);
        this.gateBlock(output, "dark", TFBlocks.DARK_GATE, TFBlocks.DARK_PLANKS);
        this.gateBlock(output, "mangrove", TFBlocks.MANGROVE_GATE, TFBlocks.MANGROVE_PLANKS);
        this.gateBlock(output, "mining", TFBlocks.MINING_GATE, TFBlocks.MINING_PLANKS);
        this.gateBlock(output, "sorting", TFBlocks.SORTING_GATE, TFBlocks.SORTING_PLANKS);
        this.gateBlock(output, "time", TFBlocks.TIME_GATE, TFBlocks.TIME_PLANKS);
        this.gateBlock(output, "transformation", TFBlocks.TRANSFORMATION_GATE, TFBlocks.TRANSFORMATION_PLANKS);
        this.gateBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_GATE, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.planksBlock(output, "canopy", TFBlocks.CANOPY_PLANKS, ItemTagGenerator.CANOPY_LOGS);
        this.planksBlock(output, "dark", TFBlocks.DARK_PLANKS, ItemTagGenerator.DARKWOOD_LOGS);
        this.planksBlock(output, "mangrove", TFBlocks.MANGROVE_PLANKS, ItemTagGenerator.MANGROVE_LOGS);
        this.planksBlock(output, "mining", TFBlocks.MINING_PLANKS, ItemTagGenerator.MINING_LOGS);
        this.planksBlock(output, "sorting", TFBlocks.SORTING_PLANKS, ItemTagGenerator.SORTING_LOGS);
        this.planksBlock(output, "time", TFBlocks.TIME_PLANKS, ItemTagGenerator.TIME_LOGS);
        this.planksBlock(output, "transformation", TFBlocks.TRANSFORMATION_PLANKS, ItemTagGenerator.TRANSFORMATION_LOGS);
        this.planksBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_PLANKS, ItemTagGenerator.TWILIGHT_OAK_LOGS);
        this.woodBlock(output, "canopy", TFBlocks.CANOPY_WOOD, TFBlocks.CANOPY_LOG);
        this.woodBlock(output, "dark", TFBlocks.DARK_WOOD, TFBlocks.DARK_LOG);
        this.woodBlock(output, "mangrove", TFBlocks.MANGROVE_WOOD, TFBlocks.MANGROVE_LOG);
        this.woodBlock(output, "mining", TFBlocks.MINING_WOOD, TFBlocks.MINING_LOG);
        this.woodBlock(output, "sorting", TFBlocks.SORTING_WOOD, TFBlocks.SORTING_LOG);
        this.woodBlock(output, "time", TFBlocks.TIME_WOOD, TFBlocks.TIME_LOG);
        this.woodBlock(output, "transformation", TFBlocks.TRANSFORMATION_WOOD, TFBlocks.TRANSFORMATION_LOG);
        this.woodBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_WOOD, TFBlocks.TWILIGHT_OAK_LOG);
        this.strippedWoodBlock(output, "canopy", TFBlocks.STRIPPED_CANOPY_WOOD, TFBlocks.STRIPPED_CANOPY_LOG);
        this.strippedWoodBlock(output, "dark", TFBlocks.STRIPPED_DARK_WOOD, TFBlocks.STRIPPED_DARK_LOG);
        this.strippedWoodBlock(output, "mangrove", TFBlocks.STRIPPED_MANGROVE_WOOD, TFBlocks.STRIPPED_MANGROVE_LOG);
        this.strippedWoodBlock(output, "mining", TFBlocks.STRIPPED_MINING_WOOD, TFBlocks.STRIPPED_MINING_LOG);
        this.strippedWoodBlock(output, "sorting", TFBlocks.STRIPPED_SORTING_WOOD, TFBlocks.STRIPPED_SORTING_LOG);
        this.strippedWoodBlock(output, "time", TFBlocks.STRIPPED_TIME_WOOD, TFBlocks.STRIPPED_TIME_LOG);
        this.strippedWoodBlock(output, "transformation", TFBlocks.STRIPPED_TRANSFORMATION_WOOD, TFBlocks.STRIPPED_TRANSFORMATION_LOG);
        this.strippedWoodBlock(output, "twilight_oak", TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD, TFBlocks.STRIPPED_TWILIGHT_OAK_LOG);
        this.plateBlock(output, "canopy", TFBlocks.CANOPY_PLATE, TFBlocks.CANOPY_PLANKS);
        this.plateBlock(output, "dark", TFBlocks.DARK_PLATE, TFBlocks.DARK_PLANKS);
        this.plateBlock(output, "mangrove", TFBlocks.MANGROVE_PLATE, TFBlocks.MANGROVE_PLANKS);
        this.plateBlock(output, "mining", TFBlocks.MINING_PLATE, TFBlocks.MINING_PLANKS);
        this.plateBlock(output, "sorting", TFBlocks.SORTING_PLATE, TFBlocks.SORTING_PLANKS);
        this.plateBlock(output, "time", TFBlocks.TIME_PLATE, TFBlocks.TIME_PLANKS);
        this.plateBlock(output, "transformation", TFBlocks.TRANSFORMATION_PLATE, TFBlocks.TRANSFORMATION_PLANKS);
        this.plateBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_PLATE, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.woodenSlabBlock(output, "canopy", TFBlocks.CANOPY_SLAB, TFBlocks.CANOPY_PLANKS);
        this.woodenSlabBlock(output, "dark", TFBlocks.DARK_SLAB, TFBlocks.DARK_PLANKS);
        this.woodenSlabBlock(output, "mangrove", TFBlocks.MANGROVE_SLAB, TFBlocks.MANGROVE_PLANKS);
        this.woodenSlabBlock(output, "mining", TFBlocks.MINING_SLAB, TFBlocks.MINING_PLANKS);
        this.woodenSlabBlock(output, "sorting", TFBlocks.SORTING_SLAB, TFBlocks.SORTING_PLANKS);
        this.woodenSlabBlock(output, "time", TFBlocks.TIME_SLAB, TFBlocks.TIME_PLANKS);
        this.woodenSlabBlock(output, "transformation", TFBlocks.TRANSFORMATION_SLAB, TFBlocks.TRANSFORMATION_PLANKS);
        this.woodenSlabBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_SLAB, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.woodenStairsBlock(output, this.locWood("canopy_stairs"), TFBlocks.CANOPY_STAIRS, TFBlocks.CANOPY_PLANKS, (ItemLike)TFBlocks.CANOPY_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("dark_stairs"), TFBlocks.DARK_STAIRS, TFBlocks.DARK_PLANKS, (ItemLike)TFBlocks.DARK_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("mangrove_stairs"), TFBlocks.MANGROVE_STAIRS, TFBlocks.MANGROVE_PLANKS, (ItemLike)TFBlocks.MANGROVE_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("mining_stairs"), TFBlocks.MINING_STAIRS, TFBlocks.MINING_PLANKS, (ItemLike)TFBlocks.MINING_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("sorting_stairs"), TFBlocks.SORTING_STAIRS, TFBlocks.SORTING_PLANKS, (ItemLike)TFBlocks.SORTING_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("time_stairs"), TFBlocks.TIME_STAIRS, TFBlocks.TIME_PLANKS, (ItemLike)TFBlocks.TIME_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("transformation_stairs"), TFBlocks.TRANSFORMATION_STAIRS, TFBlocks.TRANSFORMATION_PLANKS, (ItemLike)TFBlocks.TRANSFORMATION_PLANKS.get());
        this.woodenStairsBlock(output, this.locWood("twilight_oak_stairs"), TFBlocks.TWILIGHT_OAK_STAIRS, TFBlocks.TWILIGHT_OAK_PLANKS, (ItemLike)TFBlocks.TWILIGHT_OAK_PLANKS.get());
        this.trapdoorBlock(output, "canopy", TFBlocks.CANOPY_TRAPDOOR, TFBlocks.CANOPY_PLANKS);
        this.trapdoorBlock(output, "dark", TFBlocks.DARK_TRAPDOOR, TFBlocks.DARK_PLANKS);
        this.trapdoorBlock(output, "mangrove", TFBlocks.MANGROVE_TRAPDOOR, TFBlocks.MANGROVE_PLANKS);
        this.trapdoorBlock(output, "mining", TFBlocks.MINING_TRAPDOOR, TFBlocks.MINING_PLANKS);
        this.trapdoorBlock(output, "sorting", TFBlocks.SORTING_TRAPDOOR, TFBlocks.SORTING_PLANKS);
        this.trapdoorBlock(output, "time", TFBlocks.TIME_TRAPDOOR, TFBlocks.TIME_PLANKS);
        this.trapdoorBlock(output, "transformation", TFBlocks.TRANSFORMATION_TRAPDOOR, TFBlocks.TRANSFORMATION_PLANKS);
        this.trapdoorBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_TRAPDOOR, TFBlocks.TWILIGHT_OAK_PLANKS);
        this.signBlock(output, "canopy", (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_SIGN, (DeferredBlock<? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.signBlock(output, "dark", (DeferredHolder<Item, ? extends Item>)TFItems.DARK_SIGN, (DeferredBlock<? extends Block>)TFBlocks.DARK_PLANKS);
        this.signBlock(output, "mangrove", (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_SIGN, (DeferredBlock<? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.signBlock(output, "mining", (DeferredHolder<Item, ? extends Item>)TFItems.MINING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.MINING_PLANKS);
        this.signBlock(output, "sorting", (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.SORTING_PLANKS);
        this.signBlock(output, "time", (DeferredHolder<Item, ? extends Item>)TFItems.TIME_SIGN, (DeferredBlock<? extends Block>)TFBlocks.TIME_PLANKS);
        this.signBlock(output, "transformation", (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_SIGN, (DeferredBlock<? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.signBlock(output, "twilight_oak", (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_SIGN, (DeferredBlock<? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.hangingSignBlock(output, "canopy", (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_CANOPY_LOG);
        this.hangingSignBlock(output, "dark", (DeferredHolder<Item, ? extends Item>)TFItems.DARK_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_DARK_LOG);
        this.hangingSignBlock(output, "mangrove", (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_MANGROVE_LOG);
        this.hangingSignBlock(output, "mining", (DeferredHolder<Item, ? extends Item>)TFItems.MINING_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_MINING_LOG);
        this.hangingSignBlock(output, "sorting", (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_SORTING_LOG);
        this.hangingSignBlock(output, "time", (DeferredHolder<Item, ? extends Item>)TFItems.TIME_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_TIME_LOG);
        this.hangingSignBlock(output, "transformation", (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_TRANSFORMATION_LOG);
        this.hangingSignBlock(output, "twilight_oak", (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_HANGING_SIGN, (DeferredBlock<? extends Block>)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG);
        this.banisterBlock(output, "canopy", TFBlocks.CANOPY_BANISTER, TFBlocks.CANOPY_SLAB);
        this.banisterBlock(output, "dark", TFBlocks.DARK_BANISTER, TFBlocks.DARK_SLAB);
        this.banisterBlock(output, "mangrove", TFBlocks.MANGROVE_BANISTER, TFBlocks.MANGROVE_SLAB);
        this.banisterBlock(output, "mining", TFBlocks.MINING_BANISTER, TFBlocks.MINING_SLAB);
        this.banisterBlock(output, "sorting", TFBlocks.SORTING_BANISTER, TFBlocks.SORTING_SLAB);
        this.banisterBlock(output, "time", TFBlocks.TIME_BANISTER, TFBlocks.TIME_SLAB);
        this.banisterBlock(output, "transformation", TFBlocks.TRANSFORMATION_BANISTER, TFBlocks.TRANSFORMATION_SLAB);
        this.banisterBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_BANISTER, TFBlocks.TWILIGHT_OAK_SLAB);
        this.banisterBlock(output, "oak", TFBlocks.OAK_BANISTER, Blocks.OAK_SLAB);
        this.banisterBlock(output, "spruce", TFBlocks.SPRUCE_BANISTER, Blocks.SPRUCE_SLAB);
        this.banisterBlock(output, "birch", TFBlocks.BIRCH_BANISTER, Blocks.BIRCH_SLAB);
        this.banisterBlock(output, "jungle", TFBlocks.JUNGLE_BANISTER, Blocks.JUNGLE_SLAB);
        this.banisterBlock(output, "acacia", TFBlocks.ACACIA_BANISTER, Blocks.ACACIA_SLAB);
        this.banisterBlock(output, "dark_oak", TFBlocks.DARK_OAK_BANISTER, Blocks.DARK_OAK_SLAB);
        this.banisterBlock(output, "crimson", TFBlocks.CRIMSON_BANISTER, Blocks.CRIMSON_SLAB);
        this.banisterBlock(output, "warped", TFBlocks.WARPED_BANISTER, Blocks.WARPED_SLAB);
        this.banisterBlock(output, "vangrove", TFBlocks.VANGROVE_BANISTER, Blocks.MANGROVE_SLAB);
        this.banisterBlock(output, "bamboo", TFBlocks.BAMBOO_BANISTER, Blocks.BAMBOO_SLAB);
        this.banisterBlock(output, "cherry", TFBlocks.CHERRY_BANISTER, Blocks.CHERRY_SLAB);
        this.dryingRackBlock(output, "canopy", TFBlocks.CANOPY_DRYING_RACK, TFBlocks.CANOPY_SLAB);
        this.dryingRackBlock(output, "dark", TFBlocks.DARK_DRYING_RACK, TFBlocks.DARK_SLAB);
        this.dryingRackBlock(output, "mangrove", TFBlocks.MANGROVE_DRYING_RACK, TFBlocks.MANGROVE_SLAB);
        this.dryingRackBlock(output, "mining", TFBlocks.MINING_DRYING_RACK, TFBlocks.MINING_SLAB);
        this.dryingRackBlock(output, "sorting", TFBlocks.SORTING_DRYING_RACK, TFBlocks.SORTING_SLAB);
        this.dryingRackBlock(output, "time", TFBlocks.TIME_DRYING_RACK, TFBlocks.TIME_SLAB);
        this.dryingRackBlock(output, "transformation", TFBlocks.TRANSFORMATION_DRYING_RACK, TFBlocks.TRANSFORMATION_SLAB);
        this.dryingRackBlock(output, "twilight_oak", TFBlocks.TWILIGHT_OAK_DRYING_RACK, TFBlocks.TWILIGHT_OAK_SLAB);
        this.dryingRackBlock(output, "oak", TFBlocks.OAK_DRYING_RACK, Blocks.OAK_SLAB);
        this.dryingRackBlock(output, "spruce", TFBlocks.SPRUCE_DRYING_RACK, Blocks.SPRUCE_SLAB);
        this.dryingRackBlock(output, "birch", TFBlocks.BIRCH_DRYING_RACK, Blocks.BIRCH_SLAB);
        this.dryingRackBlock(output, "jungle", TFBlocks.JUNGLE_DRYING_RACK, Blocks.JUNGLE_SLAB);
        this.dryingRackBlock(output, "acacia", TFBlocks.ACACIA_DRYING_RACK, Blocks.ACACIA_SLAB);
        this.dryingRackBlock(output, "dark_oak", TFBlocks.DARK_OAK_DRYING_RACK, Blocks.DARK_OAK_SLAB);
        this.dryingRackBlock(output, "crimson", TFBlocks.CRIMSON_DRYING_RACK, Blocks.CRIMSON_SLAB);
        this.dryingRackBlock(output, "warped", TFBlocks.WARPED_DRYING_RACK, Blocks.WARPED_SLAB);
        this.dryingRackBlock(output, "vangrove", TFBlocks.VANGROVE_DRYING_RACK, Blocks.MANGROVE_SLAB);
        this.dryingRackBlock(output, "bamboo", TFBlocks.BAMBOO_DRYING_RACK, Blocks.BAMBOO_SLAB);
        this.dryingRackBlock(output, "cherry", TFBlocks.CHERRY_DRYING_RACK, Blocks.CHERRY_SLAB);
        this.chestBlock(output, "twilight_oak", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TWILIGHT_OAK_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TWILIGHT_OAK_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.chestBlock(output, "canopy", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.CANOPY_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.CANOPY_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.chestBlock(output, "mangrove", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MANGROVE_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MANGROVE_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.chestBlock(output, "dark", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.DARK_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.DARK_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.DARK_PLANKS);
        this.chestBlock(output, "time", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TIME_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TIME_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.TIME_PLANKS);
        this.chestBlock(output, "transformation", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TRANSFORMATION_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.TRANSFORMATION_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.chestBlock(output, "mining", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MINING_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.MINING_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.MINING_PLANKS);
        this.chestBlock(output, "sorting", (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.SORTING_CHEST, (DeferredHolder<Block, ? extends ChestBlock>)TFBlocks.SORTING_TRAPPED_CHEST, (DeferredBlock<? extends Block>)TFBlocks.SORTING_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TWILIGHT_OAK_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.TWILIGHT_OAK_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.CANOPY_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.CANOPY_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.MANGROVE_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.MANGROVE_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.DARK_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.DARK_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.DARK_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TIME_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TIME_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.TIME_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.TRANSFORMATION_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.TRANSFORMATION_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.MINING_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.MINING_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.MINING_PLANKS);
        this.buildBoats(output, (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_BOAT, (DeferredHolder<Item, ? extends Item>)TFItems.SORTING_CHEST_BOAT, (DeferredBlock<? extends Block>)TFBlocks.SORTING_PLANKS);
    }

    private void nagastoneRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.SPIRAL_BRICKS.get()), (int)8).pattern("BSS").pattern("BSS").pattern("BBB").define(Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE_BRICKS, Blocks.MOSSY_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.CHISELED_STONE_BRICKS})).define(Character.valueOf('S'), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.STONE_SLAB, Blocks.STONE_BRICK_SLAB})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.SPIRAL_BRICKS.get()))).save(output, this.locNaga("nagastone_spiral"));
        this.stairsBlock(output, this.locNaga("nagastone_stairs_left"), TFBlocks.NAGASTONE_STAIRS_LEFT, TFBlocks.ETCHED_NAGASTONE, (ItemLike)TFBlocks.ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("nagastone_stairs_right"), TFBlocks.NAGASTONE_STAIRS_RIGHT, TFBlocks.ETCHED_NAGASTONE, (ItemLike)TFBlocks.ETCHED_NAGASTONE.get());
        this.stairsBlock(output, this.locNaga("mossy_nagastone_stairs_left"), TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT, TFBlocks.MOSSY_ETCHED_NAGASTONE, (ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("mossy_nagastone_stairs_right"), TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT, TFBlocks.MOSSY_ETCHED_NAGASTONE, (ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_ETCHED_NAGASTONE.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ETCHED_NAGASTONE.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ETCHED_NAGASTONE.get()))).save(output, this.locNaga("mossy_etched_nagastone"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_NAGASTONE_PILLAR.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.NAGASTONE_PILLAR.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.NAGASTONE_PILLAR.get()))).save(output, this.locNaga("mossy_nagastone_pillar"));
        this.stairsBlock(output, this.locNaga("cracked_nagastone_stairs_left"), TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT, TFBlocks.CRACKED_ETCHED_NAGASTONE, (ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get());
        this.stairsRightBlock(output, this.locNaga("cracked_nagastone_stairs_right"), TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT, TFBlocks.CRACKED_ETCHED_NAGASTONE, (ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get());
    }

    private void castleRecipes(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Blocks.VINE, Blocks.MOSS_BLOCK})).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get()})).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("mossy_castle_brick"));
        this.castleBlock(output, TFBlocks.THICK_CASTLE_BRICK, (ItemLike)TFBlocks.CASTLE_BRICK.get(), (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get(), (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get(), (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get());
        this.castleBlock(output, TFBlocks.BOLD_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.THICK_CASTLE_BRICK.get());
        this.castleBlock(output, TFBlocks.BOLD_CASTLE_BRICK_TILE, (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get()), (int)4).pattern("##").pattern("##").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get()})).unlockedBy("has_castle_brick", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("bold_castle_pillar_from_tile"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get()), (int)6).pattern("#H#").pattern("#H#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get(), (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get(), (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get(), (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get(), (ItemLike)TFBlocks.THICK_CASTLE_BRICK.get()})).define(Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get()})).unlockedBy("has_castle_brick", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, this.locCastle("encased_castle_pillar"));
        this.stairsBlock(output, this.locCastle("bold_castle_brick_stairs"), TFBlocks.BOLD_CASTLE_BRICK_STAIRS, TFBlocks.BOLD_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.BOLD_CASTLE_BRICK_TILE.get());
        this.stairsBlock(output, this.locCastle("castle_brick_stairs"), TFBlocks.CASTLE_BRICK_STAIRS, TFBlocks.CASTLE_BRICK, (ItemLike)TFBlocks.CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("cracked_castle_brick_stairs"), TFBlocks.CRACKED_CASTLE_BRICK_STAIRS, TFBlocks.CRACKED_CASTLE_BRICK, (ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("encased_castle_brick_stairs"), TFBlocks.ENCASED_CASTLE_BRICK_STAIRS, TFBlocks.ENCASED_CASTLE_BRICK_PILLAR, (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_PILLAR.get(), (ItemLike)TFBlocks.ENCASED_CASTLE_BRICK_TILE.get());
        this.stairsBlock(output, this.locCastle("mossy_castle_brick_stairs"), TFBlocks.MOSSY_CASTLE_BRICK_STAIRS, TFBlocks.MOSSY_CASTLE_BRICK, (ItemLike)TFBlocks.MOSSY_CASTLE_BRICK.get());
        this.stairsBlock(output, this.locCastle("worn_castle_brick_stairs"), TFBlocks.WORN_CASTLE_BRICK_STAIRS, TFBlocks.WORN_CASTLE_BRICK, (ItemLike)TFBlocks.WORN_CASTLE_BRICK.get());
    }

    private void fieryConversions(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.FIERY_INGOT.get())).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL)).requires(Ingredient.of((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_ingot").save(output, this.locEquip("fiery_ingot_crafting"));
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_HELMET, Items.IRON_HELMET, 5);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_CHESTPLATE, Items.IRON_CHESTPLATE, 8);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_LEGGINGS, Items.IRON_LEGGINGS, 7);
        this.fieryConversion(output, (DeferredHolder<Item, ? extends Item>)TFItems.FIERY_BOOTS, Items.IRON_BOOTS, 4);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TFItems.FIERY_SWORD.get())).requires((ItemLike)Items.IRON_SWORD).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL), 2).requires(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE)).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_sword").save(output, this.locEquip("fiery_" + BuiltInRegistries.ITEM.getKey((Object)Items.IRON_SWORD).getPath()));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)TFItems.FIERY_PICKAXE.get())).requires((ItemLike)Items.IRON_PICKAXE).requires(Ingredient.of(ItemTagGenerator.FIERY_VIAL), 3).requires(Ingredient.of((TagKey)Tags.Items.RODS_BLAZE), 2).unlockedBy("has_item", CraftingGenerator.has(ItemTagGenerator.FIERY_VIAL)).group("fiery_pickaxe").save(output, this.locEquip("fiery_" + BuiltInRegistries.ITEM.getKey((Object)Items.IRON_PICKAXE).getPath()));
    }

    private <T extends AbstractCookingRecipe> void cookingRecipes(RecipeOutput output, String processName, RecipeSerializer<T> process, AbstractCookingRecipe.Factory<T> factory, int smeltingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_MEEF.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TFItems.COOKED_MEEF.get()), (float)0.35f, (int)smeltingTime, process, factory).unlockedBy("has_food", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_MEEF.get()))).save(output, TwilightForestMod.prefix("food/" + processName + "_meef").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_VENISON.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TFItems.COOKED_VENISON.get()), (float)0.35f, (int)smeltingTime, process, factory).unlockedBy("has_food", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_VENISON.get()))).save(output, TwilightForestMod.prefix("food/" + processName + "_venison").toString());
    }

    private <T extends AbstractCookingRecipe> void ingotRecipes(RecipeOutput output, String processName, RecipeSerializer<T> process, AbstractCookingRecipe.Factory<T> factory, int smeltingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.KNIGHTMETAL_INGOT.get()), (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.ARMOR_SHARD_CLUSTER.get()))).group("knightmetal_ingot").save(output, TwilightForestMod.prefix("material/" + processName + "_knightmetal_ingot").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.RAW_IRONWOOD.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)TFItems.IRONWOOD_INGOT.get()), (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.RAW_IRONWOOD.get()))).group("ironwood_ingot").save(output, TwilightForestMod.prefix("material/" + processName + "_ironwood_ingot").toString());
    }

    private <T extends AbstractCookingRecipe> void oreberryRecipes(RecipeOutput output, String processName, RecipeSerializer<T> process, AbstractCookingRecipe.Factory<T> factory, int smeltingTime) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.IRON_BERRY.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.IRON_BERRY.get()))).group("iron_nugget").save(output, TwilightForestMod.prefix("material/" + processName + "_iron_nugget").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.GOLD_BERRY.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.GOLD_BERRY.get()))).group("gold_nugget").save(output, TwilightForestMod.prefix("material/" + processName + "_gold_nugget").toString());
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFItems.COPPER_BERRY.get()}), (RecipeCategory)RecipeCategory.MISC, TFItems.COPPER_NUGGET, (float)1.0f, (int)smeltingTime, process, factory).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFItems.COPPER_BERRY.get()))).group("copper_nugget").save(output, TwilightForestMod.prefix("material/" + processName + "_copper_nugget").toString());
    }

    private void DryingRackCoralRecipes(RecipeOutput output) {
        for (String name : CORAL_SPECIES) {
            for (String type : CORAL_TYPES) {
                this.registerCoral(output, name + "_coral" + type);
            }
        }
    }

    private void registerCoral(RecipeOutput output, String coral) {
        DryingRecipeBuilder.drying((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)coral)), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)coral).withPrefix("dead_")), 0.033333335f).unlockedBy("has_coral", CraftingGenerator.has((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)coral))))).save(output);
    }

    private void travellersGearRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_GOGGLES).pattern("l l").pattern("plp").pattern("g g").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('p'), Tags.Items.GLASS_PANES_COLORLESS).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_GOGGLES.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_VEST).pattern("l l").pattern("lwl").pattern("lwl").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('w'), ItemTags.WOOL).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_VEST.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_WINGS).pattern("g g").pattern("ili").pattern("ici").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('i'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('c'), ItemTagGenerator.CARMINITE_GEMS).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_WINGS.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_BOOTS).pattern("s s").pattern("l l").pattern("l l").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('s'), Tags.Items.STRINGS).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_BOOTS.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_BELT).pattern("lll").pattern("ixi").pattern("lll").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('x'), DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.CHESTS_WOODEN), (Ingredient)Ingredient.of((TagKey)Tags.Items.CHESTS_TRAPPED))).define(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_BELT.getId().getPath()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, TFItems.TRAVELLERS_GLOVES).pattern("s s").pattern("l l").define(Character.valueOf('l'), TFItems.TANNED_LEATHER).define(Character.valueOf('s'), Tags.Items.STRINGS).unlockedBy("has_leather", CraftingGenerator.has(TFItems.TANNED_LEATHER)).save(output, this.locEquip(TFItems.TRAVELLERS_GLOVES.getId().getPath()));
    }

    private void crackedWoodRecipes(RecipeOutput output) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.TOWERWOOD.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_TOWERWOOD.get()), (float)0.1f, (int)100).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.TOWERWOOD.get()))).save(output, TwilightForestMod.prefix("wood/smoked_cracked_towerwood").toString());
    }

    private void crackedStoneRecipes(RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.NAGASTONE_PILLAR.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_NAGASTONE_PILLAR.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.NAGASTONE_PILLAR.get()))).save(output, TwilightForestMod.prefix("nagastone/smelted_cracked_nagastone_pillar").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.ETCHED_NAGASTONE.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_ETCHED_NAGASTONE.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.ETCHED_NAGASTONE.get()))).save(output, TwilightForestMod.prefix("nagastone/smelted_cracked_etched_nagastone").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.MAZESTONE_BRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_MAZESTONE.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.MAZESTONE_BRICK.get()))).save(output, TwilightForestMod.prefix("maze_stone/smelted_maze_stone_cracked").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.CASTLE_BRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_CASTLE_BRICK.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.CASTLE_BRICK.get()))).save(output, TwilightForestMod.prefix("castleblock/smelted_cracked_castle_brick").toString());
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TFBlocks.UNDERBRICK.get()}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)TFBlocks.CRACKED_UNDERBRICK.get()), (float)0.1f, (int)200).unlockedBy("has_item", CraftingGenerator.has((ItemLike)((ItemLike)TFBlocks.UNDERBRICK.get()))).save(output, TwilightForestMod.prefix("smelted_cracked_underbrick").toString());
    }

    @SafeVarargs
    @NotNull
    private static Ingredient potionsIngredient(Holder<Potion> ... potions) {
        Ingredient[] ingredients = new Ingredient[potions.length];
        for (int i = 0; i < potions.length; ++i) {
            ingredients[i] = CraftingGenerator.potionIngredient(potions[i]);
        }
        return CompoundIngredient.of((Ingredient[])ingredients);
    }

    @NotNull
    private static Ingredient potionIngredient(@NotNull Holder<Potion> potion) {
        return DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion), (ItemLike[])new ItemLike[]{Items.POTION});
    }
}

