/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.config;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.Proxy;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.config.ConfigSetup;
import twilightforest.config.TFClientConfig;
import twilightforest.config.TFCommonConfig;
import twilightforest.network.SyncUncraftingTableConfigPacket;
import twilightforest.util.PlayerHelper;

public class TFConfig {
    public static final String CONFIG_ID = "config.twilightforest.";
    @Nullable
    private static ResourceLocation portalLockingAdvancement;
    private static final List<Holder<Biome>> VALID_AURORA_BIOMES;
    public static final List<GameProfile> GAME_PROFILES;
    public static boolean silentCicadas;
    public static boolean silentCicadasOnHead;
    public static boolean firstPersonEffects;
    public static boolean rotateTrophyHeadsGui;
    public static boolean disableOptifineNagScreen;
    public static boolean disableLockedBiomeToasts;
    public static boolean showQuestRamCrosshairIndicator;
    public static boolean showFortificationShieldIndicator;
    public static boolean showFortificationShieldIndicatorInCreative;
    private static int clientCloudBlockPrecipitationDistance;
    public static boolean prettifyOreMeterGui;
    public static boolean spawnCharmAnimationAsTotem;
    public static boolean manualTravellersWingsGradualGlideDefault;
    public static int itemDisplayXOffs;
    public static int itemDisplayYOffs;
    public static double itemDisplayScale;
    public static boolean clock24HourFormat;
    public static boolean casketUUIDLocking;
    public static boolean disableSkullCandles;
    public static boolean defaultItemEnchants;
    public static boolean bossDropChests;
    public static MultiplayerFightAdjuster multiplayerFightAdjuster;
    public static int commonCloudBlockPrecipitationDistance;
    public static boolean newPlayersSpawnInTF;
    public static boolean portalForNewPlayerSpawn;
    public static String originDimension;
    public static boolean allowPortalsInOtherDimensions;
    public static int portalCreationPermission;
    public static boolean disablePortalCreation;
    public static boolean checkPortalPlacement;
    public static boolean destructivePortalLightning;
    public static boolean shouldReturnPortalBeUsable;
    public static int maxPortalSize;
    public static double uncraftingXpCostMultiplier;
    public static double repairingXpCostMultiplier;
    public static boolean allowShapelessUncrafting;
    public static boolean disableIngredientSwitching;
    public static List<? extends String> disableUncraftingRecipes;
    public static boolean reverseRecipeBlacklist;
    public static List<? extends String> blacklistedUncraftingModIds;
    public static boolean flipUncraftingModIdList;
    public static boolean disableUncraftingOnly;
    public static boolean disableEntireTable;
    public static boolean disableTimeCore;
    public static int timeCoreRange;
    public static boolean disableTransformationCore;
    public static int transformationCoreRange;
    public static boolean disableMiningCore;
    public static int miningCoreRange;
    public static boolean disableSortingCore;
    public static int sortingCoreRange;
    public static boolean parryNonTwilightAttacks;
    public static int shieldParryTicks;

    public static int getClientCloudBlockPrecipitationDistance() {
        return clientCloudBlockPrecipitationDistance == -1 ? commonCloudBlockPrecipitationDistance : clientCloudBlockPrecipitationDistance;
    }

    @Nullable
    public static ResourceLocation getPortalLockingAdvancement(Player player) {
        if (portalLockingAdvancement == null && !((String)ConfigSetup.COMMON_CONFIG.PORTAL.portalAdvancementLock.get()).isEmpty()) {
            ResourceLocation lock = ResourceLocation.tryParse((String)((String)ConfigSetup.COMMON_CONFIG.PORTAL.portalAdvancementLock.get()));
            if (lock == null || PlayerHelper.getAdvancement(player, lock) == null) {
                TwilightForestMod.LOGGER.fatal("The portal locking advancement is not a valid advancement! Setting to null!");
                ConfigSetup.COMMON_CONFIG.PORTAL.portalAdvancementLock.set((Object)"");
            } else {
                portalLockingAdvancement = ResourceLocation.tryParse((String)((String)ConfigSetup.COMMON_CONFIG.PORTAL.portalAdvancementLock.get()));
                TwilightForestMod.LOGGER.debug("Portal locking advancement reloaded. Current advancement to check for is: {}", (Object)portalLockingAdvancement);
            }
        }
        return portalLockingAdvancement;
    }

    public static List<Holder<Biome>> getValidAuroraBiomes(RegistryAccess access) {
        if (VALID_AURORA_BIOMES.isEmpty() && !((List)ConfigSetup.CLIENT_CONFIG.auroraBiomes.get()).isEmpty()) {
            ((List)ConfigSetup.CLIENT_CONFIG.auroraBiomes.get()).forEach(s -> {
                Optional holder = Optional.ofNullable(ResourceLocation.tryParse((String)s)).flatMap(key -> access.registryOrThrow(Registries.BIOME).getHolder(key));
                if (holder.isEmpty()) {
                    TwilightForestMod.LOGGER.warn("Biome {} in Twilight Forest's validAuroraBiomes config option is not a valid biome. Skipping!", s);
                } else {
                    VALID_AURORA_BIOMES.add((Holder<Biome>)((Holder)holder.get()));
                }
            });
        }
        return VALID_AURORA_BIOMES;
    }

    protected static void rebakeCommonOptions(TFCommonConfig config) {
        casketUUIDLocking = (Boolean)config.casketUUIDLocking.get();
        disableSkullCandles = (Boolean)config.disableSkullCandles.get();
        defaultItemEnchants = (Boolean)config.defaultItemEnchants.get();
        bossDropChests = (Boolean)config.bossDropChests.get();
        commonCloudBlockPrecipitationDistance = (Integer)config.cloudBlockPrecipitationDistance.get();
        multiplayerFightAdjuster = (MultiplayerFightAdjuster)((Object)config.multiplayerFightAdjuster.get());
        newPlayersSpawnInTF = (Boolean)config.DIMENSION.newPlayersSpawnInTF.get();
        portalForNewPlayerSpawn = (Boolean)config.DIMENSION.portalForNewPlayerSpawn.get();
        originDimension = (String)config.PORTAL.originDimension.get();
        allowPortalsInOtherDimensions = (Boolean)config.PORTAL.allowPortalsInOtherDimensions.get();
        portalCreationPermission = (Integer)config.PORTAL.portalCreationPermission.get();
        disablePortalCreation = (Boolean)config.PORTAL.disablePortalCreation.get();
        checkPortalPlacement = (Boolean)config.PORTAL.checkPortalPlacement.get();
        destructivePortalLightning = (Boolean)config.PORTAL.destructivePortalLightning.get();
        shouldReturnPortalBeUsable = (Boolean)config.PORTAL.shouldReturnPortalBeUsable.get();
        maxPortalSize = (Integer)config.PORTAL.maxPortalSize.get();
        uncraftingXpCostMultiplier = (Double)config.UNCRAFTING_STUFFS.uncraftingXpCostMultiplier.get();
        repairingXpCostMultiplier = (Double)config.UNCRAFTING_STUFFS.repairingXpCostMultiplier.get();
        allowShapelessUncrafting = (Boolean)config.UNCRAFTING_STUFFS.allowShapelessUncrafting.get();
        disableIngredientSwitching = (Boolean)config.UNCRAFTING_STUFFS.disableIngredientSwitching.get();
        disableUncraftingOnly = (Boolean)config.UNCRAFTING_STUFFS.disableUncraftingOnly.get();
        disableEntireTable = (Boolean)config.UNCRAFTING_STUFFS.disableEntireTable.get();
        disableUncraftingRecipes = (List)config.UNCRAFTING_STUFFS.disableUncraftingRecipes.get();
        reverseRecipeBlacklist = (Boolean)config.UNCRAFTING_STUFFS.reverseRecipeBlacklist.get();
        blacklistedUncraftingModIds = (List)config.UNCRAFTING_STUFFS.blacklistedUncraftingModIds.get();
        flipUncraftingModIdList = (Boolean)config.UNCRAFTING_STUFFS.flipUncraftingModIdList.get();
        disableTimeCore = (Integer)config.MAGIC_TREES.timeRange.get() <= 0;
        timeCoreRange = (Integer)config.MAGIC_TREES.timeRange.get();
        disableTransformationCore = (Integer)config.MAGIC_TREES.transformationRange.get() <= 0;
        transformationCoreRange = (Integer)config.MAGIC_TREES.transformationRange.get();
        disableMiningCore = (Integer)config.MAGIC_TREES.miningRange.get() <= 0;
        miningCoreRange = (Integer)config.MAGIC_TREES.miningRange.get();
        disableSortingCore = (Integer)config.MAGIC_TREES.sortingRange.get() <= 0;
        sortingCoreRange = (Integer)config.MAGIC_TREES.sortingRange.get();
        parryNonTwilightAttacks = (Boolean)config.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get();
        shieldParryTicks = (Integer)config.SHIELD_INTERACTIONS.shieldParryTicks.get();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.isDedicatedServer()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncUncraftingTableConfigPacket(uncraftingXpCostMultiplier, repairingXpCostMultiplier, allowShapelessUncrafting, disableIngredientSwitching, disableUncraftingOnly, disableEntireTable, disableUncraftingRecipes, reverseRecipeBlacklist, blacklistedUncraftingModIds, flipUncraftingModIdList), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        portalLockingAdvancement = null;
    }

    protected static void rebakeClientOptions(TFClientConfig config) {
        TFConfig.reloadGiantSkins(config);
        VALID_AURORA_BIOMES.clear();
        silentCicadas = (Boolean)config.silentCicadas.get();
        silentCicadasOnHead = (Boolean)config.silentCicadasOnHead.get();
        firstPersonEffects = (Boolean)config.firstPersonEffects.get();
        rotateTrophyHeadsGui = (Boolean)config.rotateTrophyHeadsGui.get();
        disableOptifineNagScreen = (Boolean)config.disableOptifineNagScreen.get();
        disableLockedBiomeToasts = (Boolean)config.disableLockedBiomeToasts.get();
        showFortificationShieldIndicator = (Boolean)config.showFortificationShieldIndicator.get();
        showFortificationShieldIndicatorInCreative = (Boolean)config.showFortificationShieldIndicatorInCreative.get();
        showQuestRamCrosshairIndicator = (Boolean)config.showQuestRamCrosshairIndicator.get();
        clientCloudBlockPrecipitationDistance = (Integer)config.cloudBlockPrecipitationDistance.get();
        prettifyOreMeterGui = (Boolean)config.prettifyOreMeterGui.get();
        spawnCharmAnimationAsTotem = (Boolean)config.spawnCharmAnimationAsTotem.get();
        manualTravellersWingsGradualGlideDefault = (Boolean)config.manualTravellersWingsGradualGlide.get();
        itemDisplayXOffs = (Integer)config.ITEM_DISPLAY.screenOffsetX.get();
        itemDisplayYOffs = (Integer)config.ITEM_DISPLAY.screenOffsetY.get();
        itemDisplayScale = (Double)config.ITEM_DISPLAY.screenScale.get();
        clock24HourFormat = (Boolean)config.ITEM_DISPLAY.twentyFourHourFormat.get();
    }

    private static void reloadGiantSkins(final TFClientConfig config) {
        if (!((List)config.giantSkinUUIDs.get()).isEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    GAME_PROFILES.clear();
                    YggdrasilAuthenticationService service = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
                    MinecraftSessionService session = service.createMinecraftSessionService();
                    for (String stringUUID : (List)config.giantSkinUUIDs.get()) {
                        try {
                            ProfileResult result = session.fetchProfile(UUID.fromString(stringUUID), false);
                            if (result == null) continue;
                            GAME_PROFILES.add(result.profile());
                        }
                        catch (IllegalArgumentException e) {
                            TwilightForestMod.LOGGER.error("\"{}\" is not a valid UUID!", (Object)stringUUID);
                        }
                    }
                    super.run();
                }
            }.start();
        }
    }

    public static boolean use24HourTimeDefault() {
        try {
            String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, FormatStyle.SHORT, IsoChronology.INSTANCE, Locale.getDefault());
            return !pattern.contains("a");
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    static {
        VALID_AURORA_BIOMES = new ArrayList<Holder<Biome>>();
        GAME_PROFILES = new ArrayList<GameProfile>();
        silentCicadas = false;
        silentCicadasOnHead = false;
        firstPersonEffects = true;
        rotateTrophyHeadsGui = true;
        disableOptifineNagScreen = false;
        disableLockedBiomeToasts = false;
        showQuestRamCrosshairIndicator = true;
        showFortificationShieldIndicator = true;
        showFortificationShieldIndicatorInCreative = false;
        clientCloudBlockPrecipitationDistance = 32;
        prettifyOreMeterGui = true;
        spawnCharmAnimationAsTotem = false;
        manualTravellersWingsGradualGlideDefault = true;
        itemDisplayXOffs = 4;
        itemDisplayYOffs = 4;
        itemDisplayScale = 1.0;
        clock24HourFormat = TFConfig.use24HourTimeDefault();
        casketUUIDLocking = false;
        disableSkullCandles = false;
        defaultItemEnchants = true;
        bossDropChests = true;
        multiplayerFightAdjuster = MultiplayerFightAdjuster.NONE;
        commonCloudBlockPrecipitationDistance = 32;
        newPlayersSpawnInTF = false;
        portalForNewPlayerSpawn = true;
        originDimension = Level.OVERWORLD.location().toString();
        allowPortalsInOtherDimensions = false;
        portalCreationPermission = 0;
        disablePortalCreation = false;
        checkPortalPlacement = true;
        destructivePortalLightning = true;
        shouldReturnPortalBeUsable = true;
        maxPortalSize = 64;
        uncraftingXpCostMultiplier = 1.0;
        repairingXpCostMultiplier = 1.0;
        allowShapelessUncrafting = false;
        disableIngredientSwitching = false;
        disableUncraftingRecipes = new ArrayList<String>();
        reverseRecipeBlacklist = false;
        blacklistedUncraftingModIds = new ArrayList<String>();
        flipUncraftingModIdList = false;
        disableUncraftingOnly = false;
        disableEntireTable = false;
        disableTimeCore = false;
        timeCoreRange = 16;
        disableTransformationCore = false;
        transformationCoreRange = 16;
        disableMiningCore = false;
        miningCoreRange = 16;
        disableSortingCore = false;
        sortingCoreRange = 16;
        parryNonTwilightAttacks = false;
        shieldParryTicks = 40;
    }

    public static enum MultiplayerFightAdjuster implements TranslatableEnum
    {
        NONE(false, false),
        MORE_LOOT(true, false),
        MORE_HEALTH(false, true),
        MORE_LOOT_AND_HEALTH(true, true);

        private final boolean moreLoot;
        private final boolean moreHealth;

        private MultiplayerFightAdjuster(boolean loot, boolean health) {
            this.moreLoot = loot;
            this.moreHealth = health;
        }

        public boolean adjustsLootRolls() {
            return this.moreLoot;
        }

        public boolean adjustsHealth() {
            return this.moreHealth;
        }

        public Component getTranslatedName() {
            return Component.translatable((String)("config.twilightforest.multiplayer_fight_adjuster." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

