/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.fml.loading.FMLLoader;
import twilightforest.beanification.Component;
import twilightforest.events.EntityEvents;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.util.LandmarkStructure;

@Component
public class InfoCommand {
    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(cs -> cs.hasPermission(2))).executes(this::run);
    }

    private int run(CommandContext<CommandSourceStack> ctx) {
        Structure structure;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        Optional possibleStructureRegistry = level.registryAccess().registry(Registries.STRUCTURE);
        Optional<StructureStart> possibleNearLandmark = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)level, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (possibleStructureRegistry.isEmpty() || possibleNearLandmark.isEmpty() || !((structure = possibleNearLandmark.get().getStructure()) instanceof LandmarkStructure)) {
            return 0;
        }
        LandmarkStructure landmarkStructure = (LandmarkStructure)structure;
        StructureStart structureStart = possibleNearLandmark.get();
        ResourceLocation key = ((Registry)possibleStructureRegistry.get()).getKey((Object)landmarkStructure);
        if (FMLLoader.isProduction()) {
            source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.info.wip").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
        }
        String structureName = net.minecraft.network.chat.Component.translatable((String)("structure." + key.getNamespace() + "." + key.getPath())).getString();
        source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.nearest", (Object[])new Object[]{structureName}), false);
        BoundingBox boundingBox = structureStart.getBoundingBox();
        StringJoiner boxInfo = new StringJoiner(", ", "[", "]");
        boxInfo.add("" + boundingBox.minX());
        boxInfo.add("" + boundingBox.minY());
        boxInfo.add("" + boundingBox.minZ());
        boxInfo.add("" + boundingBox.maxX());
        boxInfo.add("" + boundingBox.maxY());
        boxInfo.add("" + boundingBox.maxZ());
        source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.boundaries", (Object[])new Object[]{boxInfo}), false);
        if (boundingBox.isInside((Vec3i)pos)) {
            source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.inside").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GREEN}), false);
            if (structureStart instanceof TFStructureStart) {
                TFStructureStart tfStructureStart = (TFStructureStart)structureStart;
                source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.conquer.status", (Object[])new Object[]{tfStructureStart.isConquered()}).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, tfStructureStart.isConquered() ? ChatFormatting.GREEN : ChatFormatting.RED}), false);
            }
            List<MobSpawnSettings.SpawnerData> spawnList = EntityEvents.gatherPotentialSpawns(level.structureManager(), MobCategory.MONSTER, pos);
            source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.spawn_list").withStyle(ChatFormatting.UNDERLINE), false);
            if (spawnList != null) {
                for (MobSpawnSettings.SpawnerData entry : spawnList) {
                    source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.spawn_info", (Object[])new Object[]{entry.type.getDescription().getString(), entry.getWeight().asInt()}), false);
                }
            }
        } else {
            source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.outside").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), false);
        }
        return 1;
    }
}

