/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import twilightforest.beanification.Component;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.world.components.structures.start.TFStructureStart;

@Component
public class ConquerCommand {
    private final SimpleCommandExceptionType NOT_IN_STRUCTURE = new SimpleCommandExceptionType((Message)net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.required"));

    public LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder conquer = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"conquer").requires(cs -> cs.hasPermission(2))).executes(ctx -> this.changeStructureActivity((CommandSourceStack)ctx.getSource(), true));
        LiteralArgumentBuilder reactivate = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reactivate").requires(cs -> cs.hasPermission(2))).executes(ctx -> this.changeStructureActivity((CommandSourceStack)ctx.getSource(), false));
        return (LiteralArgumentBuilder)conquer.then((ArgumentBuilder)reactivate);
    }

    private int changeStructureActivity(CommandSourceStack source, boolean flag) throws CommandSyntaxException {
        StructureStart structureStart;
        BlockPos pos = BlockPos.containing((Position)source.getPosition());
        Optional<StructureStart> struct = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)source.getLevel(), SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (!(struct.isPresent() && struct.get().getBoundingBox().isInside((Vec3i)pos) && (structureStart = struct.get()) instanceof TFStructureStart)) {
            throw this.NOT_IN_STRUCTURE.create();
        }
        TFStructureStart TFStructureStart2 = (TFStructureStart)structureStart;
        source.sendSuccess(() -> net.minecraft.network.chat.Component.translatable((String)"commands.tffeature.structure.conquer.update", (Object[])new Object[]{TFStructureStart2.isConquered(), flag}), true);
        TFStructureStart2.setConquered(flag, (LevelAccessor)source.getLevel());
        return 1;
    }
}

