/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomTextureParticle
extends TextureSheetParticle {
    private final boolean fullBright;
    private final float uo;
    private final float vo;

    protected CustomTextureParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, boolean fullBright) {
        this(level, x, y, z, fullBright);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += xSpeed;
        this.yd += ySpeed;
        this.zd += zSpeed;
    }

    protected CustomTextureParticle(ClientLevel level, double x, double y, double z, boolean fullBright) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.fullBright = fullBright;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        return this.fullBright ? 0xF000F0 : super.getLightColor(partialTick);
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ShieldBreak(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomTextureParticle particle = new CustomTextureParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, true);
            particle.pickSprite(this.sprite);
            particle.scale(0.75f);
            particle.gravity = 0.0f;
            particle.lifetime = (int)(8.0f / (particle.random.nextFloat() * 0.5f + 0.5f) * 0.5f);
            if (particle.lifetime <= 1) {
                particle.lifetime = 2;
            }
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Factory(SpriteSet sprite, boolean fullBright) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomTextureParticle particle = new CustomTextureParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.fullBright);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

