/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.overlay;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import twilightforest.client.overlay.display.ItemDisplay;
import twilightforest.components.item.ItemDisplayContents;
import twilightforest.config.TFConfig;
import twilightforest.init.TFDataComponents;
import twilightforest.init.custom.ItemDisplays;
import twilightforest.init.custom.TravellersModifiersManager;
import twilightforest.item.travellers_gear.modifiers.display.ItemDisplayType;

public class ItemDisplayOverlay {
    public static void render(GuiGraphics graphics, Minecraft minecraft, Window window, Gui gui, Player player) {
        if (player == null || gui.getDebugOverlay().showDebugScreen() || minecraft.options.hideGui) {
            return;
        }
        ItemStack goggles = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!TravellersModifiersManager.isModifierActive((Entity)player, goggles, TravellersModifiersManager.ITEM_DISPLAY_MODIFIER)) {
            return;
        }
        ItemDisplayContents contents = (ItemDisplayContents)goggles.get(TFDataComponents.ITEM_DISPLAY);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        ArrayList<DisplayHolder> typesToRender = new ArrayList<DisplayHolder>();
        int widest = ItemDisplayOverlay.fillDisplayHolders(typesToRender, contents, minecraft, gui, player);
        if (typesToRender.isEmpty()) {
            return;
        }
        ItemDisplayOverlay.renderHolders(graphics, minecraft, gui, player, typesToRender, widest);
    }

    private static void renderHolders(GuiGraphics graphics, Minecraft minecraft, Gui gui, Player player, List<DisplayHolder> typesToRender, int widest) {
        graphics.pose().pushPose();
        graphics.pose().translate((double)TFConfig.itemDisplayXOffs, (double)TFConfig.itemDisplayYOffs, 0.0);
        graphics.pose().scale((float)TFConfig.itemDisplayScale, (float)TFConfig.itemDisplayScale, (float)TFConfig.itemDisplayScale);
        typesToRender.sort(Comparator.comparing(holder -> holder.display().displayPosition()));
        for (DisplayHolder holder2 : typesToRender) {
            graphics.pose().pushPose();
            holder2.display().render(holder2.stack(), graphics, minecraft, gui, player, widest);
            graphics.pose().popPose();
            graphics.pose().translate(0.0f, (float)holder2.bounds().height(), 0.0f);
        }
        graphics.pose().popPose();
    }

    private static int fillDisplayHolders(List<DisplayHolder> typesToRender, ItemDisplayContents contents, Minecraft minecraft, Gui gui, Player player) {
        int widest = 0;
        NonNullList<ItemStack> items = contents.items();
        int slots = Math.min(ItemDisplayContents.LAYOUT.size(), items.size());
        int activeMapSlot = contents.findActiveMapSlot();
        for (int i = 0; i < slots; ++i) {
            ItemDisplayType type;
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty() || (type = (ItemDisplayType)ItemDisplayContents.LAYOUT.get(i).get()) == ItemDisplays.MAP.get() && i != activeMapSlot || !((ItemDisplayType)ItemDisplayContents.LAYOUT.get(i).get()).validItems().test(stack)) continue;
            ItemDisplay display = type.display().get();
            ItemDisplay.Bounds bounds = display.getWidgetSize(stack, minecraft, gui, player, widest);
            widest = Math.max(widest, bounds.width());
            typesToRender.add(new DisplayHolder(stack, display, bounds));
        }
        return widest;
    }

    public record DisplayHolder(ItemStack stack, ItemDisplay display, ItemDisplay.Bounds bounds) {
    }
}

