/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.HelmetCrab;

public class HelmetCrabModel
extends HierarchicalModel<HelmetCrab> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftClaw;
    private final ModelPart rightClaw;
    private final ModelPart rightLeg1;
    private final ModelPart rightLeg2;
    private final ModelPart leftLeg1;
    private final ModelPart leftLeg2;

    public HelmetCrabModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.rightClaw = root.getChild("right_claw");
        this.leftClaw = root.getChild("left_claw");
        this.rightLeg1 = root.getChild("right_leg_1");
        this.rightLeg2 = root.getChild("right_leg_2");
        this.leftLeg1 = root.getChild("left_leg_1");
        this.leftLeg2 = root.getChild("left_leg_2");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? HelmetCrabModel.createJappaModel() : HelmetCrabModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 4).addBox(-2.5f, -2.5f, -5.0f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        body.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-4.0f, (float)0.7853982f, (float)0.0f, (float)-0.7853982f));
        body.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-4.0f, (float)0.7853982f, (float)0.0f, (float)0.7853982f));
        PartDefinition helmetBase = partdefinition.addOrReplaceChild("helmet_base", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)0.0f, (float)-1.7453293f, (float)-0.5235988f, (float)0.0f));
        helmetBase.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 14).addBox(-3.5f, -11.0f, -3.5f, 7.0f, 11.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition rightHorn = helmetBase.addOrReplaceChild("right_horn_1", CubeListBuilder.create().texOffs(28, 14).addBox(-6.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.17453292f));
        rightHorn.addOrReplaceChild("right_horn_2", CubeListBuilder.create().texOffs(28, 20).addBox(-3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.17453292f));
        PartDefinition leftHorn = helmetBase.addOrReplaceChild("left_horn_1", CubeListBuilder.create().mirror().texOffs(28, 14).addBox(-1.0f, -1.5f, -1.5f, 7.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)3.5f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)-0.17453292f));
        leftHorn.addOrReplaceChild("left_horn_2", CubeListBuilder.create().texOffs(28, 20).addBox(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)-0.17453292f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_claw", CubeListBuilder.create().texOffs(38, 0).addBox(-7.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)-3.0f, (float)0.0f, (float)-1.319531f, (float)-0.1919862f));
        PartDefinition clawBase = rightArm.addOrReplaceChild("claw_base", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.5f, -1.0f, 3.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        clawBase.addOrReplaceChild("claw_bottom", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, -0.5f, -1.0f, 3.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2602503f));
        clawBase.addOrReplaceChild("claw_top", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -0.5f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1858931f));
        partdefinition.addOrReplaceChild("left_claw", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)-3.0f, (float)0.0f, (float)0.5759587f, (float)0.1919862f));
        partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create().texOffs(18, 0).addBox(-7.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)0.2792527f, (float)-0.1919862f));
        partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)-0.2792527f, (float)0.1919862f));
        partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create().texOffs(18, 0).addBox(-7.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)-0.2792527f, (float)-0.1919862f));
        partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)3.0f, (float)20.0f, (float)-2.0f, (float)0.0f, (float)0.2792527f, (float)0.1919862f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-2.5f, -4.0f, -2.5f, 5.0f, 4.0f, 5.0f).texOffs(58, 0).addBox(-1.5f, -5.0f, -3.5f, 1.0f, 2.0f, 1.0f).texOffs(58, 3).addBox(0.5f, -5.0f, -3.5f, 1.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition helmet = body.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -8.0f, -4.0f, 6.0f, 8.0f, 6.0f).texOffs(16, 0).addBox(-4.0f, -8.0f, -4.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.5f, (float)-1.3089969f, (float)-0.2617994f, (float)0.7463028f));
        helmet.addOrReplaceChild("horns", CubeListBuilder.create().texOffs(18, 23).addBox(-11.5f, -12.0f, -0.67f, 23.0f, 9.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_claw", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, -5.0f, 2.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)-2.0f, (float)0.0f, (float)0.3926991f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_claw", CubeListBuilder.create().texOffs(0, 23).addBox(-1.0f, -3.0f, -5.0f, 2.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)-2.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create().texOffs(32, 15).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)0.0f, (float)0.21816616f, (float)0.43633232f, (float)-0.43633232f));
        partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create().texOffs(48, 19).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)0.0f, (float)0.21816616f, (float)-0.43633232f, (float)0.43633232f));
        partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create().texOffs(32, 19).addBox(-6.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)-1.5f, (float)0.21816616f, (float)0.0f, (float)-0.43633232f));
        partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create().texOffs(48, 15).addBox(0.0f, -1.0f, -1.0f, 6.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)-1.5f, (float)0.21816616f, (float)0.0f, (float)0.43633232f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(HelmetCrab entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.body.xRot = headPitch * ((float)Math.PI / 180);
        float f6 = 0.7853982f;
        this.rightLeg1.zRot = -f6 * 0.74f;
        this.leftLeg1.zRot = f6 * 0.74f;
        this.rightLeg2.zRot = -f6 * 0.74f;
        this.leftLeg2.zRot = f6 * 0.74f;
        float f7 = -0.0f;
        float f8 = 0.3926991f;
        this.rightLeg1.yRot = f8 + f7;
        this.leftLeg1.yRot = -f8 - f7;
        this.rightLeg2.yRot = -f8 + f7;
        this.leftLeg2.yRot = f8 - f7;
        float f10 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f11 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f12 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f14 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f15 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f16 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.rightLeg1.yRot += f10;
        this.leftLeg1.yRot -= f10;
        this.rightLeg2.yRot += f11;
        this.leftLeg2.yRot -= f11;
        this.rightLeg1.zRot += f14;
        this.leftLeg1.zRot -= f14;
        this.rightLeg2.zRot += f15;
        this.leftLeg2.zRot -= f15;
        if (JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            this.rightClaw.yRot = 0.319531f;
            this.rightClaw.yRot += Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / 2.0f;
            this.leftClaw.yRot = -0.319531f;
            this.leftClaw.yRot += -(Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f) / 2.0f;
        } else {
            this.rightClaw.yRot = -1.319531f;
            this.rightClaw.yRot += Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftClaw.zRot = f6;
            this.leftClaw.yRot = f8 * 2.0f - f7;
            this.leftClaw.yRot -= f12;
            this.leftClaw.zRot -= f16;
        }
    }
}

