/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity.spawner;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IOwnedSpawner;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.spawner.SinisterSpawnerBlockEntity;
import twilightforest.init.TFBlocks;
import twilightforest.util.BoundingBoxUtils;

public abstract class SinisterSpawnerLogic
extends BaseSpawner {
    private static final Codec<List<ParticleOptions>> PARTICLES_CODEC = ParticleTypes.CODEC.listOf();
    @Nullable
    private BlockPos.MutableBlockPos checkPos = null;
    private final List<BlockPos> spawnBuffer = new ArrayList<BlockPos>();
    private int countNextToSpawn = 0;
    public int entityScanRange = 4;
    private Set<ParticleOptions> particleOptions = new HashSet<ParticleOptions>();

    public void setChanged() {
        Either owner = this.getOwner();
        if (owner != null) {
            owner.ifLeft(blockEntity -> {
                blockEntity.setChanged();
                if (blockEntity instanceof SinisterSpawnerBlockEntity) {
                    SinisterSpawnerBlockEntity sinisterSpawnerBlockEntity = (SinisterSpawnerBlockEntity)((Object)blockEntity);
                    sinisterSpawnerBlockEntity.sendChanges();
                }
            });
        }
    }

    public boolean setParticles(Collection<ParticleOptions> particleOptions, boolean sendUpdate) {
        this.particleOptions.clear();
        boolean changed = this.particleOptions.addAll(particleOptions);
        if (sendUpdate && changed) {
            this.setChanged();
        }
        return changed;
    }

    public boolean addParticle(ParticleOptions particle, boolean sendUpdate) {
        boolean changed = this.particleOptions.add(particle);
        if (sendUpdate && changed) {
            this.setChanged();
        }
        return changed;
    }

    public boolean removeParticle(ParticleOptions particle, boolean sendUpdate) {
        boolean changed = this.particleOptions.remove(particle);
        if (sendUpdate && changed) {
            this.setChanged();
        }
        return changed;
    }

    public void clientTick(Level level, BlockPos pos) {
        if (!this.isNearPlayer(level, pos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = level.getRandom();
            double pX = (double)pos.getX() + randomsource.nextDouble();
            double pY = (double)pos.getY() + randomsource.nextDouble();
            double pZ = (double)pos.getZ() + randomsource.nextDouble();
            for (ParticleOptions particleOptions : this.particleOptions) {
                level.addParticle(particleOptions, pX, pY, pZ, 0.0, 0.0, 0.0);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel serverLevel, BlockPos blockEntityPos) {
        if (this.isNearPlayer((Level)serverLevel, blockEntityPos)) {
            if (this.countNextToSpawn < 1) {
                this.countNextToSpawn = serverLevel.getRandom().nextInt(1 + Math.max(0, this.spawnCount));
            }
            if (this.spawnDelay <= -1) {
                this.delay((Level)serverLevel, blockEntityPos);
            }
            this.scanSpawnPositions(serverLevel, blockEntityPos, serverLevel.getRandom());
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else if (!this.spawnBuffer.isEmpty()) {
                boolean spawned = false;
                RandomSource randomsource = serverLevel.getRandom();
                SpawnData spawndata = this.getOrCreateNextSpawnData((Level)serverLevel, randomsource, blockEntityPos);
                for (BlockPos spawnAt : this.spawnBuffer) {
                    SpawnData.CustomSpawnRules spawndata$customspawnrules;
                    CompoundTag entityData = spawndata.getEntityToSpawn();
                    Optional possibleEntityType = EntityType.by((CompoundTag)entityData);
                    if (possibleEntityType.isEmpty()) {
                        this.delay((Level)serverLevel, blockEntityPos);
                        return;
                    }
                    double spawnX = (double)spawnAt.getX() + 0.5;
                    double spawnY = spawnAt.getY();
                    double spawnZ = (double)spawnAt.getZ() + 0.5;
                    if (!serverLevel.noCollision(((EntityType)possibleEntityType.get()).getSpawnAABB(spawnX, spawnY, spawnZ)) || (!spawndata.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules((EntityType)((EntityType)possibleEntityType.get()), (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)spawnAt, (RandomSource)serverLevel.getRandom()) : !((EntityType)possibleEntityType.get()).getCategory().isFriendly() && serverLevel.getDifficulty() == Difficulty.PEACEFUL || !(spawndata$customspawnrules = (SpawnData.CustomSpawnRules)spawndata.getCustomSpawnRules().get()).isValidPosition(spawnAt, serverLevel))) continue;
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)entityData, (Level)serverLevel, spawnedEntity -> {
                        spawnedEntity.moveTo(spawnX, spawnY, spawnZ, spawnedEntity.getYRot(), spawnedEntity.getXRot());
                        return spawnedEntity;
                    });
                    if (entity == null) {
                        this.delay((Level)serverLevel, blockEntityPos);
                        return;
                    }
                    int likeEntities = serverLevel.getEntities(EntityTypeTest.forExactClass(entity.getClass()), new AABB((double)blockEntityPos.getX(), (double)blockEntityPos.getY(), (double)blockEntityPos.getZ(), (double)(blockEntityPos.getX() + 1), (double)(blockEntityPos.getY() + 1), (double)(blockEntityPos.getZ() + 1)).inflate((double)this.entityScanRange), EntitySelector.NO_SPECTATORS).size();
                    if (likeEntities >= this.maxNearbyEntities) {
                        this.delay((Level)serverLevel, blockEntityPos);
                        return;
                    }
                    entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), randomsource.nextFloat() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        if (!EventHooks.checkSpawnPositionSpawner((Mob)mob, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.SPAWNER, (SpawnData)spawndata, (BaseSpawner)this)) continue;
                        boolean flag1 = spawndata.getEntityToSpawn().size() == 1 && spawndata.getEntityToSpawn().contains("id", 8);
                        EventHooks.finalizeMobSpawnSpawner((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, (IOwnedSpawner)this, (boolean)flag1);
                        spawndata.getEquipment().ifPresent(arg_0 -> ((Mob)mob).equip(arg_0));
                        this.checkPos = blockEntityPos.mutable();
                    }
                    if (!serverLevel.tryAddFreshEntityWithPassengers(entity)) {
                        this.delay((Level)serverLevel, blockEntityPos);
                        return;
                    }
                    for (ParticleOptions particle : this.particleOptions) {
                        serverLevel.sendParticles(particle, entity.getX(), entity.getY(0.5), entity.getZ(), 10, (double)(entity.getBbWidth() * 0.5f), (double)(entity.getBbHeight() * 0.5f), (double)(entity.getBbWidth() * 0.5f), 0.0);
                    }
                    serverLevel.gameEvent(entity, (Holder)GameEvent.ENTITY_PLACE, spawnAt);
                    if (entity instanceof Mob) {
                        ((Mob)entity).spawnAnim();
                    }
                    spawned = true;
                }
                this.spawnBuffer.clear();
                if (spawned) {
                    for (ParticleOptions particle : this.particleOptions) {
                        serverLevel.sendParticles(particle, (double)((float)blockEntityPos.getX() + 0.5f), (double)((float)blockEntityPos.getY() + 0.5f), (double)((float)blockEntityPos.getZ() + 0.5f), 10, 1.0, 1.0, 1.0, 0.0);
                    }
                    this.delay((Level)serverLevel, blockEntityPos);
                }
            } else if (this.spawnDelay == 0) {
                --this.spawnDelay;
            }
        }
    }

    private void scanSpawnPositions(ServerLevel serverLevel, BlockPos blockEntityPos, RandomSource random) {
        BlockState blockBelow;
        if (this.spawnBuffer.size() >= this.countNextToSpawn) {
            return;
        }
        if (this.checkPos == null || !BoundingBoxUtils.isPosWithinBox(blockEntityPos, this.checkPos, this.spawnRange)) {
            BlockPos.MutableBlockPos posBelow = blockEntityPos.mutable().move(Direction.DOWN);
            this.checkPos = serverLevel.getBlockState((BlockPos)posBelow).isAir() ? posBelow : posBelow.move(Direction.UP, 2);
        }
        if ((blockBelow = serverLevel.getBlockState(this.checkPos.below())).isAir()) {
            this.checkPos.move(Direction.DOWN);
        } else {
            Direction randomDirection;
            if ((blockBelow.isSolid() || blockBelow.is((Block)TFBlocks.CORONATION_CARPET.get())) && random.nextBoolean() && !this.spawnBuffer.contains(this.checkPos) && serverLevel.getBlockState((BlockPos)this.checkPos).isAir()) {
                this.spawnBuffer.add(this.checkPos.immutable());
            }
            if (!serverLevel.getBlockState(this.checkPos.relative(randomDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random))).isSolid()) {
                this.checkPos.move(randomDirection);
            } else {
                this.checkPos = null;
            }
        }
    }

    private void debugSeePosition(ServerLevel serverLevel) {
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (double)this.checkPos.getX() + 0.5, (double)this.checkPos.getY() + 0.5, (double)this.checkPos.getZ() + 0.5, 3, 0.1, 0.1, 0.1, (double)0.05f);
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
        super.load(level, pos, tag);
        this.particleOptions.clear();
        DataResult particleOptions = PARTICLES_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("ParticleOptions"));
        if (particleOptions.isSuccess()) {
            this.particleOptions.addAll((Collection)particleOptions.getPartialOrThrow());
        }
        this.entityScanRange = tag.contains("EntityScanRange") ? tag.getInt("EntityScanRange") : this.spawnRange;
    }

    public CompoundTag save(CompoundTag tag) {
        CompoundTag saved = super.save(tag);
        DataResult encoded = PARTICLES_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, List.copyOf(this.particleOptions));
        if (encoded.isSuccess()) {
            saved.put("ParticleOptions", (Tag)encoded.getPartialOrThrow());
        }
        tag.putInt("EntityScanRange", this.entityScanRange);
        return saved;
    }

    public void broadcastEvent(Level level, BlockPos pos, int eventId) {
        level.blockEvent(pos, (Block)TFBlocks.SINISTER_SPAWNER.value(), eventId, 0);
    }

    public void setNextSpawnData(@Nullable Level level, BlockPos pos, SpawnData nextSpawnData) {
        super.setNextSpawnData(level, pos, nextSpawnData);
        if (level != null) {
            BlockState blockstate = level.getBlockState(pos);
            level.sendBlockUpdated(pos, blockstate, blockstate, 4);
        }
    }
}

