/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WroughtIronFenceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PostState> POST = EnumProperty.create((String)"post", PostState.class);
    public static final EnumProperty<FenceSide> EAST_FENCE = EnumProperty.create((String)"east_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> NORTH_FENCE = EnumProperty.create((String)"north_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> SOUTH_FENCE = EnumProperty.create((String)"south_fence", FenceSide.class);
    public static final EnumProperty<FenceSide> WEST_FENCE = EnumProperty.create((String)"west_fence", FenceSide.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape FINIAL_HEAD_SHAPE = Block.box((double)6.5, (double)17.0, (double)6.5, (double)9.5, (double)20.0, (double)9.5);
    private static final VoxelShape FINIAL_NECK_SHAPE = Block.box((double)7.5, (double)16.0, (double)7.5, (double)8.5, (double)17.0, (double)8.5);
    private static final VoxelShape FINIAL_SHAPE = Shapes.or((VoxelShape)FINIAL_HEAD_SHAPE, (VoxelShape)FINIAL_NECK_SHAPE);
    private static final VoxelShape POST_SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)7.0, (double)0.0, (double)8.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)8.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)8.0, (double)16.0, (double)9.0);

    public WroughtIronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(POST, (Comparable)((Object)PostState.POST))).setValue(EAST_FENCE, (Comparable)((Object)FenceSide.NONE))).setValue(NORTH_FENCE, (Comparable)((Object)FenceSide.NONE))).setValue(SOUTH_FENCE, (Comparable)((Object)FenceSide.NONE))).setValue(WEST_FENCE, (Comparable)((Object)FenceSide.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static boolean isConnected(BlockState state, Property<FenceSide> side) {
        return state.getValue(side) != FenceSide.NONE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape finalShape = Shapes.empty();
        if (state.getValue(POST) != PostState.NONE) {
            finalShape = POST_SHAPE;
            if (state.getValue(POST) == PostState.CAPPED) {
                finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)FINIAL_SHAPE);
            }
        }
        if (state.getValue(NORTH_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)NORTH_SHAPE);
        }
        if (state.getValue(SOUTH_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (state.getValue(WEST_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)WEST_SHAPE);
        }
        if (state.getValue(EAST_FENCE) != FenceSide.NONE) {
            finalShape = Shapes.or((VoxelShape)finalShape, (VoxelShape)EAST_SHAPE);
        }
        if (finalShape.isEmpty()) {
            finalShape = Shapes.block();
        }
        return finalShape;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"block.twilightforest.wrought_iron_fence.cap").withStyle(ChatFormatting.GRAY));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState north = level.getBlockState(pos.north());
        BlockState east = level.getBlockState(pos.east());
        BlockState south = level.getBlockState(pos.south());
        BlockState west = level.getBlockState(pos.west());
        BlockState above = level.getBlockState(pos.above());
        boolean northFace = this.connectsTo(north, north.isFaceSturdy((BlockGetter)level, pos.north(), Direction.SOUTH));
        boolean eastFace = this.connectsTo(east, east.isFaceSturdy((BlockGetter)level, pos.east(), Direction.WEST));
        boolean southFace = this.connectsTo(south, south.isFaceSturdy((BlockGetter)level, pos.south(), Direction.NORTH));
        boolean westFace = this.connectsTo(west, west.isFaceSturdy((BlockGetter)level, pos.west(), Direction.EAST));
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        return this.fenceShape((LevelReader)level, state, pos.above(), northFace, eastFace, southFace, westFace);
    }

    private boolean connectsTo(BlockState state, boolean solid) {
        return state.is(BlockTags.WALLS) || !WroughtIronFenceBlock.isExceptionForConnection((BlockState)state) && solid || state.getBlock() instanceof IronBarsBlock;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis() == Direction.Axis.Y ? this.updateTop((LevelReader)level, state, pos) : this.updateSide((LevelReader)level, pos, state, neighborPos, neighbor, direction);
    }

    private BlockState updateSide(LevelReader level, BlockPos pos, BlockState firstState, BlockPos secondPos, BlockState secondState, Direction direction) {
        Direction opposite = direction.getOpposite();
        boolean north = direction == Direction.NORTH ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, NORTH_FENCE);
        boolean east = direction == Direction.EAST ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, EAST_FENCE);
        boolean south = direction == Direction.SOUTH ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, SOUTH_FENCE);
        boolean west = direction == Direction.WEST ? this.connectsTo(secondState, secondState.isFaceSturdy((BlockGetter)level, secondPos, opposite)) : WroughtIronFenceBlock.isConnected(firstState, WEST_FENCE);
        return this.fenceShape(level, firstState, pos, north, east, south, west);
    }

    private BlockState updateTop(LevelReader level, BlockState state, BlockPos pos) {
        boolean north = WroughtIronFenceBlock.isConnected(state, NORTH_FENCE);
        boolean east = WroughtIronFenceBlock.isConnected(state, EAST_FENCE);
        boolean south = WroughtIronFenceBlock.isConnected(state, SOUTH_FENCE);
        boolean west = WroughtIronFenceBlock.isConnected(state, WEST_FENCE);
        return this.fenceShape(level, state, pos, north, east, south, west);
    }

    private BlockState fenceShape(LevelReader level, BlockState state, BlockPos pos, boolean north, boolean east, boolean south, boolean west) {
        BlockState blockstate = this.updateSides(level, state, pos, north, east, south, west);
        return (BlockState)blockstate.setValue(POST, (Comparable)((Object)WroughtIronFenceBlock.makePost(level, blockstate, pos, true)));
    }

    private BlockState updateSides(LevelReader level, BlockState state, BlockPos pos, boolean north, boolean east, boolean south, boolean west) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_FENCE, (Comparable)((Object)(north ? this.makeFenceState(Direction.NORTH, level, pos) : FenceSide.NONE)))).setValue(EAST_FENCE, (Comparable)((Object)(east ? this.makeFenceState(Direction.EAST, level, pos) : FenceSide.NONE)))).setValue(SOUTH_FENCE, (Comparable)((Object)(south ? this.makeFenceState(Direction.SOUTH, level, pos) : FenceSide.NONE)))).setValue(WEST_FENCE, (Comparable)((Object)(west ? this.makeFenceState(Direction.WEST, level, pos) : FenceSide.NONE)));
    }

    private FenceSide makeFenceState(Direction direction, LevelReader level, BlockPos pos) {
        boolean below;
        BlockPos up = pos.above();
        BlockState upState = level.getBlockState(up.relative(direction));
        BlockPos down = pos.below();
        BlockState downState = level.getBlockState(down.relative(direction));
        boolean above = level.getBlockState(up).is((Block)this) && (upState.is((Block)this) || this.connectsTo(upState, upState.isFaceSturdy((BlockGetter)level, up.relative(direction), direction.getOpposite())));
        boolean bl = below = level.getBlockState(down).is((Block)this) && (downState.is((Block)this) || this.connectsTo(downState, downState.isFaceSturdy((BlockGetter)level, down.relative(direction), direction.getOpposite())));
        if (above && below) {
            return FenceSide.MIDDLE;
        }
        if (!above && below) {
            return FenceSide.TOP;
        }
        if (above) {
            return FenceSide.BOTTOM;
        }
        return FenceSide.FULL;
    }

    public static PostState makePost(LevelReader level, BlockState state, BlockPos pos, boolean allowCap) {
        BlockState above = level.getBlockState(pos.above());
        boolean shouldAnyBePost = WroughtIronFenceBlock.shouldAnyBePost(level, state, pos);
        if (allowCap && state.getValue(POST) == PostState.CAPPED && above.canBeReplaced()) {
            return PostState.CAPPED;
        }
        if (shouldAnyBePost) {
            return PostState.POST;
        }
        return WroughtIronFenceBlock.shouldBePost(state) ? PostState.POST : PostState.NONE;
    }

    private static boolean shouldAnyBePost(LevelReader level, BlockState state, BlockPos pos) {
        BlockState checkState;
        BlockPos.MutableBlockPos mutable = pos.above().mutable();
        while ((checkState = level.getBlockState((BlockPos)mutable)).is(state.getBlock())) {
            mutable.move(Direction.UP);
            if (!WroughtIronFenceBlock.shouldBePost(checkState) && checkState.getValue(POST) != PostState.CAPPED) continue;
            return true;
        }
        mutable.set((Vec3i)pos.below());
        while ((checkState = level.getBlockState((BlockPos)mutable)).is(state.getBlock())) {
            mutable.move(Direction.DOWN);
            if (!WroughtIronFenceBlock.shouldBePost(checkState)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldBePost(BlockState state) {
        FenceSide nSide = (FenceSide)((Object)state.getValue(NORTH_FENCE));
        FenceSide sSide = (FenceSide)((Object)state.getValue(SOUTH_FENCE));
        FenceSide eSide = (FenceSide)((Object)state.getValue(EAST_FENCE));
        FenceSide wSide = (FenceSide)((Object)state.getValue(WEST_FENCE));
        boolean north = nSide == FenceSide.NONE;
        boolean south = sSide == FenceSide.NONE;
        boolean east = eSide == FenceSide.NONE;
        boolean west = wSide == FenceSide.NONE;
        return north && south && east && west || north != south || east != west || !north && !east;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(SOUTH_FENCE)))))).setValue(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(WEST_FENCE)))))).setValue(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(NORTH_FENCE)))))).setValue(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(EAST_FENCE)))));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(EAST_FENCE)))))).setValue(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(SOUTH_FENCE)))))).setValue(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(WEST_FENCE)))))).setValue(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(NORTH_FENCE)))));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(WEST_FENCE)))))).setValue(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(NORTH_FENCE)))))).setValue(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(EAST_FENCE)))))).setValue(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(SOUTH_FENCE)))));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(SOUTH_FENCE)))))).setValue(SOUTH_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(NORTH_FENCE)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(WEST_FENCE)))))).setValue(WEST_FENCE, (Comparable)((Object)((FenceSide)((Object)state.getValue(EAST_FENCE)))));
            default -> super.mirror(state, mirror);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POST, NORTH_FENCE, EAST_FENCE, WEST_FENCE, SOUTH_FENCE, WATERLOGGED});
    }

    public static enum PostState implements StringRepresentable
    {
        NONE,
        POST,
        CAPPED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum FenceSide implements StringRepresentable
    {
        NONE,
        MIDDLE,
        BOTTOM,
        TOP,
        FULL;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

