/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class TrollsteinnBlock
extends Block {
    public static final int LIGHT_THRESHOLD = 7;
    private static final BooleanProperty DOWN_LIT = BooleanProperty.create((String)"down");
    private static final BooleanProperty UP_LIT = BooleanProperty.create((String)"up");
    private static final BooleanProperty NORTH_LIT = BooleanProperty.create((String)"north");
    private static final BooleanProperty SOUTH_LIT = BooleanProperty.create((String)"south");
    private static final BooleanProperty WEST_LIT = BooleanProperty.create((String)"west");
    private static final BooleanProperty EAST_LIT = BooleanProperty.create((String)"east");
    private static final Map<Direction, BooleanProperty> PROPERTY_MAP = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)DOWN_LIT).put((Object)Direction.UP, (Object)UP_LIT).put((Object)Direction.NORTH, (Object)NORTH_LIT).put((Object)Direction.SOUTH, (Object)SOUTH_LIT).put((Object)Direction.WEST, (Object)WEST_LIT).put((Object)Direction.EAST, (Object)EAST_LIT).build();
    DustParticleOptions PURPL = new DustParticleOptions(new Vector3f(0.25f, 0.0f, 0.5f), 1.0f);

    public TrollsteinnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DOWN_LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)UP_LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH_LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH_LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST_LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST_LIT, (Comparable)Boolean.valueOf(false)));
    }

    public static int calculateServerSkyDarken(Level level) {
        double rainEffect = 1.0 - (double)(level.getRainLevel(1.0f) * 5.0f) / 16.0;
        double thunderEffect = 1.0 - (double)(level.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double dayCycleEffect = 0.5 + 2.0 * Mth.clamp((double)Mth.cos((float)(level.getTimeOfDay(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        return (int)((1.0 - dayCycleEffect * rainEffect * thunderEffect) * 11.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DOWN_LIT, UP_LIT, NORTH_LIT, SOUTH_LIT, WEST_LIT, EAST_LIT});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState newState = state;
        for (Direction direction : Direction.values()) {
            newState = (BlockState)newState.setValue((Property)PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(level.getMaxLocalRawBrightness(pos.relative(direction)) > 7));
        }
        if (!newState.equals(state)) {
            level.setBlockAndUpdate(pos, newState);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int peak = 0;
        for (Direction direction : Direction.values()) {
            peak = Math.max(level.getMaxLocalRawBrightness(pos.relative(direction)), peak);
        }
        return peak;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState ret = this.defaultBlockState();
        for (Map.Entry<Direction, BooleanProperty> e : PROPERTY_MAP.entrySet()) {
            Level level = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            int light = level.getMaxLocalRawBrightness(pos.relative(e.getKey()), level.isClientSide() ? TrollsteinnBlock.calculateServerSkyDarken(level) : level.getSkyDarken());
            ret = (BlockState)ret.setValue((Property)e.getValue(), (Comparable)Boolean.valueOf(light > 7));
        }
        return ret;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (rand.nextBoolean()) {
            this.sparkle(level, pos);
        }
    }

    private void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos) || level.getMaxLocalRawBrightness(pos.relative(direction)) > 7) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.getStepZ() : (double)random.nextFloat();
            level.addParticle((ParticleOptions)this.PURPL, (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, 0.0, 0.0, 0.0);
        }
    }
}

