/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public interface SnowLoggable {
    public static final float SNOW_Z_FIGHTING = 0.008f;
    public static final int MIN_SNOW_LAYERS = 0;
    public static final int MAX_SNOW_LAYERS = 8;
    public static final IntegerProperty SNOW_LAYERS = IntegerProperty.create((String)"layers", (int)0, (int)8);
    public static final VoxelShape[] SNOW_SHAPE_BY_LAYER = (VoxelShape[])Util.make((Object)new VoxelShape[9], shapes -> {
        shapes[0] = Shapes.empty();
        for (int i = 1; i <= 8; ++i) {
            double height = (double)i * 2.0;
            shapes[i] = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        }
    });

    default public void meltSnow(BlockState state, Level level, BlockPos pos) {
        int snowLayers = (Integer)state.getValue((Property)SNOW_LAYERS);
        if (level.getBrightness(LightLayer.BLOCK, pos) > 11 && snowLayers > 0 && snowLayers < 8) {
            Block.dropResources((BlockState)((BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(snowLayers))), (Level)level, (BlockPos)pos);
            level.setBlock(pos, (BlockState)state.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0)), 2);
        }
    }

    default public void handleBreakingLogic(Level level, BlockPos pos, BlockState state, Player player, @Nullable BlockState blockToConvertTo) {
        Vec3 hitVec;
        BlockHitResult rayTraceResult = this.clip(player);
        Vec3 vec3 = hitVec = rayTraceResult.getType() == HitResult.Type.BLOCK ? rayTraceResult.getLocation() : null;
        if (hitVec != null) {
            hitVec = hitVec.add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
        }
        double snowLevel = SnowLoggable.SNOW_SHAPE_BY_LAYER[((Integer)state.getValue((Property)SnowLoggable.SNOW_LAYERS)).intValue()].bounds().maxY;
        if (hitVec != null && hitVec.y() <= snowLevel) {
            level.levelEvent(player, 2001, pos, Block.getId((BlockState)Blocks.SNOW.defaultBlockState()));
            level.setBlockAndUpdate(pos, blockToConvertTo != null ? blockToConvertTo : (BlockState)state.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0)));
        } else {
            level.levelEvent(player, 2001, pos, Block.getId((BlockState)((BlockState)state.setValue((Property)SNOW_LAYERS, (Comparable)Integer.valueOf(0)))));
            if (!player.isCreative()) {
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            level.setBlockAndUpdate(pos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)((Integer)state.getValue((Property)SNOW_LAYERS))));
        }
    }

    default public BlockHitResult clip(Player entity) {
        Vec3 startPos = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 endPos = startPos.add(entity.getLookAngle().x() * 6.0, entity.getLookAngle().y() * 6.0, entity.getLookAngle().z() * 6.0);
        ClipContext rayTraceContext = new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.level().clip(rayTraceContext);
    }

    default public boolean isColliding(Player player, BlockPos pos, BlockState state) {
        CollisionContext collisioncontext = CollisionContext.of((Entity)player);
        return !player.level().isUnobstructed(state, pos, collisioncontext);
    }
}

