/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.KillBugTrigger;
import twilightforest.components.item.JarLid;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;

public abstract class CritterBlock
extends BaseEntityBlock
implements Equipable {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    private final VoxelShape DOWN_BB = Shapes.create((AABB)new AABB((double)0.2f, (double)0.85f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f));
    private final VoxelShape UP_BB = Shapes.create((AABB)new AABB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.15f, (double)0.8f));
    private final VoxelShape NORTH_BB = Shapes.create((AABB)new AABB((double)0.2f, (double)0.2f, (double)0.85f, (double)0.8f, (double)0.8f, 1.0));
    private final VoxelShape SOUTH_BB = Shapes.create((AABB)new AABB((double)0.2f, (double)0.2f, 0.0, (double)0.8f, (double)0.8f, (double)0.15f));
    private final VoxelShape WEST_BB = Shapes.create((AABB)new AABB((double)0.85f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f, (double)0.8f));
    private final VoxelShape EAST_BB = Shapes.create((AABB)new AABB(0.0, (double)0.2f, (double)0.2f, (double)0.15f, (double)0.8f, (double)0.8f));

    protected CritterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public static boolean canSurvive(LevelReader reader, BlockPos pos, Direction facing) {
        BlockPos restingPos = pos.relative(facing.getOpposite());
        return CritterBlock.canSupportCenter((LevelReader)reader, (BlockPos)restingPos, (Direction)facing) || reader.getBlockState(restingPos).getBlock() instanceof LeavesBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> this.DOWN_BB;
            default -> this.UP_BB;
            case Direction.NORTH -> this.NORTH_BB;
            case Direction.SOUTH -> this.SOUTH_BB;
            case Direction.WEST -> this.WEST_BB;
            case Direction.EAST -> this.EAST_BB;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clicked = context.getClickedFace();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clicked);
        if (this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) {
            return state;
        }
        for (Direction dir : context.getNearestLookingDirections()) {
            state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir.getOpposite());
            if (!this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return state;
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        if (((Direction)state.getValue((Property)FACING)).getOpposite() == direction && !state.canSurvive((LevelReader)accessor, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        return CritterBlock.canSurvive(reader, pos, facing);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemContainerContents contents;
        if (stack.getItem() == TFItems.MASON_JAR.asItem() && ((contents = (ItemContainerContents)stack.getComponents().get(DataComponents.CONTAINER)) == null || contents.copyOne().isEmpty())) {
            if (this == TFBlocks.FIREFLY.get()) {
                ItemStack newStack = (ItemStack)Util.make((Object)new ItemStack((ItemLike)TFBlocks.FIREFLY_JAR.get()), jar -> jar.set((DataComponentType)TFDataComponents.JAR_LID.get(), (Object)((JarLid)stack.get((DataComponentType)TFDataComponents.JAR_LID.get()))));
                stack.consume(1, (LivingEntity)player);
                player.getInventory().add(newStack);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (this == TFBlocks.CICADA.get()) {
                ItemStack newStack = (ItemStack)Util.make((Object)new ItemStack((ItemLike)TFBlocks.CICADA_JAR.get()), jar -> jar.set((DataComponentType)TFDataComponents.JAR_LID.get(), (Object)((JarLid)stack.get((DataComponentType)TFDataComponents.JAR_LID.get()))));
                stack.consume(1, (LivingEntity)player);
                player.getInventory().add(newStack);
                if (level.isClientSide()) {
                    Minecraft.getInstance().getSoundManager().stop(((SoundEvent)TFSounds.CICADA.get()).getLocation(), SoundSource.NEUTRAL);
                }
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile && !entity.getType().is(EntityTagGenerator.DONT_KILL_BUGS) || entity instanceof FallingBlockEntity) {
            Projectile projectile;
            Entity entity2;
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (level.isClientSide()) {
                Minecraft.getInstance().getSoundManager().stop(((SoundEvent)TFSounds.CICADA.get()).getLocation(), SoundSource.NEUTRAL);
            }
            level.playSound(null, pos, (SoundEvent)TFSounds.BUG_SQUISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getSquishLootTable() != null) {
                    LootParams ctx = new LootParams.Builder(serverLevel).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK);
                    serverLevel.getServer().reloadableRegistries().getLootTable(this.getSquishLootTable()).getRandomItems(ctx).forEach(stack -> CritterBlock.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)stack));
                }
            }
            for (int i = 0; i < 50; ++i) {
                boolean wallBug = state.getValue((Property)FACING) != Direction.UP;
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()), true, (double)((float)pos.getX() + Mth.nextFloat((RandomSource)level.getRandom(), (float)0.25f, (float)0.75f)), (double)((float)pos.getY() + (wallBug ? 0.5f : 0.0f)), (double)((float)pos.getZ() + Mth.nextFloat((RandomSource)level.getRandom(), (float)0.25f, (float)0.75f)), 0.0, 0.0, 0.0);
            }
            if (entity instanceof Projectile && (entity2 = (projectile = (Projectile)entity).getOwner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                player.awardStat((ResourceLocation)TFStats.BUGS_SQUISHED.get());
                ((KillBugTrigger)((Object)TFAdvancements.KILL_BUG.get())).trigger(player, state);
            }
        }
    }

    @Nullable
    public abstract ResourceKey<LootTable> getSquishLootTable();

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

