/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.enums.BossVariant;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;

public abstract class AbstractTrophyBlock
extends BaseEntityBlock
implements Equipable {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final BossVariant variant;
    private final int comparatorValue;

    protected AbstractTrophyBlock(BossVariant variant, int value, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = variant;
        this.comparatorValue = value;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.isClientSide() && (flag = level.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            if (flag) {
                this.playSound(level, pos);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        this.playSound(level, pos);
        this.createParticle(level, pos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractTrophyBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.TROPHY.get()), TrophyBlockEntity::tick);
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void playSound(Level level, BlockPos pos) {
        BlockEntity te = level.getBlockEntity(pos);
        if (!level.isClientSide() && te instanceof TrophyBlockEntity) {
            SoundEvent sound = null;
            float volume = 1.0f;
            float pitch = 0.9f;
            switch (this.variant) {
                case NAGA: {
                    sound = (SoundEvent)TFSounds.NAGA_RATTLE.get();
                    volume = 1.25f;
                    pitch = 1.2f;
                    break;
                }
                case LICH: {
                    sound = (SoundEvent)TFSounds.LICH_AMBIENT.get();
                    volume = 0.35f;
                    pitch = 1.1f;
                    break;
                }
                case HYDRA: {
                    sound = (SoundEvent)TFSounds.HYDRA_GROWL.get();
                    pitch = 1.2f;
                    break;
                }
                case UR_GHAST: {
                    sound = (SoundEvent)TFSounds.UR_GHAST_AMBIENT.get();
                    pitch = 0.6f;
                    break;
                }
                case SNOW_QUEEN: {
                    sound = (SoundEvent)TFSounds.SNOW_QUEEN_AMBIENT.get();
                    break;
                }
                case KNIGHT_PHANTOM: {
                    sound = (SoundEvent)TFSounds.KNIGHT_PHANTOM_AMBIENT.get();
                    pitch = 1.1f;
                    break;
                }
                case MINOSHROOM: {
                    sound = (SoundEvent)TFSounds.MINOSHROOM_AMBIENT.get();
                    volume = 0.75f;
                    pitch = 0.7f;
                    break;
                }
                case ALPHA_YETI: {
                    sound = level.getRandom().nextInt(50) == 0 ? (SoundEvent)TFSounds.ALPHA_YETI_ROAR.get() : (SoundEvent)TFSounds.ALPHA_YETI_GROWL.get();
                    volume = 0.75f;
                    pitch = 0.75f;
                    break;
                }
                case QUEST_RAM: {
                    sound = (SoundEvent)TFSounds.QUEST_RAM_AMBIENT.get();
                    pitch = 0.7f;
                    break;
                }
            }
            if (sound != null) {
                level.playSound(null, pos, sound, SoundSource.BLOCKS, volume, level.getRandom().nextFloat() * 0.1f + pitch);
            }
        }
    }

    public void createParticle(Level level, BlockPos pos) {
        if (level.getBlockEntity(pos) instanceof TrophyBlockEntity && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            RandomSource rand = level.getRandom();
            ParticlePacket particlePacket = new ParticlePacket();
            switch (this.variant) {
                case NAGA: {
                    for (int daze = 0; daze < 10; ++daze) {
                        particlePacket.queueParticle((ParticleOptions)ParticleTypes.CRIT, false, (double)pos.getX() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.getY() + 0.25, (double)pos.getZ() + (double)rand.nextFloat() * 0.5 * 2.0, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02);
                    }
                    break;
                }
                case LICH: {
                    for (int a = 0; a < 5; ++a) {
                        particlePacket.queueParticle((ParticleOptions)TFParticleType.ANGRY_LICH.get(), false, (double)pos.getX() + (double)rand.nextFloat() * 0.5 * 2.0 + rand.nextGaussian() * 0.02, (double)pos.getY() + 0.5 + (double)rand.nextFloat() * 0.25 + rand.nextGaussian() * 0.02, (double)pos.getZ() + (double)rand.nextFloat() * 0.5 * 2.0 + rand.nextGaussian() * 0.02, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case MINOSHROOM: {
                    BlockParticleOption minoshroomParticle = new BlockParticleOption(ParticleTypes.BLOCK, level.getBlockState(pos.below()));
                    for (int g = 0; g < 10; ++g) {
                        particlePacket.queueParticle((ParticleOptions)minoshroomParticle, false, (double)pos.getX() + (double)(rand.nextFloat() * 10.0f) - 5.0, (double)pos.getY() + (double)0.1f + (double)(rand.nextFloat() * 0.3f), (double)pos.getZ() + (double)(rand.nextFloat() * 10.0f) - 5.0, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case KNIGHT_PHANTOM: {
                    ItemParticleOption knightPhantomParticle = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get()));
                    for (int brek = 0; brek < 10; ++brek) {
                        particlePacket.queueParticle((ParticleOptions)knightPhantomParticle, false, (double)pos.getX() + 0.5 + ((double)rand.nextFloat() - 0.5), (double)((float)pos.getY() + rand.nextFloat()) + 0.5 + 0.25 * rand.nextGaussian(), (double)pos.getZ() + 0.5 + ((double)rand.nextFloat() - 0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case UR_GHAST: {
                    for (int red = 0; red < 10; ++red) {
                        particlePacket.queueParticle((ParticleOptions)DustParticleOptions.REDSTONE, false, (double)pos.getX() + rand.nextDouble() * 1.0, (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5, (double)pos.getZ() + rand.nextDouble() * 1.0, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case ALPHA_YETI: {
                    for (int sweat = 0; sweat < 10; ++sweat) {
                        particlePacket.queueParticle((ParticleOptions)ParticleTypes.SPLASH, false, (double)pos.getX() + rand.nextDouble() * 1.0, (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5, (double)pos.getZ() + rand.nextDouble() * 1.0, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case SNOW_QUEEN: {
                    for (int b = 0; b < 20; ++b) {
                        particlePacket.queueParticle((ParticleOptions)TFParticleType.SNOW_WARNING.get(), false, (double)pos.getX() - 1.0 + rand.nextDouble() * 3.25, (double)pos.getY() + 5.0 + rand.nextGaussian(), (double)pos.getZ() - 1.0 + rand.nextDouble() * 3.25, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case QUEST_RAM: {
                    for (int p = 0; p < 10; ++p) {
                        particlePacket.queueParticle((ParticleOptions)ColorParticleOption.create((ParticleType)((ParticleType)TFParticleType.MAGIC_EFFECT.get()), (float)rand.nextFloat(), (float)rand.nextFloat(), (float)rand.nextFloat()), false, (double)pos.getX() + 0.5 + (rand.nextDouble() - 0.5), (double)pos.getY() + (rand.nextDouble() - 0.5), (double)pos.getZ() + 0.5 + (rand.nextDouble() - 0.5), rand.nextGaussian(), rand.nextGaussian(), rand.nextGaussian());
                    }
                    break;
                }
            }
            PacketDistributor.sendToPlayersNear((ServerLevel)server, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)32.0, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

