/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.market.screen;

import com.benbenlaw.market.recipe.MarketRecipe;
import com.benbenlaw.market.screen.MarketMenu;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MarketScreen
extends AbstractContainerScreen<MarketMenu> {
    Level level;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"market", (String)"textures/gui/market_gui.png");
    private int currentItemIndex = 0;
    private long lastCycleTime = 0L;
    private static final long CYCLE_INTERVAL = 1000L;

    public MarketScreen(MarketMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
    }

    protected void init() {
        super.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderOrder(guiGraphics, mouseX, mouseY, x, y);
        this.renderCurrentRecipeInformationAboveArea(guiGraphics, mouseX, mouseY, x, y);
    }

    private void renderOrder(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        Optional recipe = this.level.getRecipeManager().byKey(((MarketMenu)this.menu).blockEntity.recipeID);
        if (recipe.isPresent()) {
            ItemStack itemInput;
            MarketRecipe r = (MarketRecipe)((RecipeHolder)recipe.get()).value();
            List<ItemStack> validInputs = r.inputWithNbt().isEmpty() ? Arrays.asList(r.input().getItems()) : List.of(r.inputWithNbt());
            if (validInputs.isEmpty()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastCycleTime > 1000L) {
                this.currentItemIndex = (this.currentItemIndex + 1) % validInputs.size();
                this.lastCycleTime = currentTime;
            }
            this.currentItemIndex = Math.max(0, Math.min(this.currentItemIndex, validInputs.size() - 1));
            ItemStack validInput = validInputs.get(this.currentItemIndex);
            int inputCount = (int)((double)(validInput.getCount() + ((MarketMenu)this.menu).blockEntity.orderVariation) / ((MarketMenu)this.menu).blockEntity.demand);
            if (inputCount > validInput.getMaxStackSize()) {
                inputCount = validInput.getMaxStackSize();
            }
            if (!r.inputWithNbt().isEmpty()) {
                itemInput = new ItemStack((ItemLike)validInput.getItem(), inputCount);
                itemInput.applyComponents(validInput.getComponents());
            } else {
                itemInput = new ItemStack((ItemLike)validInput.getItem(), inputCount);
            }
            guiGraphics.renderItemDecorations(this.font, itemInput, x + 76, y + 16);
            guiGraphics.renderItem(itemInput, x + 76, y + 16);
            if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)76, (int)15, (int)16, (int)16)) {
                String tagName = "";
                SizedIngredient ingredient = r.input();
                boolean usesTags = ingredient.getItems().length > 1;
                for (ItemStack stack : ingredient.getItems()) {
                    if (!stack.getItem().getDefaultInstance().getTags().iterator().hasNext()) continue;
                    tagName = ((TagKey)stack.getItem().getDefaultInstance().getTags().iterator().next()).location().toString();
                    break;
                }
                List tooltipComponents = itemInput.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.ADVANCED);
                if (!tagName.isEmpty() && usesTags) {
                    tooltipComponents.add(Component.literal((String)("Required Tag: " + tagName)));
                }
                guiGraphics.renderTooltip(this.font, tooltipComponents, Optional.empty(), itemInput, mouseX, mouseY);
            }
            ItemStack itemOutput = new ItemStack((ItemLike)r.output().getItem(), r.output().getCount());
            guiGraphics.renderItemDecorations(this.font, itemOutput, x + 125, y + 16);
            guiGraphics.renderItem(itemOutput, x + 125, y + 16);
            if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)125, (int)15, (int)16, (int)16)) {
                guiGraphics.renderTooltip(this.font, itemOutput, mouseX, mouseY);
            }
            String demandToShow = String.valueOf(((MarketMenu)this.menu).blockEntity.demand);
            if (((MarketMenu)this.menu).blockEntity.demand > 0.2 && ((MarketMenu)this.menu).blockEntity.demand < 0.5) {
                demandToShow = ((MarketMenu)this.menu).blockEntity.demand > 0.3 ? "0.4" : "0.3";
            }
            guiGraphics.drawString(this.font, "Demand: " + demandToShow, x + 69, y + 56, 0x3F3F3F, false);
        }
    }

    private void renderCurrentRecipeInformationAboveArea(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)98, (int)15, (int)16, (int)16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Current Demand"), mouseX, mouseY);
        }
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x + 122, y + 35, 176, 30, ((MarketMenu)this.menu).getScaledProgress(), 16);
    }
}

