/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.market.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record MarketRecipe(SizedIngredient input, ItemStack inputWithNbt, Ingredient license, ItemStack output, int variation) implements Recipe<RecipeInput>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)2);
        return ingredients;
    }

    public boolean matches(RecipeInput container, @NotNull Level level) {
        for (int i = 1; i <= 9; ++i) {
            if (!this.input.test(container.getItem(i)) && this.inputWithNbt.getItem() != container.getItem(i).getItem()) continue;
            return true;
        }
        return false;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<MarketRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<MarketRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.optionalFieldOf("input", (Object)SizedIngredient.of((ItemLike)Items.AIR, (int)1)).forGetter(MarketRecipe::input), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("inputWithNbt", (Object)ItemStack.EMPTY).forGetter(MarketRecipe::inputWithNbt), (App)Ingredient.CODEC.fieldOf("license").forGetter(MarketRecipe::license), (App)ItemStack.CODEC.fieldOf("output").forGetter(MarketRecipe::output), (App)Codec.INT.fieldOf("variation").forGetter(MarketRecipe::variation)).apply((Applicative)instance, Serializer::createMarketRecipe));
        public static final StreamCodec<RegistryFriendlyByteBuf, MarketRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<MarketRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MarketRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static MarketRecipe read(RegistryFriendlyByteBuf buffer) {
            SizedIngredient input = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack inputWithNbt = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            Ingredient license = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int variation = buffer.readInt();
            return new MarketRecipe(input, inputWithNbt, license, output, variation);
        }

        private static void write(RegistryFriendlyByteBuf buffer, MarketRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputWithNbt);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.license);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.variation);
        }

        static MarketRecipe createMarketRecipe(SizedIngredient input, ItemStack inputWithNbt, Ingredient license, ItemStack output, int variation) {
            return new MarketRecipe(input, inputWithNbt, license, output, variation);
        }
    }

    public static class Type
    implements RecipeType<MarketRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

