/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.market.integration.jei;

import com.benbenlaw.market.block.ModBlocks;
import com.benbenlaw.market.integration.jei.JEIMarketPlugin;
import com.benbenlaw.market.recipe.MarketRecipe;
import java.awt.Color;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MarketRecipeCategory
implements IRecipeCategory<MarketRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"market", (String)"market");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"market", (String)"textures/gui/jei_market.png");
    static final RecipeType<MarketRecipe> RECIPE_TYPE = RecipeType.create((String)"market", (String)"market", MarketRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public MarketRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 103, 28);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.MARKET.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public RecipeType<MarketRecipe> getRecipeType() {
        return JEIMarketPlugin.MARKET_RECIPE;
    }

    public Component getTitle() {
        return Component.literal((String)"Market");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public ResourceLocation getRegistryName(MarketRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MarketRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((MarketRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MarketRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 2).addIngredients(recipe.license());
        if (recipe.inputWithNbt().getItem() != ItemStack.EMPTY.getItem()) {
            ItemStack itemStack = new ItemStack((ItemLike)recipe.inputWithNbt().getItem(), recipe.inputWithNbt().getCount());
            DataComponentMap components = recipe.inputWithNbt().getComponents();
            itemStack.applyComponents(components);
            builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addItemStack(itemStack);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.input().getItems()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 2).addItemStack(recipe.output());
    }

    public void draw(MarketRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)("Variation: +/- " + recipe.variation())), 2, 20, Color.GRAY.getRGB(), false);
    }
}

